/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.integration.crafttweaker.helpers;

import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.integration.crafttweaker.CraftTweakerIntegration;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientAny;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.Collection;
import javax.annotation.Nonnull;
import stanhebben.zenscript.annotations.Optional;

public class OneToNoneRecipes {
    protected final String name;
    protected final Collection<RecipeData> recipes;

    public OneToNoneRecipes(String name, Collection<RecipeData> recipes) {
        this.name = name;
        this.recipes = recipes;
    }

    public void remove(@Optional IIngredient item) {
        if (item == null) {
            item = IngredientAny.INSTANCE;
        }
        IIngredient finalItem = item;
        CraftTweakerIntegration.defer("Remove item(s) matching " + item + " from " + this.name, () -> {
            if (!this.recipes.removeIf(data -> {
                if (finalItem.matchesExact((IItemStack)new MCItemStack(data.getInput()))) {
                    CraftTweakerAPI.logInfo((String)(this.name + ": Removed item " + data));
                    return true;
                }
                return false;
            })) {
                CraftTweakerAPI.logError((String)(this.name + ": No item matched"));
            }
        });
    }

    public void add(@Nonnull IItemStack item) {
        if (item == null) {
            throw new IllegalArgumentException("item cannot be null");
        }
        RecipeData data = new RecipeData();
        data.setInput(CraftTweakerMC.getItemStack((IItemStack)item));
        CraftTweakerIntegration.defer("Add item " + data + " to " + this.name, () -> {
            this.recipes.add(data);
            CraftTweakerAPI.logInfo((String)(this.name + ": Added item " + data));
        });
    }
}

