/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.CustomItemRenderer;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class BlockEntityCustomItemRenderer<T extends TileEntity>
implements CustomItemRenderer {
    protected final boolean renderItemModel;
    protected final Supplier<T> initEntity;
    protected final BiConsumer<ItemStack, T> entityUpdater;
    protected T blockEntity;

    public BlockEntityCustomItemRenderer(boolean renderItemModel, Supplier<T> initEntity, BiConsumer<ItemStack, T> entityUpdater) {
        this.renderItemModel = renderItemModel;
        this.initEntity = initEntity;
        this.entityUpdater = entityUpdater;
    }

    @Override
    public void render(ItemStack itemStack) {
        if (this.blockEntity == null) {
            this.blockEntity = (TileEntity)this.initEntity.get();
            if (this.blockEntity == null) {
                throw new RuntimeException("Init entity function must not return a null block entity!");
            }
        }
        this.entityUpdater.accept(itemStack, (ItemStack)this.blockEntity);
        if (this.renderItemModel) {
            this.renderDefaultModel(itemStack);
        }
        TileEntityRendererDispatcher.field_147556_a.func_192855_a(this.blockEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
    }

    protected void renderDefaultModel(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return;
        }
        RenderItem renderer = ClientUtils.getItemRenderer();
        IBakedModel model = renderer.func_175037_a().func_178089_a(itemStack);
        renderer.func_191961_a(model, itemStack);
        if (itemStack.func_77962_s()) {
            renderer.func_191966_a(model);
        }
    }
}

