/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.core.registry.RegistryUtil;
import io.netty.buffer.ByteBuf;
import io.netty.util.collection.IntObjectHashMap;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketChannel {
    private static final HashMap<String, PacketChannel> NAME_TO_CHANNEL = new HashMap();
    private final String modid;
    private final String name;
    private final SimpleNetworkWrapper channel;
    private int index = 0;
    private final HashMap<Class<? extends BasePacket>, Integer> packet_to_index = new HashMap();
    private final IntObjectHashMap<Supplier<? extends BasePacket>> index_to_packet = new IntObjectHashMap();
    private final HashMap<Class<? extends BasePacket>, Boolean> packet_to_queued = new HashMap();

    public static PacketChannel create(String modid, String channelName) {
        boolean validActiveMod;
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidNamespace(channelName)) {
            throw new IllegalArgumentException("Channel name '" + channelName + "' must only contain characters [a-z0-9_.-]!");
        }
        String activeMod = Loader.instance().activeModContainer() == null ? null : Loader.instance().activeModContainer().getModId();
        boolean bl = validActiveMod = activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge");
        if (validActiveMod) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '" + Loader.instance().activeModContainer().getName() + "' is creating a packet channel for different modid '" + modid + "'!");
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is creating a packet channel for modid '" + modid + "'!");
        }
        return new PacketChannel(modid, channelName);
    }

    public static PacketChannel create(String modid) {
        return PacketChannel.create(modid, "main");
    }

    @Deprecated
    public static PacketChannel create() {
        ModContainer modContainer = Loader.instance().activeModContainer();
        return PacketChannel.create(modContainer == null ? "unknown" : modContainer.getModId(), "main");
    }

    private PacketChannel(String modid, String name) {
        this.modid = modid;
        this.name = name;
        this.channel = NetworkRegistry.INSTANCE.newSimpleChannel(modid + ":" + name);
        this.channel.registerMessage((IMessageHandler)new InternalPacket(this), InternalPacket.class, 0, Side.SERVER);
        this.channel.registerMessage((IMessageHandler)new InternalPacket(this), InternalPacket.class, 1, Side.CLIENT);
        NAME_TO_CHANNEL.put(modid + ":" + name, this);
    }

    public <T extends BasePacket> void registerMessage(Class<T> packetClass, Supplier<T> packetSupplier, boolean shouldBeQueued) {
        if (this.packet_to_index.containsKey(packetClass)) {
            throw new IllegalArgumentException("Class '" + packetClass + "' has already been registered!");
        }
        int index = this.index++;
        this.packet_to_index.put(packetClass, index);
        this.index_to_packet.put(index, packetSupplier);
        this.packet_to_queued.put(packetClass, shouldBeQueued);
    }

    public void sendToServer(BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.sendToServer((IMessage)new InternalPacket(this).setPacket(packet));
    }

    public void sendToPlayer(EntityPlayer player, BasePacket packet) {
        if (!(player instanceof EntityPlayerMP)) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet);
        this.channel.sendTo((IMessage)new InternalPacket(this).setPacket(packet), (EntityPlayerMP)player);
    }

    public void sendToAllPlayers(BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.sendToAll((IMessage)new InternalPacket(this).setPacket(packet));
    }

    public void sendToDimension(DimensionType dimension, BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.sendToDimension((IMessage)new InternalPacket(this).setPacket(packet), dimension.func_186068_a());
    }

    public void sendToDimension(World world, BasePacket packet) {
        if (world.field_72995_K) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToDimension(world.field_73011_w.func_186058_p(), packet);
    }

    public void sendToAllTrackingEntity(Entity entity, BasePacket packet) {
        if (entity.field_70170_p.field_72995_K) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet);
        this.channel.sendToAllTracking((IMessage)new InternalPacket(this).setPacket(packet), entity);
    }

    public void sendToAllNear(DimensionType world, double x, double y, double z, double radius, BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.sendToAllAround((IMessage)new InternalPacket(this).setPacket(packet), new NetworkRegistry.TargetPoint(world.func_186068_a(), x, y, z, radius));
    }

    public void sendToAllNear(DimensionType world, BlockPos pos, double radius, BasePacket packet) {
        this.sendToAllNear(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, radius, packet);
    }

    public void sendToAllNear(World world, double x, double y, double z, double radius, BasePacket packet) {
        if (world.field_72995_K) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToAllNear(world.field_73011_w.func_186058_p(), x, y, z, radius, packet);
    }

    public void sendToAllNear(World world, BlockPos pos, double radius, BasePacket packet) {
        if (world.field_72995_K) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToAllNear(world.field_73011_w.func_186058_p(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, radius, packet);
    }

    private void checkRegistration(BasePacket packet) {
        if (!this.packet_to_index.containsKey(packet.getClass())) {
            throw new IllegalArgumentException("Tried to send unregistered packet '" + packet.getClass() + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
    }

    private void write(BasePacket packet, PacketBuffer buffer) {
        int index = this.packet_to_index.get(packet.getClass());
        buffer.writeInt(index);
        packet.write(buffer);
    }

    private BasePacket read(PacketBuffer buffer) {
        int index = buffer.readInt();
        if (!this.index_to_packet.containsKey(index)) {
            throw new RuntimeException("Received an unregistered packet with index '" + index + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
        BasePacket packet = (BasePacket)((Supplier)this.index_to_packet.get(index)).get();
        packet.read(buffer);
        return packet;
    }

    private void handle(BasePacket packet, MessageContext messageContext) {
        PacketContext context = new PacketContext(messageContext);
        if (packet.verify(context)) {
            if (this.packet_to_queued.get(packet.getClass()).booleanValue()) {
                context.queueTask(() -> packet.handle(context));
            } else {
                packet.handle(context);
            }
        }
    }

    @Deprecated
    public static class InternalPacket
    implements IMessage,
    IMessageHandler<InternalPacket, IMessage> {
        private PacketChannel channel;
        private BasePacket packet;

        public InternalPacket() {
        }

        public InternalPacket(PacketChannel channel) {
            this.channel = channel;
        }

        private InternalPacket setPacket(BasePacket packet) {
            this.packet = packet;
            return this;
        }

        public void fromBytes(ByteBuf buffer) {
            PacketBuffer packetBuffer = new PacketBuffer(buffer);
            this.channel = (PacketChannel)NAME_TO_CHANNEL.get(packetBuffer.func_150789_c(Short.MAX_VALUE));
            if (this.channel == null) {
                throw new IllegalStateException("Couldn't find received channel name!");
            }
            this.packet = this.channel.read(packetBuffer);
        }

        public void toBytes(ByteBuf buffer) {
            PacketBuffer packetBuffer = new PacketBuffer(buffer);
            packetBuffer.func_180714_a(this.channel.modid + ":" + this.channel.name);
            this.channel.write(this.packet, packetBuffer);
        }

        public IMessage onMessage(InternalPacket message, MessageContext context) {
            this.channel.handle(message.packet, context);
            return null;
        }
    }
}

