/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.util.Pair;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TileEntity.class})
public class TileEntityMixin {
    private static NBTTagCompound compound;

    @Inject(method={"register"}, at={@At(value="HEAD")})
    private static void register(String id, Class<? extends TileEntity> clazz, CallbackInfo ci) {
        if (Registries.BLOCK_ENTITY_TYPES.hasIdentifier(new ResourceLocation(id))) {
            CoreLib.LOGGER.warn("Overlapping block entity class and block entity type registration for identifier '" + new ResourceLocation(id) + "'!");
        }
    }

    @Inject(method={"getKey"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getKey(Class<? extends TileEntity> clazz, CallbackInfoReturnable<ResourceLocation> ci) {
        if (BaseBlockEntity.class.isAssignableFrom(clazz)) {
            for (Pair<ResourceLocation, BaseBlockEntityType<?>> entry : Registries.BLOCK_ENTITY_TYPES.getEntries()) {
                if (!entry.right().containsClass(clazz)) continue;
                ci.setReturnValue(entry.left());
                return;
            }
            ci.setReturnValue(null);
        }
    }

    @Inject(method={"create"}, at={@At(value="HEAD")})
    private static void create(World worldIn, NBTTagCompound compound, CallbackInfoReturnable<TileEntity> ci) {
        TileEntityMixin.compound = compound;
    }

    @ModifyVariable(method={"create"}, at=@At(value="STORE"), ordinal=0)
    private static TileEntity createModifyEntity(TileEntity entity) {
        ResourceLocation identifier;
        String id;
        if (compound.func_150297_b("id", 8) && RegistryUtil.isValidIdentifier(id = compound.func_74779_i("id")) && Registries.BLOCK_ENTITY_TYPES.hasIdentifier(identifier = new ResourceLocation(id))) {
            return Registries.BLOCK_ENTITY_TYPES.getValue(identifier).createBlockEntity();
        }
        return entity;
    }

    @Redirect(method={"writeInternal"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/registry/RegistryNamespaced;getNameForObject(Ljava/lang/Object;)Ljava/lang/Object;"))
    private Object writeInternalRedirect(RegistryNamespaced<Object, Object> registry, Object clazz) {
        if (this instanceof BaseBlockEntity) {
            return Registries.BLOCK_ENTITY_TYPES.getIdentifier(((BaseBlockEntity)((Object)this)).getType());
        }
        return registry.func_177774_c(clazz);
    }
}

