/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.supermartijn642.core.data.LanguageLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.Locale;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Locale.class})
public class LocaleMixin {
    @Redirect(method={"loadLocaleDataFiles"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/IResourceManager;getAllResources(Lnet/minecraft/util/ResourceLocation;)Ljava/util/List;"))
    private List<IResource> loadLocaleDataFilesRedirect(IResourceManager resourceManager, ResourceLocation resourceLocation) throws IOException {
        return LanguageLoader.findAllResources(resourceManager, resourceLocation);
    }

    @Redirect(method={"loadLocaleData(Ljava/util/List;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/IResource;getInputStream()Ljava/io/InputStream;"))
    private InputStream loadLocaleDataRedirect(IResource resource) {
        if (resource.func_177241_a().func_110623_a().endsWith(".json")) {
            LanguageLoader.loadLanguageJson(((Locale)this).field_135032_a, resource);
            return null;
        }
        return resource.func_110527_b();
    }

    @Inject(method={"loadLocaleData(Ljava/io/InputStream;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void loadLocaleData(InputStream inputStream, CallbackInfo ci) {
        if (inputStream == null) {
            ci.cancel();
        }
    }
}

