/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.item;

import com.supermartijn642.core.item.ItemProperties;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaseItem
extends Item {
    private final ItemProperties properties;
    private final CreativeTabs[] groups;

    public BaseItem(ItemProperties properties) {
        this.properties = properties;
        this.groups = properties.groups.toArray(new CreativeTabs[0]);
        this.func_77625_d(properties.maxStackSize);
        this.func_77656_e(properties.durability);
        if (!properties.groups.isEmpty()) {
            this.func_77637_a(properties.groups.iterator().next());
        }
        this.func_77642_a(properties.craftingRemainingItem);
    }

    protected void appendItemInformation(ItemStack stack, @Nullable IBlockAccess level, Consumer<ITextComponent> info, boolean advanced) {
    }

    public ItemUseResult interact(ItemStack stack, EntityPlayer player, EnumHand hand, World level) {
        return ItemUseResult.fromUnderlying((ActionResult<ItemStack>)super.func_77659_a(level, player, hand));
    }

    public InteractionFeedback interactWithBlockFirst(ItemStack stack, EntityPlayer player, EnumHand hand, World level, BlockPos hitPos, EnumFacing hitSide, Vec3d hitLocation) {
        return InteractionFeedback.PASS;
    }

    public InteractionFeedback interactWithBlock(ItemStack stack, EntityPlayer player, EnumHand hand, World level, BlockPos hitPos, EnumFacing hitSide, Vec3d hitLocation) {
        return InteractionFeedback.PASS;
    }

    public InteractionFeedback interactWithEntity(ItemStack stack, EntityLivingBase target, EntityPlayer player, EnumHand hand) {
        return InteractionFeedback.PASS;
    }

    public void inventoryUpdate(ItemStack stack, World level, Entity entity, int itemSlot, boolean isSelected) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World level, List<String> information, ITooltipFlag flag) {
        this.appendItemInformation(stack, (IBlockAccess)level, component -> information.add(component.func_150254_d()), flag.func_194127_a());
        super.func_77624_a(stack, level, information, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World level, EntityPlayer player, EnumHand hand) {
        return this.interact(player.func_184586_b(hand), player, hand, level).toUnderlying();
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        return this.interactWithEntity(stack, target, player, hand).consumesAction();
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World level, BlockPos pos, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        return this.interactWithBlock(player.func_184586_b(hand), player, hand, level, pos, hitSide, new Vec3d((double)hitX, (double)hitY, (double)hitZ)).interactionResult;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World level, BlockPos pos, EnumFacing hitSide, float hitX, float hitY, float hitZ, EnumHand hand) {
        return this.interactWithBlockFirst(player.func_184586_b(hand), player, hand, level, pos, hitSide, new Vec3d((double)hitX, (double)hitY, (double)hitZ)).interactionResult;
    }

    public void func_77663_a(ItemStack stack, World level, Entity entity, int slot, boolean isSelected) {
        this.inventoryUpdate(stack, level, entity, slot, isSelected);
    }

    public boolean isInCreativeGroup(CreativeTabs tab) {
        return this.properties.groups.contains(tab);
    }

    public CreativeTabs[] getCreativeTabs() {
        return this.groups;
    }

    public boolean isFireResistant() {
        return this.properties != null && this.properties.isFireResistant;
    }

    public boolean canBeHurtBy(DamageSource source) {
        return !this.isFireResistant() || !source.func_76347_k();
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return this.properties.rarity;
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74837_a((String)this.func_77667_c(stack), (Object[])new Object[0]).trim();
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public String func_77658_a() {
        return this.getRegistryName().func_110624_b() + ".item." + this.getRegistryName().func_110623_a();
    }

    public static enum InteractionFeedback {
        PASS(EnumActionResult.PASS),
        CONSUME(EnumActionResult.SUCCESS),
        SUCCESS(EnumActionResult.SUCCESS);

        private final EnumActionResult interactionResult;

        private InteractionFeedback(EnumActionResult interactionResult) {
            this.interactionResult = interactionResult;
        }

        private boolean consumesAction() {
            return this == SUCCESS || this == CONSUME;
        }
    }

    protected static class ItemUseResult {
        private final EnumActionResult result;
        private final ItemStack resultingStack;

        public static ItemUseResult pass(ItemStack stack) {
            return new ItemUseResult(EnumActionResult.SUCCESS, stack);
        }

        public static ItemUseResult consume(ItemStack stack) {
            return new ItemUseResult(EnumActionResult.SUCCESS, stack);
        }

        public static ItemUseResult success(ItemStack stack) {
            return new ItemUseResult(EnumActionResult.SUCCESS, stack);
        }

        public static ItemUseResult fail(ItemStack stack) {
            return new ItemUseResult(EnumActionResult.FAIL, stack);
        }

        @Deprecated
        public static ItemUseResult fromUnderlying(ActionResult<ItemStack> underlying) {
            return new ItemUseResult(underlying.func_188397_a(), (ItemStack)underlying.func_188398_b());
        }

        private ItemUseResult(EnumActionResult result, ItemStack resultingStack) {
            this.result = result;
            this.resultingStack = resultingStack;
        }

        @Deprecated
        public ActionResult<ItemStack> toUnderlying() {
            return new ActionResult(this.result, (Object)this.resultingStack);
        }
    }
}

