/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;

public abstract class LanguageGenerator
extends ResourceGenerator {
    private final Map<String, String> translations = new HashMap<String, String>();
    protected final String langCode;

    public LanguageGenerator(String modid, ResourceCache cache, String langCode) {
        super(modid, cache);
        if (!langCode.matches("[a-z]{2}_[a-z]{2}")) {
            throw new IllegalArgumentException("Invalid lang code '" + langCode + "'!");
        }
        this.langCode = langCode;
    }

    @Override
    public void save() {
        JsonObject object = new JsonObject();
        this.translations.forEach((arg_0, arg_1) -> ((JsonObject)object).addProperty(arg_0, arg_1));
        this.cache.saveJsonResource(ResourceType.ASSET, object, this.modid, "lang", this.langCode);
    }

    protected void translation(String translationKey, String translation) {
        if (translationKey.trim().isEmpty()) {
            throw new IllegalArgumentException("Translation key '" + translation + "' for translation '" + translation + "' must not be empty!");
        }
        this.translations.put(translationKey, translation);
    }

    protected void itemGroup(CreativeTabs group, String translation) {
        this.translation(group.func_78024_c(), translation);
    }

    protected void item(Item item, String translation) {
        this.translation(item.func_77658_a(), translation);
    }

    protected void block(Block block, String translation) {
        this.translation(block.func_149739_a(), translation);
    }

    @Override
    public String getName() {
        return this.modName + " Language Generator";
    }
}

