/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.common.base.Stopwatch;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.generator.GatherDataEvent;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.client.FMLFolderResourcePack;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GeneratorManager {
    private static final List<ResourceGenerator> GENERATORS = new ArrayList<ResourceGenerator>();

    public static void gatherAndRunGenerators(String modid, String outputFolder, String existingFolder) {
        File outputFolderFile = new File(outputFolder);
        File existingFolderFile = new File(existingFolder);
        if (!outputFolderFile.exists()) {
            outputFolderFile.mkdirs();
        }
        ResourceCache cache = ResourceCache.create(outputFolderFile.toPath(), existingFolderFile.toPath());
        for (FallbackResourceManager resourceManager : ((SimpleReloadableResourceManager)ClientUtils.getMinecraft().func_110442_L()).field_110548_a.values()) {
            resourceManager.field_110540_a.removeIf(pack -> pack instanceof FMLFileResourcePack && modid.equals(((FMLFileResourcePack)pack).getFMLContainer().getModId()) || pack instanceof FMLFolderResourcePack && modid.equals(((FMLFolderResourcePack)pack).getFMLContainer().getModId()));
        }
        GatherDataEvent event = new GatherDataEvent(cache, GENERATORS::add);
        MinecraftForge.EVENT_BUS.post((Event)event);
        GENERATORS.removeIf(generator -> !modid.equals(generator.getOwnerModid()));
        CoreLib.LOGGER.info("Found " + GENERATORS.size() + " generators for modid '" + modid + "'");
        try {
            Stopwatch stopwatch = Stopwatch.createUnstarted();
            Stopwatch totalStopwatch = Stopwatch.createStarted();
            for (ResourceGenerator generator2 : GENERATORS) {
                CoreLib.LOGGER.info("Starting generator '" + generator2.getName() + "'...");
                stopwatch.start();
                generator2.generate();
                stopwatch.stop();
                CoreLib.LOGGER.info("Generator '" + generator2.getName() + "' finished after " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms");
                stopwatch.reset();
            }
            for (ResourceGenerator generator2 : GENERATORS) {
                CoreLib.LOGGER.info("Saving generator '" + generator2.getName() + "'...");
                stopwatch.start();
                generator2.save();
                stopwatch.stop();
                CoreLib.LOGGER.info("Generator '" + generator2.getName() + "' took " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms to save");
                stopwatch.reset();
            }
            totalStopwatch.stop();
            CoreLib.LOGGER.info("All generators for modid '" + modid + "' took " + totalStopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms");
        }
        catch (Exception e) {
            CoreLib.LOGGER.error("Encountered an exception when running generators!", (Throwable)e);
            return;
        }
        ((ResourceCache.Impl)cache).removeRemnants();
        ((ResourceCache.Impl)cache).writeCacheToFile();
    }
}

