/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ModLoadedResourceCondition;
import com.supermartijn642.core.data.condition.NotResourceCondition;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditions;
import com.supermartijn642.core.extensions.ICriterionInstanceExtension;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NBTPredicate;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public abstract class AdvancementGenerator
extends ResourceGenerator {
    private final Map<ResourceLocation, AdvancementBuilder> advancements = new HashMap<ResourceLocation, AdvancementBuilder>();

    public AdvancementGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (AdvancementBuilder advancementBuilder : this.advancements.values()) {
            if (advancementBuilder.criteria.isEmpty()) {
                throw new RuntimeException("Advancement '" + advancementBuilder.identifier + "' does not have any criteria!");
            }
            if (advancementBuilder.requirements.isEmpty()) {
                if (advancementBuilder.criteria.size() != 1) {
                    throw new RuntimeException("Advancement '" + advancementBuilder.identifier + "' does not have any requirements set!");
                }
                advancementBuilder.requirements.add(advancementBuilder.criteria.keySet().toArray(new String[0]));
            }
            for (String criterion2 : (String[])advancementBuilder.requirements.stream().flatMap(Arrays::stream).toArray(String[]::new)) {
                if (advancementBuilder.criteria.containsKey(criterion2)) continue;
                throw new RuntimeException("Found requirement for unknown criterion '" + criterion2 + "' in advancement '" + advancementBuilder.identifier + "'!");
            }
            JsonObject json = new JsonObject();
            if (!advancementBuilder.conditions.isEmpty()) {
                JsonArray conditionsJson = new JsonArray();
                for (ResourceCondition condition : advancementBuilder.conditions) {
                    JsonObject conditionJson = new JsonObject();
                    conditionJson.addProperty("type", ResourceConditions.getIdentifierForSerializer(condition.getSerializer()).toString());
                    condition.getSerializer().serialize(conditionJson, condition);
                    conditionsJson.add((JsonElement)conditionJson);
                }
                json.add("conditions", (JsonElement)conditionsJson);
            }
            if (advancementBuilder.parent != null) {
                ResourceLocation parent = advancementBuilder.parent;
                if (!this.advancements.containsKey(parent) && !this.cache.doesResourceExist(ResourceType.ASSET, parent.func_110624_b(), "advancements", parent.func_110623_a(), ".json")) {
                    throw new RuntimeException("Could not find parent '" + parent + "' for advancement '" + advancementBuilder.identifier + "'!");
                }
                json.addProperty("parent", parent.toString());
            }
            JsonObject displayJson = new JsonObject();
            if (advancementBuilder.icon == null && !new ResourceLocation("minecraft", "recipes/root").equals((Object)advancementBuilder.parent)) {
                throw new RuntimeException("Advancement '" + advancementBuilder.identifier + "' must have an icon!");
            }
            if (advancementBuilder.icon != null) {
                JsonObject iconJson = new JsonObject();
                iconJson.addProperty("item", Registries.ITEMS.getIdentifier(advancementBuilder.icon).toString());
                if (advancementBuilder.iconTag != null) {
                    iconJson.addProperty("nbt", advancementBuilder.iconTag.toString());
                }
                displayJson.add("icon", (JsonElement)iconJson);
            }
            JsonObject titleJson = new JsonObject();
            titleJson.addProperty("translate", advancementBuilder.titleKey);
            displayJson.add("title", (JsonElement)titleJson);
            JsonObject description = new JsonObject();
            description.addProperty("translate", advancementBuilder.descriptionKey);
            displayJson.add("description", (JsonElement)description);
            displayJson.addProperty("frame", advancementBuilder.frame.func_192307_a());
            if (advancementBuilder.background != null) {
                if (!this.cache.doesResourceExist(ResourceType.ASSET, advancementBuilder.background.func_110624_b(), "textures", advancementBuilder.background.func_110623_a(), ".png")) {
                    throw new RuntimeException("Could not find background texture '" + advancementBuilder.background + "' for advancement '" + advancementBuilder.identifier + "'!");
                }
                displayJson.addProperty("background", advancementBuilder.background.toString());
            }
            displayJson.addProperty("show_toast", Boolean.valueOf(advancementBuilder.showToast));
            displayJson.addProperty("announce_to_chat", Boolean.valueOf(advancementBuilder.announceToChat));
            displayJson.addProperty("hidden", Boolean.valueOf(advancementBuilder.hidden));
            json.add("display", (JsonElement)displayJson);
            JsonObject criteriaJson = new JsonObject();
            for (Map.Entry entry : advancementBuilder.criteria.entrySet()) {
                JsonObject criterionJson = new JsonObject();
                criterionJson.addProperty("trigger", ((ICriterionInstance)entry.getValue()).func_192244_a().toString());
                JsonObject conditionsJson = new JsonObject();
                ((ICriterionInstanceExtension)entry.getValue()).coreLibSerialize(conditionsJson);
                if (conditionsJson.size() > 0) {
                    criterionJson.add("conditions", (JsonElement)conditionsJson);
                }
                criteriaJson.add((String)entry.getKey(), (JsonElement)criterionJson);
            }
            json.add("criteria", (JsonElement)criteriaJson);
            JsonArray requirementsArray = new JsonArray();
            for (String[] requirementGroup : advancementBuilder.requirements) {
                JsonArray groupArray = new JsonArray();
                Arrays.stream(requirementGroup).forEach(arg_0 -> ((JsonArray)groupArray).add(arg_0));
                requirementsArray.add((JsonElement)groupArray);
            }
            json.add("requirements", (JsonElement)requirementsArray);
            JsonObject jsonObject = new JsonObject();
            if (!advancementBuilder.rewardRecipes.isEmpty()) {
                JsonArray recipesJson = new JsonArray();
                for (ResourceLocation rewardRecipe : advancementBuilder.rewardRecipes) {
                    if (!this.cache.doesResourceExist(ResourceType.ASSET, rewardRecipe.func_110624_b(), "recipes", rewardRecipe.func_110623_a(), ".json")) {
                        throw new RuntimeException("Could not find reward recipe '" + rewardRecipe + "' for advancement '" + advancementBuilder.identifier + "'!");
                    }
                    recipesJson.add(rewardRecipe.toString());
                }
                jsonObject.add("recipes", (JsonElement)recipesJson);
            }
            if (!advancementBuilder.rewardLootTables.isEmpty()) {
                JsonArray lootTablesJson = new JsonArray();
                for (ResourceLocation rewardLootTable : advancementBuilder.rewardLootTables) {
                    if (!this.cache.doesResourceExist(ResourceType.ASSET, rewardLootTable.func_110624_b(), "loot_tables", rewardLootTable.func_110623_a(), ".json")) {
                        throw new RuntimeException("Could not find reward loot table '" + rewardLootTable + "' for advancement '" + advancementBuilder.identifier + "'!");
                    }
                    lootTablesJson.add(rewardLootTable.toString());
                }
                jsonObject.add("loot", (JsonElement)lootTablesJson);
            }
            if (advancementBuilder.rewardExperience != 0) {
                jsonObject.addProperty("experience", (Number)advancementBuilder.rewardExperience);
            }
            if (jsonObject.size() != 0) {
                json.add("rewards", (JsonElement)jsonObject);
            }
            ResourceLocation identifier = advancementBuilder.identifier;
            this.cache.saveJsonResource(ResourceType.ASSET, json, identifier.func_110624_b(), "advancements", identifier.func_110623_a());
        }
    }

    public AdvancementBuilder advancement(ResourceLocation identifier) {
        if (this.advancements.containsKey(identifier)) {
            throw new RuntimeException("Duplicate advancement with identifier '" + identifier + "'!");
        }
        this.cache.trackToBeGeneratedResource(ResourceType.ASSET, identifier.func_110624_b(), "advancements", identifier.func_110623_a(), ".json");
        return this.advancements.computeIfAbsent(identifier, i -> new AdvancementBuilder(this.modid, (ResourceLocation)i));
    }

    public AdvancementBuilder advancement(String namespace, String path) {
        return this.advancement(new ResourceLocation(namespace, path));
    }

    public AdvancementBuilder advancement(String identifier) {
        return this.advancement(this.modid, identifier);
    }

    @Override
    public String getName() {
        return this.modName + " Advancement Generator";
    }

    protected static class AdvancementBuilder {
        protected final String modid;
        protected final ResourceLocation identifier;
        private final List<ResourceCondition> conditions = new ArrayList<ResourceCondition>();
        private final Map<String, ICriterionInstance> criteria = new HashMap<String, ICriterionInstance>();
        private final List<String[]> requirements = new ArrayList<String[]>();
        private final List<ResourceLocation> rewardLootTables = new ArrayList<ResourceLocation>();
        private final List<ResourceLocation> rewardRecipes = new ArrayList<ResourceLocation>();
        private ResourceLocation parent;
        private Item icon;
        private NBTTagCompound iconTag;
        private String titleKey;
        private String descriptionKey;
        private FrameType frame = FrameType.TASK;
        private ResourceLocation background;
        private boolean showToast = true;
        private boolean announceToChat = true;
        private boolean hidden;
        private int rewardExperience;

        public AdvancementBuilder(String modid, ResourceLocation identifier) {
            this.modid = modid;
            this.identifier = identifier;
            this.titleKey = identifier.func_110624_b() + ".advancement." + identifier.func_110623_a() + ".title";
            this.descriptionKey = identifier.func_110624_b() + ".advancement." + identifier.func_110623_a() + ".description";
        }

        public AdvancementBuilder condition(ResourceCondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public AdvancementBuilder notCondition(ResourceCondition condition) {
            return this.condition(new NotResourceCondition(condition));
        }

        public AdvancementBuilder modLoadedCondition(String modid) {
            return this.condition(new ModLoadedResourceCondition(modid));
        }

        public AdvancementBuilder parent(ResourceLocation advancement) {
            if (this.identifier.equals((Object)advancement)) {
                throw new IllegalArgumentException("Advancement '" + this.identifier + "' cannot have itself as parent!");
            }
            this.parent = advancement;
            return this;
        }

        public AdvancementBuilder parent(String namespace, String path) {
            return this.parent(new ResourceLocation(namespace, path));
        }

        public AdvancementBuilder parent(String advancement) {
            return this.parent(this.modid, advancement);
        }

        public AdvancementBuilder icon(Item item, NBTTagCompound tag) {
            this.icon = item;
            this.iconTag = tag;
            return this;
        }

        public AdvancementBuilder icon(Item item) {
            return this.icon(item, null);
        }

        public AdvancementBuilder icon(ResourceLocation item) {
            if (!Registries.ITEMS.hasIdentifier(item)) {
                throw new IllegalArgumentException("Could not find any item registered under '" + item + "'!");
            }
            return this.icon(Registries.ITEMS.getValue(item), null);
        }

        public AdvancementBuilder icon(String namespace, String identifier) {
            return this.icon(new ResourceLocation(namespace, identifier));
        }

        public AdvancementBuilder title(String translationKey) {
            if (translationKey == null || translationKey.trim().isEmpty()) {
                throw new IllegalArgumentException("Title translation key '" + translationKey + "' for advancement '" + this.identifier + "' must not be empty!");
            }
            this.titleKey = translationKey;
            return this;
        }

        public AdvancementBuilder description(String translationKey) {
            if (translationKey == null || translationKey.trim().isEmpty()) {
                throw new IllegalArgumentException("Description translation key '" + translationKey + "' for advancement '" + this.identifier + "' must not be empty!");
            }
            this.descriptionKey = translationKey;
            return this;
        }

        public AdvancementBuilder frame(FrameType frameType) {
            this.frame = frameType;
            return this;
        }

        public AdvancementBuilder challengeFrame() {
            return this.frame(FrameType.CHALLENGE);
        }

        public AdvancementBuilder goalFrame() {
            return this.frame(FrameType.GOAL);
        }

        public AdvancementBuilder taskFrame() {
            return this.frame(FrameType.TASK);
        }

        public AdvancementBuilder background(ResourceLocation texture) {
            this.background = texture;
            return this;
        }

        public AdvancementBuilder background(String namespace, String path) {
            return this.background(new ResourceLocation(namespace, path));
        }

        public AdvancementBuilder showToast(boolean show) {
            this.showToast = show;
            return this;
        }

        public AdvancementBuilder dontShowToast() {
            return this.showToast(false);
        }

        public AdvancementBuilder announceToChat(boolean announce) {
            this.announceToChat = announce;
            return this;
        }

        public AdvancementBuilder dontAnnounceToChat() {
            return this.announceToChat(false);
        }

        public AdvancementBuilder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public AdvancementBuilder hidden() {
            return this.hidden(true);
        }

        public AdvancementBuilder criterion(String name, ICriterionInstance criterion) {
            if (this.criteria.containsKey(name)) {
                throw new RuntimeException("Duplicate criterion with name '" + name + "' for advancement '" + this.identifier + "'!");
            }
            this.criteria.put(name, criterion);
            return this;
        }

        public AdvancementBuilder hasItemsCriterion(String name, Item ... items) {
            this.criterion(name, (ICriterionInstance)new InventoryChangeTrigger.Instance(MinMaxBounds.field_192516_a, MinMaxBounds.field_192516_a, MinMaxBounds.field_192516_a, (ItemPredicate[])Arrays.stream(items).map(item -> new ItemPredicate(item, Integer.valueOf(0), MinMaxBounds.field_192516_a, MinMaxBounds.field_192516_a, new EnchantmentPredicate[0], null, NBTPredicate.field_193479_a)).toArray(ItemPredicate[]::new)));
            return this;
        }

        public AdvancementBuilder requirementGroup(String ... criteria) {
            if (this.requirements.contains(criteria)) {
                throw new RuntimeException("Duplicate requirement group '" + Arrays.toString(criteria) + "' for advancement '" + this.identifier + "'!");
            }
            this.requirements.add(criteria);
            return this;
        }

        public AdvancementBuilder requirements(String[] ... groups) {
            Arrays.stream(groups).forEach(this::requirementGroup);
            return this;
        }

        public AdvancementBuilder rewardExperience(int experience) {
            if (experience < 0) {
                throw new IllegalArgumentException("Reward experience for advancement '" + this.identifier + "' must be greater than 0, not '" + experience + "'!");
            }
            this.rewardExperience = experience;
            return this;
        }

        public AdvancementBuilder rewardLootTable(ResourceLocation lootTable) {
            this.rewardLootTables.add(lootTable);
            return this;
        }

        public AdvancementBuilder rewardLootTable(String namespace, String path) {
            return this.rewardLootTable(new ResourceLocation(namespace, path));
        }

        public AdvancementBuilder rewardRecipe(ResourceLocation recipe) {
            if (this.rewardRecipes.contains(recipe)) {
                throw new RuntimeException("Duplicate recipe reward '" + recipe + "' for advancement '" + this.identifier + "'!");
            }
            this.rewardRecipes.add(recipe);
            return this;
        }

        public AdvancementBuilder rewardRecipe(String namespace, String path) {
            return this.rewardRecipe(new ResourceLocation(namespace, path));
        }
    }
}

