/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.IOUtils;

public class TagLoader {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final Map<String, Registries.Registry<?>> TAG_TYPES = new HashMap();
    private static final Map<Registries.Registry<?>, Map<ResourceLocation, Set<ResourceLocation>>> TAGS = new HashMap();

    public static void loadTags() {
        Loader.instance().getActiveModList().forEach(TagLoader::loadTags);
        CoreLib.LOGGER.info("Loaded '" + TAGS.getOrDefault(Registries.BLOCKS, Collections.emptyMap()).keySet().size() + "' block tags");
        CoreLib.LOGGER.info("Loaded '" + TAGS.getOrDefault(Registries.ITEMS, Collections.emptyMap()).keySet().size() + "' item tags");
    }

    /*
     * Unable to fully structure code
     */
    private static void loadTags(ModContainer mod) {
        block43: {
            block42: {
                source = mod.getSource();
                if ("minecraft".equals(mod.getModId())) {
                    return;
                }
                fs = null;
                root = null;
                if (!source.isFile()) break block42;
                try {
                    fs = FileSystems.newFileSystem(source.toPath(), (ClassLoader)null);
                    root = fs.getPath("/data", new String[0]);
                    ** GOTO lbl20
                }
                catch (IOException e) {
                    CoreLib.LOGGER.error("Error loading FileSystem from jar!", (Throwable)e);
                    IOUtils.closeQuietly((Closeable)fs);
                    return;
                }
            }
            if (source.isDirectory()) {
                root = source.toPath().resolve("data");
            }
lbl20:
            // 4 sources

            if (root != null && Files.exists(root, new LinkOption[0])) break block43;
            IOUtils.closeQuietly((Closeable)fs);
            return;
        }
        try {
            stream = Files.walk(root, 1, new FileVisitOption[0]);
            var6_8 = null;
            try {
                namespaceFolders = stream.filter(Predicate.isEqual(root).negate()).collect(Collectors.toList());
            }
            catch (Throwable var7_10) {
                var6_8 = var7_10;
                throw var7_10;
            }
            finally {
                if (stream != null) {
                    if (var6_8 != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable var7_9) {
                            var6_8.addSuppressed(var7_9);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
            for (Path namespaceFolder : namespaceFolders) {
                if (!Files.isDirectory(namespaceFolder, new LinkOption[0]) || !RegistryUtil.isValidNamespace(namespace = (fileName = namespaceFolder.getFileName().toString()).endsWith("/") != false ? fileName.substring(0, fileName.length() - 1) : fileName) || !Files.exists(tagsFolder = namespaceFolder.resolve("tags"), new LinkOption[0]) || !Files.isDirectory(tagsFolder, new LinkOption[0])) continue;
                for (Map.Entry<String, Registries.Registry<?>> tagType : TagLoader.TAG_TYPES.entrySet()) {
                    tagTypeFolder = tagsFolder.resolve(tagType.getKey());
                    if (!Files.exists(tagTypeFolder, new LinkOption[0]) || !Files.isDirectory(tagTypeFolder, new LinkOption[0])) continue;
                    references = new HashMap<K, V>();
                    optionalReferences = new HashMap<K, V>();
                    removeEntries = new HashMap<K, V>();
                    paths = Files.walk(tagTypeFolder, new FileVisitOption[0]);
                    var17_23 = null;
                    try {
                        paths.forEach((Consumer<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$loadTags$3(java.nio.file.Path java.lang.String java.util.Map$Entry net.minecraftforge.fml.common.ModContainer java.util.Map java.util.Map java.util.Map java.nio.file.Path ), (Ljava/nio/file/Path;)V)((Path)tagTypeFolder, (String)namespace, tagType, (ModContainer)mod, references, optionalReferences, removeEntries));
                    }
                    catch (Throwable var18_26) {
                        var17_23 = var18_26;
                        throw var18_26;
                    }
                    finally {
                        if (paths != null) {
                            if (var17_23 != null) {
                                try {
                                    paths.close();
                                }
                                catch (Throwable var18_25) {
                                    var17_23.addSuppressed(var18_25);
                                }
                            } else {
                                paths.close();
                            }
                        }
                    }
                    block28: for (Map.Entry<K, V> entry : references.entrySet()) {
                        for (ResourceLocation reference : (Set)entry.getValue()) {
                            if (!TagLoader.TAGS.get(tagType.getValue()).containsKey(reference)) {
                                CoreLib.LOGGER.warn("Tag file '" + reference.func_110624_b() + ":" + tagType.getKey() + "/" + reference.func_110623_a() + ".json' from mod '" + mod.getName() + "' references unknown tag '" + reference + "'!");
                                TagLoader.TAGS.get(tagType.getValue()).get(entry.getKey()).clear();
                                continue block28;
                            }
                            TagLoader.TAGS.get(tagType.getValue()).get(entry.getKey()).addAll((Collection<ResourceLocation>)TagLoader.TAGS.get(tagType.getValue()).get(reference));
                        }
                    }
                    for (Map.Entry<K, V> entry : optionalReferences.entrySet()) {
                        for (ResourceLocation reference : (Set)entry.getValue()) {
                            if (!TagLoader.TAGS.get(tagType.getValue()).containsKey(reference)) continue;
                            TagLoader.TAGS.get(tagType.getValue()).get(entry.getKey()).addAll((Collection<ResourceLocation>)TagLoader.TAGS.get(tagType.getValue()).get(reference));
                        }
                    }
                    for (Map.Entry<K, V> entry : removeEntries.entrySet()) {
                        TagLoader.TAGS.get(tagType.getValue()).get(entry.getKey()).removeAll((Collection)entry.getValue());
                    }
                }
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Encountered an exception whilst loading tags for mod '" + mod.getName() + "'!", e);
            }
            catch (Throwable var21_30) {
                IOUtils.closeQuietly(fs);
                throw var21_30;
            }
        }
        IOUtils.closeQuietly((Closeable)fs);
    }

    private static void readTagFile(ModContainer mod, ResourceLocation identifier, Path file, String registryName, Registries.Registry<?> registry, Set<ResourceLocation> references, Set<ResourceLocation> optionalReferences, Set<ResourceLocation> removeEntries) {
        JsonObject json;
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(file, new OpenOption[0]), StandardCharsets.UTF_8);){
            json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JsonSyntaxException e) {
            CoreLib.LOGGER.error("Malformed tag json '" + identifier.func_110624_b() + ":" + registryName + "/" + identifier.func_110623_a() + ".json' in mod '" + mod.getName() + "'!", (Throwable)e);
            return;
        }
        Set tagEntries = TAGS.computeIfAbsent(registry, r -> new HashMap()).computeIfAbsent(identifier, i -> new HashSet());
        try {
            ResourceLocation entryIdentifier;
            boolean replace;
            if (!(!json.has("required") || json.get("required").isJsonPrimitive() && json.get("required").getAsJsonPrimitive().isBoolean())) {
                throw new RuntimeException("'replace' must be a boolean!");
            }
            boolean bl = replace = json.has("replace") && json.get("replace").getAsBoolean();
            if (replace) {
                tagEntries.clear();
            }
            ArrayList<String> entries = new ArrayList<String>();
            ArrayList<String> optionalEntries = new ArrayList<String>();
            if (json.has("values")) {
                if (!json.get("values").isJsonArray()) {
                    throw new RuntimeException("'values' must be an array!");
                }
                json.get("values").getAsJsonArray().forEach(element -> {
                    if (element.isJsonObject()) {
                        JsonObject object = element.getAsJsonObject();
                        if (!(object.has("id") && object.get("id").isJsonPrimitive() && object.get("id").getAsJsonPrimitive().isString())) {
                            throw new RuntimeException("Entries in 'values' must contain key 'id'!");
                        }
                        if (!(!object.has("required") || object.get("required").isJsonPrimitive() && object.get("required").getAsJsonPrimitive().isBoolean())) {
                            throw new RuntimeException("Key 'required' for entries in 'values' must be a boolean!");
                        }
                        if (!object.has("required") || object.get("required").getAsBoolean()) {
                            entries.add(element.getAsJsonObject().get("id").getAsString());
                        } else {
                            optionalEntries.add(element.getAsJsonObject().get("id").getAsString());
                        }
                    } else if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                        entries.add(element.getAsString());
                    } else {
                        throw new RuntimeException("'values' must only contain objects and strings!");
                    }
                });
            }
            ArrayList rawReferences = new ArrayList();
            entries.stream().filter(s -> s.charAt(0) == '#').map(s -> s.substring(1)).forEach(rawReferences::add);
            entries.removeIf(s -> s.charAt(0) == '#');
            ArrayList rawOptionalReferences = new ArrayList();
            optionalEntries.stream().filter(s -> s.charAt(0) == '#').map(s -> s.substring(1)).forEach(rawOptionalReferences::add);
            optionalEntries.removeIf(s -> s.charAt(0) == '#');
            ArrayList remove = new ArrayList();
            ArrayList optionalRemove = new ArrayList();
            if (json.has("remove")) {
                if (!json.get("remove").isJsonArray()) {
                    throw new RuntimeException("'remove' must be an array!");
                }
                json.get("remove").getAsJsonArray().forEach(element -> {
                    if (element.isJsonObject()) {
                        JsonObject object = element.getAsJsonObject();
                        if (!(object.has("id") && object.get("id").isJsonPrimitive() && object.get("id").getAsJsonPrimitive().isString())) {
                            throw new RuntimeException("Entries in 'remove' must contain key 'id'!");
                        }
                        if (!(!object.has("required") || object.get("required").isJsonPrimitive() && object.get("required").getAsJsonPrimitive().isBoolean())) {
                            throw new RuntimeException("Key 'required' for entries in 'remove' must be a boolean!");
                        }
                        if (!object.has("required") || object.get("required").getAsBoolean()) {
                            remove.add(element.getAsJsonObject().get("id").getAsString());
                        } else {
                            optionalRemove.add(element.getAsJsonObject().get("id").getAsString());
                        }
                    } else if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                        remove.add(element.getAsString());
                    } else {
                        throw new RuntimeException("'remove' must only contain objects and strings!");
                    }
                });
            }
            for (String entry : entries) {
                if (!RegistryUtil.isValidIdentifier(entry)) {
                    throw new RuntimeException("'values' entry '" + entry + "' is not a valid identifier!");
                }
                entryIdentifier = new ResourceLocation(entry);
                if (!registry.hasIdentifier(entryIdentifier)) {
                    throw new RuntimeException("Could not find a registered object for 'values' entry '" + entryIdentifier + "'!");
                }
                tagEntries.add(entryIdentifier);
            }
            for (String entry : optionalEntries) {
                if (!RegistryUtil.isValidIdentifier(entry)) {
                    throw new RuntimeException("'values' optional entry '" + entry + "' is not a valid identifier!");
                }
                entryIdentifier = new ResourceLocation(entry);
                if (!registry.hasIdentifier(entryIdentifier)) continue;
                tagEntries.add(entryIdentifier);
            }
            for (String reference : rawReferences) {
                if (!RegistryUtil.isValidIdentifier(reference)) {
                    throw new RuntimeException("'values' reference '#" + reference + "' is not a valid identifier!");
                }
                references.add(new ResourceLocation(reference));
            }
            for (String reference : rawOptionalReferences) {
                if (!RegistryUtil.isValidIdentifier(reference)) {
                    throw new RuntimeException("'values' reference '#" + reference + "' is not a valid identifier!");
                }
                optionalReferences.add(new ResourceLocation(reference));
            }
            for (String entry : remove) {
                if (!RegistryUtil.isValidIdentifier(entry)) {
                    throw new RuntimeException("'remove' entry '" + entry + "' is not a valid identifier!");
                }
                entryIdentifier = new ResourceLocation(entry);
                if (!registry.hasIdentifier(entryIdentifier)) {
                    throw new RuntimeException("Could not find a registered object for 'remove' entry '" + entryIdentifier + "'!");
                }
                removeEntries.add(entryIdentifier);
            }
            for (String entry : optionalRemove) {
                if (!RegistryUtil.isValidIdentifier(entry)) {
                    throw new RuntimeException("'remove' optional entry '" + entry + "' is not a valid identifier!");
                }
                entryIdentifier = new ResourceLocation(entry);
                if (!registry.hasIdentifier(entryIdentifier)) continue;
                removeEntries.add(entryIdentifier);
            }
        }
        catch (Exception e) {
            CoreLib.LOGGER.error("Encountered exception in tag json '" + identifier.func_110624_b() + ":" + registryName + "/" + identifier.func_110623_a() + ".json' in mod '" + mod.getName() + "'!", (Throwable)e);
            tagEntries.clear();
            references.clear();
            optionalReferences.clear();
        }
    }

    public static Set<ResourceLocation> getTag(Registries.Registry<?> registry, ResourceLocation identifier) {
        return TAGS.containsKey(registry) ? TAGS.get(registry).get(identifier) : null;
    }

    private static /* synthetic */ void lambda$loadTags$3(Path tagTypeFolder, String namespace, Map.Entry tagType, ModContainer mod, Map references, Map optionalReferences, Map removeEntries, Path path) {
        if (Files.isDirectory(path, new LinkOption[0]) || !path.getFileName().toString().endsWith(".json")) {
            return;
        }
        String identifier = tagTypeFolder.relativize(path).toString();
        identifier = identifier.substring(0, identifier.length() - ".json".length());
        if (!RegistryUtil.isValidPath(identifier = identifier.replace('\\', '/'))) {
            CoreLib.LOGGER.warn("Tag filename '" + namespace + ":" + (String)tagType.getKey() + "/" + identifier + "' from mod '" + mod.getName() + "' contains invalid characters!");
            return;
        }
        ResourceLocation fullIdentifier = new ResourceLocation(namespace, identifier);
        TagLoader.readTagFile(mod, fullIdentifier, path, (String)tagType.getKey(), (Registries.Registry)tagType.getValue(), references.computeIfAbsent(fullIdentifier, f -> new HashSet()), optionalReferences.computeIfAbsent(fullIdentifier, f -> new HashSet()), removeEntries.computeIfAbsent(fullIdentifier, f -> new HashSet()));
    }

    static {
        TAG_TYPES.put("blocks", Registries.BLOCKS);
        TAG_TYPES.put("items", Registries.ITEMS);
    }
}

