/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.MalformedJsonException;
import com.supermartijn642.core.CoreLib;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.SimpleResource;
import net.minecraft.util.ResourceLocation;

public class LanguageLoader {
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    public static void loadLanguageJson(Map<String, String> translationsMap, IResource resource) {
        try (InputStreamReader reader = new InputStreamReader(resource.func_110527_b(), StandardCharsets.UTF_8);){
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            for (Map.Entry entry : json.entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonPrimitive() || !((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                    throw new RuntimeException("Value for key '" + (String)entry.getKey() + "' must be a string!");
                }
                String key = (String)entry.getKey();
                String translation = ((JsonElement)entry.getValue()).getAsString().replaceAll("%(\\d+\\$)?[\\d\\.]*[df]", "%$1s");
                translationsMap.put(key, translation);
            }
        }
        catch (MalformedJsonException e) {
            CoreLib.LOGGER.error("Encountered malformed language json '" + resource.func_177241_a() + "' in resource pack '" + resource.func_177240_d() + "'!", (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            CoreLib.LOGGER.error("Encountered exception from language json '" + resource.func_177241_a() + "' in resource pack '" + resource.func_177240_d() + "'!", (Throwable)e);
        }
    }

    public static List<IResource> findAllResources(IResourceManager resourceManager, ResourceLocation langLocation) throws IOException {
        IResourceManager domainManager = LanguageLoader.findFallbackResourceManager(resourceManager, langLocation.func_110624_b());
        if (!(domainManager instanceof FallbackResourceManager)) {
            return domainManager.func_135056_b(langLocation);
        }
        FallbackResourceManager fallbackResourceManager = (FallbackResourceManager)domainManager;
        fallbackResourceManager.func_188552_d(langLocation);
        ArrayList resourceList = Lists.newArrayList();
        ResourceLocation langMcMetaLocation = FallbackResourceManager.func_110537_b((ResourceLocation)langLocation);
        ResourceLocation jsonLocation = new ResourceLocation(langLocation.func_110624_b(), langLocation.func_110623_a().substring(0, langLocation.func_110623_a().length() - ".lang".length()) + ".json");
        ResourceLocation jsonMcMetaLocation = FallbackResourceManager.func_110537_b((ResourceLocation)jsonLocation);
        for (IResourcePack resourcePack : fallbackResourceManager.field_110540_a) {
            InputStream inputStream;
            if (resourcePack.func_110589_b(langLocation)) {
                inputStream = resourcePack.func_110589_b(langMcMetaLocation) ? fallbackResourceManager.func_177245_a(langMcMetaLocation, resourcePack) : null;
                resourceList.add(new SimpleResource(resourcePack.func_130077_b(), langLocation, fallbackResourceManager.func_177245_a(langLocation, resourcePack), inputStream, fallbackResourceManager.field_110539_b));
            }
            if (!resourcePack.func_110589_b(jsonLocation)) continue;
            inputStream = resourcePack.func_110589_b(jsonMcMetaLocation) ? fallbackResourceManager.func_177245_a(jsonMcMetaLocation, resourcePack) : null;
            resourceList.add(new SimpleResource(resourcePack.func_130077_b(), jsonLocation, fallbackResourceManager.func_177245_a(jsonLocation, resourcePack), inputStream, fallbackResourceManager.field_110539_b));
        }
        if (resourceList.isEmpty()) {
            throw new FileNotFoundException(langLocation.toString());
        }
        return resourceList;
    }

    private static IResourceManager findFallbackResourceManager(IResourceManager resourceManager, String namespace) {
        if (resourceManager instanceof FallbackResourceManager) {
            return resourceManager;
        }
        if (resourceManager instanceof SimpleReloadableResourceManager) {
            return LanguageLoader.findFallbackResourceManager((IResourceManager)((SimpleReloadableResourceManager)resourceManager).field_110548_a.get(namespace), namespace);
        }
        return resourceManager;
    }
}

