/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.EditableBlockRenderLayer;
import com.supermartijn642.core.data.TagLoader;
import com.supermartijn642.core.extensions.LootContextExtension;
import com.supermartijn642.core.registry.Registries;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;

public class BaseBlock
extends Block
implements EditableBlockRenderLayer {
    private static final ResourceLocation MINEABLE_WITH_AXE = new ResourceLocation("mineable/axe");
    private static final ResourceLocation MINEABLE_WITH_HOE = new ResourceLocation("mineable/hoe");
    private static final ResourceLocation MINEABLE_WITH_PICKAXE = new ResourceLocation("mineable/pickaxe");
    private static final ResourceLocation MINEABLE_WITH_SHOVEL = new ResourceLocation("mineable/shovel");
    private static final ResourceLocation NEEDS_DIAMOND_TOOL = new ResourceLocation("needs_diamond_tool");
    private static final ResourceLocation NEEDS_IRON_TOOL = new ResourceLocation("needs_iron_tool");
    private static final ResourceLocation NEEDS_STONE_TOOL = new ResourceLocation("needs_stone_tool");
    private final boolean saveTileData;
    private final BlockProperties properties;
    private BlockRenderLayer renderLayer = BlockRenderLayer.SOLID;

    public BaseBlock(boolean saveTileData, BlockProperties properties) {
        super(properties.material, properties.mapColor);
        this.saveTileData = saveTileData;
        this.properties = properties;
        this.field_149787_q = this.func_176223_P().func_185914_p();
        this.field_149786_r = this.field_149787_q ? 255 : 0;
        this.func_149672_a(properties.soundType);
        this.func_149752_b(properties.explosionResistance);
        this.func_149711_c(properties.destroyTime);
        this.func_149675_a(properties.ticksRandomly);
        this.setDefaultSlipperiness(properties.friction);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!this.saveTileData) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        NBTTagCompound nBTTagCompound = tag == null ? null : (tag = tag.func_74764_b("tileData") ? tag.func_74775_l("tileData") : null);
        if (tag == null || tag.func_82582_d()) {
            return;
        }
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof BaseBlockEntity) {
            ((BaseBlockEntity)entity).readData(tag);
        }
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return this.properties.noLootTable ? Items.field_190931_a : (this.properties.lootTableBlock != null ? this.properties.lootTableBlock.get().func_180660_a(state, random, fortune) : super.func_180660_a(state, random, fortune));
    }

    public int func_180651_a(IBlockState state) {
        return this.properties.noLootTable ? 0 : (this.properties.lootTableBlock != null ? this.properties.lootTableBlock.get().func_180651_a(state) : super.func_180651_a(state));
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return this.properties.noLootTable ? 0 : (this.properties.lootTableBlock != null ? this.properties.lootTableBlock.get().quantityDropped(state, fortune, random) : super.quantityDropped(state, fortune, random));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.addAll(this.getActualDrops(world, pos, state, fortune, -1.0f));
    }

    public List<ItemStack> getActualDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune, float explosionRadius) {
        List<ItemStack> drops = this.resolveLootTable(world, pos, state, fortune, explosionRadius);
        if (!this.saveTileData) {
            return drops;
        }
        TileEntity entity = world.func_175625_s(pos);
        if (!(entity instanceof BaseBlockEntity)) {
            return drops;
        }
        if (((BaseBlockEntity)entity).destroyedByCreativePlayer) {
            return Collections.emptyList();
        }
        NBTTagCompound tileTag = ((BaseBlockEntity)entity).writeItemStackData();
        if (tileTag == null || tileTag.func_82582_d()) {
            return drops;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("tileData", (NBTBase)tileTag);
        for (ItemStack stack : drops) {
            if (!(stack.func_77973_b() instanceof ItemBlock) || ((ItemBlock)stack.func_77973_b()).func_179223_d() != this) continue;
            stack.func_77982_d(tag);
        }
        return drops;
    }

    private List<ItemStack> resolveLootTable(IBlockAccess level, BlockPos pos, IBlockState state, int fortune, float explosionRadius) {
        if (this.properties.lootTableBlock != null) {
            NonNullList drops = NonNullList.func_191196_a();
            this.properties.lootTableBlock.get().getDrops(drops, level, pos, state, fortune);
            return drops;
        }
        if (!(level instanceof WorldServer) || this.properties.noLootTable) {
            return Collections.emptyList();
        }
        LootContext.Builder contextBuilder = new LootContext.Builder((WorldServer)level);
        if (this.harvesters.get() != null) {
            contextBuilder.func_186470_a((EntityPlayer)this.harvesters.get());
        }
        LootContext context = contextBuilder.func_186471_a();
        ((LootContextExtension)context).coreLibSetExplosionRadius(explosionRadius);
        ResourceLocation identifier = Registries.BLOCKS.getIdentifier(this);
        ResourceLocation lootTableLocation = new ResourceLocation(identifier.func_110624_b(), "blocks/" + identifier.func_110623_a());
        LootTable lootTable = CommonUtils.getLevel(DimensionType.OVERWORLD).func_184146_ak().func_186521_a(lootTableLocation);
        return lootTable.func_186462_a(((WorldServer)level).field_73012_v, context);
    }

    public void dropItemsFromExplosion(World level, BlockPos pos, IBlockState state, float explosionRadius) {
        if (!level.field_72995_K && !level.restoringBlockSnapshots) {
            List<ItemStack> drops = this.getActualDrops((IBlockAccess)level, pos, state, 0, explosionRadius);
            for (ItemStack drop : drops) {
                BaseBlock.func_180635_a((World)level, (BlockPos)pos, (ItemStack)drop);
            }
        }
    }

    public void func_180653_a(World p_180653_1_, BlockPos p_180653_2_, IBlockState p_180653_3_, float p_180653_4_, int p_180653_5_) {
        super.func_180653_a(p_180653_1_, p_180653_2_, p_180653_3_, p_180653_4_, p_180653_5_);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = super.getPickBlock(state, target, world, pos, player);
        if (!this.saveTileData) {
            return stack;
        }
        TileEntity entity = world.func_175625_s(pos);
        if (!(entity instanceof BaseBlockEntity)) {
            return stack;
        }
        NBTTagCompound entityTag = ((BaseBlockEntity)entity).writeItemStackData();
        if (entityTag == null || entityTag.func_82582_d()) {
            return stack;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("tileData", (NBTBase)entityTag);
        if (stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() == this) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public boolean func_180639_a(World level, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        return this.interact(state, level, pos, player, hand, hitSide, new Vec3d((double)(hitX + (float)pos.func_177958_n()), (double)(hitY + (float)pos.func_177956_o()), (double)(hitZ + (float)pos.func_177952_p()))).consumesAction();
    }

    protected InteractionFeedback interact(IBlockState state, World level, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing hitSide, Vec3d hitLocation) {
        return InteractionFeedback.PASS;
    }

    public void func_190948_a(ItemStack stack, @Nullable World level, List<String> information, ITooltipFlag flag) {
        this.appendItemInformation(stack, (IBlockAccess)level, component -> information.add(component.func_150254_d()), flag.func_194127_a());
        super.func_190948_a(stack, level, information, flag);
    }

    protected void appendItemInformation(ItemStack stack, @Nullable IBlockAccess level, Consumer<ITextComponent> info, boolean advanced) {
    }

    public Item asItem() {
        return Item.func_150898_a((Block)this);
    }

    public boolean isToolEffective(String tool, IBlockState state) {
        return "axe".equals(tool) && this.is(MINEABLE_WITH_AXE) || "hoe".equals(tool) && this.is(MINEABLE_WITH_HOE) || "pickaxe".equals(tool) && this.is(MINEABLE_WITH_PICKAXE) || "shovel".equals(tool) && this.is(MINEABLE_WITH_SHOVEL);
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return this.is(MINEABLE_WITH_AXE) ? "axe" : (this.is(MINEABLE_WITH_HOE) ? "hoe" : (this.is(MINEABLE_WITH_PICKAXE) ? "pickaxe" : (this.is(MINEABLE_WITH_SHOVEL) ? "shovel" : null)));
    }

    public int getHarvestLevel(IBlockState state) {
        return this.is(NEEDS_DIAMOND_TOOL) ? 3 : (this.is(NEEDS_IRON_TOOL) ? 2 : (this.is(NEEDS_STONE_TOOL) ? 1 : -1));
    }

    private boolean is(ResourceLocation tag) {
        return TagLoader.getTag(Registries.BLOCKS, tag).contains(Registries.BLOCKS.getIdentifier(this));
    }

    public boolean isAir(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.properties.isAir;
    }

    public int func_149750_m(IBlockState state) {
        return this.properties.lightLevel.applyAsInt(state);
    }

    public boolean func_176214_u(IBlockState state) {
        return this.properties.isSuffocating.test(state);
    }

    public final boolean requiresCorrectToolForDrops() {
        return this.properties.requiresCorrectTool;
    }

    public float getSpeedFactor() {
        return this.properties.speedFactor;
    }

    public float getJumpFactor() {
        return this.properties.jumpFactor;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.properties == null || state.func_185917_h() && this.properties.canOcclude;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.properties.hasCollision ? super.func_180646_a(blockState, worldIn, pos) : field_185506_k;
    }

    public String func_149732_F() {
        return I18n.func_135052_a((String)this.func_149739_a(), (Object[])new Object[0]).trim();
    }

    public String func_149739_a() {
        return this.getRegistryName().func_110624_b() + ".block." + this.getRegistryName().func_110623_a();
    }

    public BlockRenderLayer func_180664_k() {
        return this.renderLayer;
    }

    @Override
    public void setRenderLayer(BlockRenderLayer layer) {
        this.renderLayer = layer;
    }

    protected static enum InteractionFeedback {
        PASS,
        CONSUME,
        SUCCESS;


        private boolean consumesAction() {
            return this == SUCCESS || this == CONSUME;
        }
    }
}

