/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.entity;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityThrowable
extends Entity
implements IProjectile {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    protected boolean inGround;
    public int throwableShake;
    protected EntityLivingBase thrower;
    private String throwerName;
    private int ticksInGround;
    private int ticksInAir;
    public Entity ignoreEntity;
    private int ignoreTime;

    public EntityThrowable(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityThrowable(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    public EntityThrowable(World worldIn, EntityLivingBase throwerIn) {
        this(worldIn, throwerIn.field_70165_t, throwerIn.field_70163_u + (double)throwerIn.func_70047_e() - (double)0.1f, throwerIn.field_70161_v);
        this.thrower = throwerIn;
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += entityThrower.field_70159_w;
        this.field_70179_y += entityThrower.field_70179_y;
        if (!entityThrower.field_70122_E) {
            this.field_70181_x += entityThrower.field_70181_x;
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.throwableShake > 0) {
            --this.throwableShake;
        }
        if (this.inGround) {
            if (this.field_70170_p.func_180495_p(new BlockPos(this.xTile, this.yTile, this.zTile)).func_177230_c() == this.inTile) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.func_70106_y();
                }
                return;
            }
            this.inGround = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        Vec3d posVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d nextPosVec = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult rayTraceResult = this.field_70170_p.func_147447_a(posVec, nextPosVec, false, true, false);
        posVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        nextPosVec = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (rayTraceResult != null) {
            nextPosVec = new Vec3d(rayTraceResult.field_72307_f.field_72450_a, rayTraceResult.field_72307_f.field_72448_b, rayTraceResult.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double distance = 0.0;
        boolean flag = false;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            Entity entity1 = (Entity)list.get(i);
            if (!entity1.func_70067_L()) continue;
            if (entity1 == this.ignoreEntity) {
                flag = true;
                continue;
            }
            if (this.thrower != null && this.field_70173_aa < 2 && this.ignoreEntity == null) {
                this.ignoreEntity = entity1;
                flag = true;
                continue;
            }
            flag = false;
            AxisAlignedBB boundingBox = entity1.func_174813_aQ().func_186662_g(0.3);
            RayTraceResult result = boundingBox.func_72327_a(posVec, nextPosVec);
            if (result == null || !((d1 = posVec.func_72436_e(result.field_72307_f)) < distance) && distance != 0.0) continue;
            entity = entity1;
            distance = d1;
        }
        if (this.ignoreEntity != null) {
            if (flag) {
                this.ignoreTime = 2;
            } else if (this.ignoreTime-- <= 0) {
                this.ignoreEntity = null;
            }
        }
        if (entity != null) {
            rayTraceResult = new RayTraceResult(entity);
        }
        if (rayTraceResult != null) {
            if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(rayTraceResult.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(rayTraceResult.func_178782_a());
            } else if (!ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)rayTraceResult)) {
                this.onImpact(rayTraceResult);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f1 = 0.99f;
        float f2 = this.getGravityVelocity();
        if (this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                float f3 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            f1 = 0.8f;
        }
        this.field_70159_w *= (double)f1;
        this.field_70181_x *= (double)f1;
        this.field_70179_y *= (double)f1;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)f2;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    protected abstract void onImpact(RayTraceResult var1);

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("xTile", this.xTile);
        compound.func_74768_a("yTile", this.yTile);
        compound.func_74768_a("zTile", this.zTile);
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.inTile);
        compound.func_74778_a("inTile", resourcelocation != null ? resourcelocation.toString() : "");
        compound.func_74774_a("shake", (byte)this.throwableShake);
        compound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        if ((this.throwerName == null || this.throwerName.isEmpty()) && this.thrower instanceof EntityPlayer) {
            this.throwerName = this.thrower.func_70005_c_();
        }
        compound.func_74778_a("ownerName", this.throwerName == null ? "" : this.throwerName);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.xTile = compound.func_74762_e("xTile");
        this.yTile = compound.func_74762_e("yTile");
        this.zTile = compound.func_74762_e("zTile");
        this.inTile = compound.func_150297_b("inTile", 8) ? Block.func_149684_b((String)compound.func_74779_i("inTile")) : Block.func_149729_e((int)(compound.func_74771_c("inTile") & 0xFF));
        this.throwableShake = compound.func_74771_c("shake") & 0xFF;
        this.inGround = compound.func_74771_c("inGround") == 1;
        this.thrower = null;
        this.throwerName = compound.func_74779_i("ownerName");
        if (this.throwerName.isEmpty()) {
            this.throwerName = null;
        }
        this.thrower = this.getThrower();
    }

    @Nullable
    public EntityLivingBase getThrower() {
        if (this.thrower == null && this.throwerName != null && !this.throwerName.isEmpty()) {
            this.thrower = this.field_70170_p.func_72924_a(this.throwerName);
            if (this.thrower == null && this.field_70170_p instanceof WorldServer) {
                try {
                    Entity entity = ((WorldServer)this.field_70170_p).func_175733_a(UUID.fromString(this.throwerName));
                    if (entity instanceof EntityLivingBase) {
                        this.thrower = (EntityLivingBase)entity;
                    }
                }
                catch (Throwable var2) {
                    this.thrower = null;
                }
            }
        }
        return this.thrower;
    }
}

