/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.event;

import com.mrcrayfish.guns.GunConfig;
import com.mrcrayfish.guns.ItemStackUtil;
import com.mrcrayfish.guns.MrCrayfishGunMod;
import com.mrcrayfish.guns.client.event.GunHandler;
import com.mrcrayfish.guns.client.render.gun.IOverrideModel;
import com.mrcrayfish.guns.client.render.gun.ModelOverrides;
import com.mrcrayfish.guns.client.util.RenderUtil;
import com.mrcrayfish.guns.event.CommonEvents;
import com.mrcrayfish.guns.init.ModGuns;
import com.mrcrayfish.guns.init.ModPotions;
import com.mrcrayfish.guns.item.AmmoRegistry;
import com.mrcrayfish.guns.item.IAttachment;
import com.mrcrayfish.guns.item.ItemAmmo;
import com.mrcrayfish.guns.item.ItemGun;
import com.mrcrayfish.guns.item.ItemScope;
import com.mrcrayfish.guns.object.Bullet;
import com.mrcrayfish.guns.object.GripType;
import com.mrcrayfish.guns.object.Gun;
import com.mrcrayfish.obfuscate.client.event.ModelPlayerEvent;
import com.mrcrayfish.obfuscate.client.event.RenderItemEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class RenderEvents {
    private static final ResourceLocation SCOPE_OVERLAY = new ResourceLocation("cgm", "textures/scope_long_overlay.png");
    private static final ResourceLocation WHITE_GRADIENT = new ResourceLocation("cgm", "textures/effect/white_gradient.png");
    private static final Map<UUID, CooldownTracker> COOLDOWN_TRACKER_MAP = new HashMap<UUID, CooldownTracker>();
    private static final double ZOOM_TICKS = 4.0;
    public static boolean drawFlash = false;
    public static int screenTextureId = -1;
    public static boolean shadersEnabled;
    private int zoomProgress;
    private int lastZoomProgress;
    public double normalZoomProgress;
    public double recoilNormal;
    public double recoilAngle;
    public boolean playAnimation;
    private int startTick;
    private int reloadTimer;
    private int prevReloadTimer;
    private boolean lastSmoothCamera;
    private ItemStack flash;
    private List<Bullet> bullets;

    public RenderEvents() {
        this.lastSmoothCamera = Minecraft.func_71410_x().field_71474_y.field_74326_T;
        this.flash = null;
        this.bullets = new ArrayList<Bullet>();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.field_70170_p.field_72995_K) {
            RenderEvents.getCooldownTracker(event.player.func_110124_au()).func_185144_a();
        }
    }

    @SubscribeEvent
    public void onKeyPressedEvent(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x().field_71474_y.field_151458_ab.func_151468_f()) {
            Minecraft.func_71410_x().field_71474_y.field_74326_T = !Minecraft.func_71410_x().field_71474_y.field_74326_T;
            this.lastSmoothCamera = Minecraft.func_71410_x().field_71474_y.field_74326_T;
        }
    }

    @SubscribeEvent
    public void onFovUpdate(FOVUpdateEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71439_g.func_184614_ca().func_190926_b() && mc.field_71474_y.field_74320_O == 0) {
            ItemStack heldItem = mc.field_71439_g.func_184614_ca();
            if (heldItem.func_77973_b() instanceof ItemGun) {
                ItemStack scope = Gun.getScope(heldItem);
                ItemGun gun = (ItemGun)heldItem.func_77973_b();
                if (this.isZooming((EntityPlayer)Minecraft.func_71410_x().field_71439_g) && !((Boolean)mc.field_71439_g.func_184212_Q().func_187225_a(CommonEvents.RELOADING)).booleanValue()) {
                    ItemScope.Type scopeType;
                    mc.field_71474_y.field_74326_T = gun.getGun().modules.zoom.smooth;
                    float newFov = gun.getGun().modules.zoom.fovModifier - 0.1f;
                    if (scope != null && (scopeType = ItemScope.Type.getFromStack(scope)) != null) {
                        newFov -= scopeType.getAdditionalZoom();
                        mc.field_71474_y.field_74326_T = gun.getGun().modules.attachments.scope.smooth;
                        if (scopeType == ItemScope.Type.LONG) {
                            mc.field_71474_y.field_74326_T = true;
                        }
                    }
                    event.setNewfov(newFov + (1.0f - newFov) * (1.0f - (float)this.zoomProgress / 4.0f));
                } else {
                    mc.field_71474_y.field_74326_T = this.lastSmoothCamera;
                }
            } else {
                mc.field_71474_y.field_74326_T = this.lastSmoothCamera;
            }
        } else {
            mc.field_71474_y.field_74326_T = this.lastSmoothCamera;
        }
    }

    @SubscribeEvent
    public void onPreClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        this.lastZoomProgress = this.zoomProgress;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (this.isZooming((EntityPlayer)player) && !((Boolean)player.func_184212_Q().func_187225_a(CommonEvents.RELOADING)).booleanValue()) {
            if ((double)this.zoomProgress < 4.0) {
                ++this.zoomProgress;
            }
        } else if (this.zoomProgress > 0) {
            --this.zoomProgress;
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.prevReloadTimer = this.reloadTimer;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (this.isZooming((EntityPlayer)player) && !((Boolean)player.func_184212_Q().func_187225_a(CommonEvents.RELOADING)).booleanValue()) {
            Minecraft.func_71410_x().field_71439_g.field_71107_bF = 0.0075f;
            Minecraft.func_71410_x().field_71439_g.field_71109_bG = 0.0075f;
        }
        if (player != null) {
            IOverrideModel model;
            ItemStack heldItem = player.func_184614_ca();
            if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemGun && (model = ModelOverrides.getModel(heldItem)) != null) {
                model.tick((EntityLivingBase)player);
            }
            if (((Boolean)player.func_184212_Q().func_187225_a(CommonEvents.RELOADING)).booleanValue()) {
                if (this.startTick == -1) {
                    this.startTick = player.field_70173_aa + 5;
                }
                if (this.reloadTimer < 5) {
                    ++this.reloadTimer;
                }
            } else {
                this.playAnimation = false;
                if (this.startTick != -1) {
                    this.startTick = -1;
                }
                if (this.reloadTimer > 0) {
                    --this.reloadTimer;
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        this.normalZoomProgress = ((double)this.lastZoomProgress + (double)(this.zoomProgress - this.lastZoomProgress) * (this.lastZoomProgress == 0 || (double)this.lastZoomProgress == 4.0 ? 0.0 : (double)event.getPartialTicks())) / 4.0;
        if (this.normalZoomProgress > 0.0 && event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderSpecificHandEvent event) {
        ItemStack mainHandStack;
        boolean right = Minecraft.func_71410_x().field_71474_y.field_186715_A == EnumHandSide.RIGHT ? event.getHand() == EnumHand.MAIN_HAND : event.getHand() == EnumHand.OFF_HAND;
        ItemStack heldItem = event.getItemStack();
        if (event.getHand() == EnumHand.OFF_HAND && (mainHandStack = Minecraft.func_71410_x().field_71439_g.func_184614_ca()).func_77973_b() instanceof ItemGun && ((ItemGun)mainHandStack.func_77973_b()).getGun().general.gripType != GripType.ONE_HANDED) {
            event.setCanceled(true);
            return;
        }
        if (!(heldItem.func_77973_b() instanceof ItemGun)) {
            return;
        }
        event.setCanceled(true);
        if (event.getHand() == EnumHand.OFF_HAND) {
            return;
        }
        ItemStack scope = Gun.getScope(heldItem);
        ItemScope.Type scopeType = ItemScope.Type.getFromStack(scope);
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(heldItem);
        float scaleX = model.func_177552_f().field_188039_n.field_178363_d.getX();
        float scaleY = model.func_177552_f().field_188039_n.field_178363_d.getY();
        float scaleZ = model.func_177552_f().field_188039_n.field_178363_d.getZ();
        float translateY = model.func_177552_f().field_188039_n.field_178365_c.getY() * scaleY;
        float translateZ = model.func_177552_f().field_188039_n.field_178365_c.getZ() * scaleZ;
        GlStateManager.func_179094_E();
        if (this.normalZoomProgress > 0.0) {
            ItemGun itemGun = (ItemGun)heldItem.func_77973_b();
            if (event.getHand() == EnumHand.MAIN_HAND) {
                double xOffset = 0.0;
                double yOffset = 0.0;
                double zOffset = 0.0;
                Gun gun = itemGun.getGun();
                if (gun.canAttachType(IAttachment.Type.SCOPE) && scope != null && scopeType != null) {
                    Gun.Modules.Attachments.Scope scaledPos = gun.modules.attachments.scope;
                    xOffset -= scaledPos.xOffset * 0.0625 * (double)scaleX;
                    yOffset -= scaledPos.yOffset * 0.0625 * (double)scaleY - (double)translateY + scopeType.getHeightToCenter() * (double)scaleY * 0.0625 * scaledPos.scale;
                    zOffset -= scaledPos.zOffset * 0.0625 * (double)scaleZ - (double)translateZ - 0.35;
                } else if (gun.modules.zoom != null) {
                    xOffset -= gun.modules.zoom.xOffset * 0.0625 * (double)scaleX;
                    yOffset -= gun.modules.zoom.yOffset * 0.0625 * (double)scaleY - (double)translateY;
                    zOffset -= gun.modules.zoom.zOffset * 0.0625 * (double)scaleZ - (double)translateZ;
                }
                double renderOffset = right ? -0.3415 : -0.3775;
                GlStateManager.func_179137_b((double)((renderOffset + xOffset) * this.normalZoomProgress * (double)(right ? 1.0f : -1.0f)), (double)(yOffset * this.normalZoomProgress), (double)(zOffset * this.normalZoomProgress));
            } else {
                GlStateManager.func_179137_b((double)0.0, (double)(-1.0 * this.normalZoomProgress), (double)0.0);
            }
        }
        GlStateManager.func_179109_b((float)0.0f, (float)(-event.getEquipProgress()), (float)0.0f);
        EnumHandSide hand = right ? EnumHandSide.RIGHT : EnumHandSide.LEFT;
        this.renderReloadArm(heldItem, hand);
        GlStateManager.func_179109_b((float)(0.5602f - (right ? 0.0f : 0.72f)), (float)-0.55625f, (float)-0.72f);
        this.applyRecoil(heldItem.func_77973_b(), ((ItemGun)heldItem.func_77973_b()).getGun());
        this.applyReload(event.getPartialTicks());
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-(0.56f - (right ? 0.0f : 0.72f))), (float)0.56f, (float)0.72f);
        this.renderHeldArm(heldItem, hand, event.getPartialTicks());
        GlStateManager.func_179121_F();
        this.renderWeapon((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, heldItem, ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, event.getPartialTicks());
        GlStateManager.func_179121_F();
    }

    private void applyReload(float partialTicks) {
        float reloadProgress = ((float)this.prevReloadTimer + (float)(this.reloadTimer - this.prevReloadTimer) * partialTicks) / 5.0f;
        GlStateManager.func_179137_b((double)0.0, (double)(0.35 * (double)reloadProgress), (double)0.0);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-0.1 * (double)reloadProgress));
        GlStateManager.func_179114_b((float)(45.0f * reloadProgress), (float)1.0f, (float)0.0f, (float)0.0f);
    }

    private void applyRecoil(Item item, Gun gun) {
        CooldownTracker tracker = RenderEvents.getCooldownTracker(Minecraft.func_71410_x().field_71439_g.func_110124_au());
        float cooldown = tracker.func_185143_a(item, Minecraft.func_71410_x().func_184121_ak());
        float f = cooldown = cooldown >= gun.general.recoilDurationOffset ? (cooldown - gun.general.recoilDurationOffset) / (1.0f - gun.general.recoilDurationOffset) : 0.0f;
        if ((double)cooldown >= 0.8) {
            float amount = 1.0f * ((1.0f - cooldown) / 0.2f);
            this.recoilNormal = 1.0f - (amount -= 1.0f) * amount * amount * amount;
        } else {
            float amount = cooldown / 0.8f;
            this.recoilNormal = (double)amount < 0.5 ? (double)(2.0f * amount * amount) : (double)(-1.0f + (4.0f - 2.0f * amount) * amount);
        }
        this.recoilAngle = gun.general.recoilAngle;
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)((double)gun.general.recoilKick * 0.0625 * this.recoilNormal));
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.35);
        GlStateManager.func_179114_b((float)((float)((double)gun.general.recoilAngle * this.recoilNormal)), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.35);
    }

    private boolean isZooming(EntityPlayer player) {
        ItemStack stack;
        if (player != null && player.func_184614_ca() != ItemStack.field_190927_a && (stack = player.func_184614_ca()).func_77973_b() instanceof ItemGun) {
            Gun gun = ((ItemGun)stack.func_77973_b()).getGun();
            return gun.modules != null && gun.modules.zoom != null && MrCrayfishGunMod.proxy.isZooming();
        }
        return false;
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71415_G) {
            return;
        }
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
            return;
        }
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b() || !(heldItem.func_77973_b() instanceof ItemGun)) {
            return;
        }
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemGun) {
            float coolDown;
            ItemScope.Type scopeType = ItemScope.Type.getFromStack(Gun.getAttachment(IAttachment.Type.SCOPE, heldItem));
            if (scopeType == ItemScope.Type.LONG && this.normalZoomProgress == 1.0) {
                return;
            }
            Gun gun = ((ItemGun)heldItem.func_77973_b()).getGun();
            if (!gun.general.auto && (coolDown = player.func_184811_cZ().func_185143_a(heldItem.func_77973_b(), event.renderTickTime)) > 0.0f) {
                double scale = 3.0;
                int i = (int)((double)(scaledResolution.func_78328_b() / 2 - 7 - 60) / scale);
                int j = (int)Math.ceil(((double)(scaledResolution.func_78326_a() / 2) - 8.0 * scale) / scale);
                GlStateManager.func_179141_d();
                mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
                int progress = (int)Math.ceil(((double)coolDown + 0.05) * 17.0) - 1;
                GuiScreen.func_146110_a((int)j, (int)i, (float)36.0f, (float)94.0f, (int)16, (int)4, (float)256.0f, (float)256.0f);
                GuiScreen.func_146110_a((int)j, (int)i, (float)52.0f, (float)94.0f, (int)progress, (int)4, (float)256.0f, (float)256.0f);
                GlStateManager.func_179121_F();
            }
        }
    }

    @SubscribeEvent
    public void onRenderHeldItem(RenderItemEvent.Held.Pre event) {
        ItemStack mainHandStack;
        EnumHand hand = Minecraft.func_71410_x().field_71474_y.field_186715_A == EnumHandSide.RIGHT ? (event.getHandSide() == EnumHandSide.RIGHT ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND) : (event.getHandSide() == EnumHandSide.LEFT ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
        EntityLivingBase entity = event.getEntity();
        ItemStack heldItem = entity.func_184586_b(hand);
        if (heldItem.func_77973_b() instanceof ItemGun) {
            event.setCanceled(true);
            Gun gun = ((ItemGun)heldItem.func_77973_b()).getGun();
            gun.general.gripType.getHeldAnimation().applyHeldItemTransforms(hand, entity instanceof EntityPlayer ? GunHandler.getAimProgress((EntityPlayer)entity, event.getPartialTicks()) : 0.0f);
            if (hand == EnumHand.MAIN_HAND) {
                this.renderWeapon(entity, heldItem, event.getTransformType(), event.getPartialTicks());
            }
        }
        if (hand == EnumHand.OFF_HAND && !(mainHandStack = entity.func_184614_ca()).func_190926_b() && mainHandStack.func_77973_b() instanceof ItemGun) {
            Gun mainHandGun = ((ItemGun)mainHandStack.func_77973_b()).getGun();
            if (!mainHandGun.general.gripType.canRenderOffhand()) {
                event.setCanceled(true);
            } else if (heldItem.func_77973_b() instanceof ItemGun) {
                Gun gun = ((ItemGun)heldItem.func_77973_b()).getGun();
                if (gun.general.gripType.canRenderOffhand()) {
                    this.renderWeapon(entity, heldItem, event.getTransformType(), event.getPartialTicks());
                }
            }
        }
    }

    @SubscribeEvent
    public void onSetupAngles(ModelPlayerEvent.SetupAngles.Post event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemGun) {
            ModelPlayer model = event.getModelPlayer();
            Gun gun = ((ItemGun)heldItem.func_77973_b()).getGun();
            gun.general.gripType.getHeldAnimation().applyPlayerModelRotation(model, EnumHand.MAIN_HAND, GunHandler.getAimProgress((EntityPlayer)event.getEntity(), event.getPartialTicks()));
            RenderEvents.copyModelAngles(model.field_178723_h, model.field_178732_b);
            RenderEvents.copyModelAngles(model.field_178724_i, model.field_178734_a);
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemGun) {
            Gun gun = ((ItemGun)heldItem.func_77973_b()).getGun();
            gun.general.gripType.getHeldAnimation().applyPlayerPreRender(player, EnumHand.MAIN_HAND, GunHandler.getAimProgress((EntityPlayer)event.getEntity(), event.getPartialRenderTick()));
        }
    }

    @SubscribeEvent
    public void onModelRender(ModelPlayerEvent.Render.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack offHandStack = player.func_184592_cb();
        if (offHandStack.func_77973_b() instanceof ItemGun) {
            switch (player.func_184591_cq().func_188468_a()) {
                case LEFT: {
                    event.getModelPlayer().field_187075_l = ModelBiped.ArmPose.EMPTY;
                    break;
                }
                case RIGHT: {
                    event.getModelPlayer().field_187076_m = ModelBiped.ArmPose.EMPTY;
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(ModelPlayerEvent.Render.Post event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack heldItem = player.func_184592_cb();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemGun) {
            Gun gun = ((ItemGun)heldItem.func_77973_b()).getGun();
            if (!gun.general.gripType.canRenderOffhand()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                if (player.func_70093_af()) {
                    GlStateManager.func_179137_b((double)0.0, (double)-0.4375, (double)-0.3125);
                    GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                } else {
                    GlStateManager.func_179137_b((double)0.0, (double)-0.3125, (double)-0.171875);
                }
                GlStateManager.func_179114_b((float)-45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                this.renderWeapon((EntityLivingBase)player, heldItem, ItemCameraTransforms.TransformType.FIXED, event.getPartialTicks());
                GlStateManager.func_179121_F();
            } else {
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                if (player.func_70093_af()) {
                    GlStateManager.func_179137_b((double)-0.28125, (double)-0.9375, (double)-0.25);
                } else {
                    GlStateManager.func_179137_b((double)-0.28125, (double)-0.8125, (double)0.0625);
                }
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)75.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)((float)Math.toDegrees(event.getModelPlayer().field_178721_j.field_78795_f) / 10.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                this.renderWeapon((EntityLivingBase)player, heldItem, ItemCameraTransforms.TransformType.FIXED, event.getPartialTicks());
                GlStateManager.func_179121_F();
            }
        }
    }

    @SubscribeEvent
    public void onRenderEntityItem(RenderItemEvent.Entity.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        event.setCanceled(this.renderWeapon((EntityLivingBase)mc.field_71439_g, event.getItem(), event.getTransformType(), event.getPartialTicks()));
    }

    @SubscribeEvent
    public void onRenderEntityItem(RenderItemEvent.Gui.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        event.setCanceled(this.renderWeapon((EntityLivingBase)mc.field_71439_g, event.getItem(), event.getTransformType(), event.getPartialTicks()));
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
    }

    private boolean renderWeapon(EntityLivingBase entity, ItemStack stack, ItemCameraTransforms.TransformType transformType, float partialTicks) {
        if (stack.func_77973_b() instanceof ItemGun) {
            GlStateManager.func_179094_E();
            ItemStack model = ItemStack.field_190927_a;
            if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("model", 10)) {
                model = new ItemStack(stack.func_77978_p().func_74775_l("model"));
                model.func_77982_d(stack.func_77978_p().func_74737_b());
            }
            RenderUtil.applyTransformType(model.func_190926_b() ? stack : model, transformType);
            if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
                this.renderMuzzleFlash(stack);
            }
            this.renderGun(entity, transformType, model.func_190926_b() ? stack : model, partialTicks);
            this.renderAttachments(entity, transformType, stack, partialTicks);
            GlStateManager.func_179121_F();
            return true;
        }
        return false;
    }

    private void renderGun(EntityLivingBase entity, ItemCameraTransforms.TransformType transformType, ItemStack stack, float partialTicks) {
        if (ModelOverrides.hasModel(stack)) {
            IOverrideModel model = ModelOverrides.getModel(stack);
            if (model != null) {
                model.render(partialTicks, transformType, stack, ItemStack.field_190927_a, entity);
            }
        } else {
            RenderUtil.renderModel(stack);
        }
    }

    private void renderAttachments(EntityLivingBase entity, ItemCameraTransforms.TransformType transformType, ItemStack stack, float partialTicks) {
        if (stack.func_77973_b() instanceof ItemGun) {
            Gun gun = ((ItemGun)stack.func_77973_b()).getGun();
            NBTTagCompound gunTag = ItemStackUtil.createTagCompound(stack);
            NBTTagCompound attachments = gunTag.func_74775_l("attachments");
            for (String attachmentKey : attachments.func_150296_c()) {
                ItemStack attachmentStack;
                IAttachment.Type type = IAttachment.Type.getType(attachmentKey);
                if (!gun.canAttachType(type) || (attachmentStack = Gun.getAttachment(type, stack)).func_190926_b()) continue;
                GlStateManager.func_179094_E();
                Gun.ScaledPositioned positioned = gun.getAttachmentPosition(type);
                if (positioned != null) {
                    double displayX = positioned.xOffset * 0.0625;
                    double displayY = positioned.yOffset * 0.0625;
                    double displayZ = positioned.zOffset * 0.0625;
                    GlStateManager.func_179137_b((double)displayX, (double)displayY, (double)displayZ);
                    GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)0.0);
                    GlStateManager.func_179139_a((double)positioned.scale, (double)positioned.scale, (double)positioned.scale);
                    IOverrideModel model = ModelOverrides.getModel(attachmentStack);
                    if (model != null) {
                        model.render(partialTicks, transformType, attachmentStack, stack, entity);
                    } else {
                        RenderUtil.renderModel(attachmentStack, stack);
                    }
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    private void renderMuzzleFlash(ItemStack weapon) {
        Gun gun = ((ItemGun)weapon.func_77973_b()).getGun();
        if (drawFlash) {
            Gun.ScaledPositioned positioned;
            if (this.flash == null) {
                this.flash = new ItemStack(ModGuns.PARTS, 1, 2);
            }
            IBakedModel flashModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(this.flash);
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179137_b((double)(gun.display.flash.xOffset * 0.0625), (double)(gun.display.flash.yOffset * 0.0625), (double)(gun.display.flash.zOffset * 0.0625));
            if (!Gun.getAttachment(IAttachment.Type.BARREL, weapon).func_190926_b() && (positioned = gun.getAttachmentPosition(IAttachment.Type.BARREL)) != null) {
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)((gun.display.flash.zOffset - positioned.zOffset) * 0.0625 - positioned.scale));
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.0);
            }
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
            RenderUtil.renderModel(flashModel, weapon);
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
            drawFlash = false;
        }
    }

    private static void copyModelAngles(ModelRenderer source, ModelRenderer dest) {
        dest.field_78795_f = source.field_78795_f;
        dest.field_78796_g = source.field_78796_g;
        dest.field_78808_h = source.field_78808_h;
    }

    private void renderHeldArm(ItemStack stack, EnumHandSide hand, float partialTicks) {
        GlStateManager.func_179094_E();
        Gun gun = ((ItemGun)stack.func_77973_b()).getModifiedGun(stack);
        if (gun.general.gripType == GripType.TWO_HANDED) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            float reloadProgress = ((float)this.prevReloadTimer + (float)(this.reloadTimer - this.prevReloadTimer) * partialTicks) / 5.0f;
            GlStateManager.func_179109_b((float)0.0f, (float)(-reloadProgress * 2.0f), (float)0.0f);
            int side = hand.func_188468_a() == EnumHandSide.RIGHT ? 1 : -1;
            GlStateManager.func_179137_b((double)(6.5 * (double)side * 0.0625), (double)-0.55, (double)-0.5625);
            if (Minecraft.func_71410_x().field_71439_g.func_175154_l().equals("slim") && hand.func_188468_a() == EnumHandSide.LEFT) {
                GlStateManager.func_179109_b((float)(0.03125f * (float)(-side)), (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(15.0f * (float)(-side)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(15.0f * (float)(-side)), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)-35.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            this.renderArm(hand.func_188468_a(), 0.0625f);
        } else if (gun.general.gripType == GripType.ONE_HANDED) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            double centerOffset = 2.5;
            if (Minecraft.func_71410_x().field_71439_g.func_175154_l().equals("slim")) {
                centerOffset += hand == EnumHandSide.RIGHT ? 0.2 : 0.8;
            }
            centerOffset = hand == EnumHandSide.RIGHT ? -centerOffset : centerOffset;
            GlStateManager.func_179137_b((double)(centerOffset * 0.0625), (double)-0.45, (double)-1.0);
            GlStateManager.func_179114_b((float)75.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            this.renderArm(hand, 0.0625f);
        }
        GlStateManager.func_179121_F();
    }

    private void renderReloadArm(ItemStack stack, EnumHandSide hand) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g.field_70173_aa < this.startTick || this.reloadTimer != 5) {
            return;
        }
        Gun gun = ((ItemGun)stack.func_77973_b()).getModifiedGun(stack);
        ItemAmmo ammo = AmmoRegistry.getInstance().getAmmo(gun.projectile.item);
        if (ammo == null) {
            return;
        }
        GlStateManager.func_179094_E();
        float reload = ((float)(mc.field_71439_g.field_70173_aa - this.startTick) + mc.func_184121_ak()) % 10.0f / 10.0f;
        float percent = 1.0f - reload;
        if (percent >= 0.5f) {
            percent = 1.0f - percent;
        }
        percent = (double)(percent *= 2.0f) < 0.5 ? 2.0f * percent * percent : -1.0f + (4.0f - 2.0f * percent) * percent;
        int side = hand.func_188468_a() == EnumHandSide.RIGHT ? 1 : -1;
        GlStateManager.func_179137_b((double)(-2.75 * (double)side * 0.0625), (double)-0.5625, (double)-0.5625);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)(-0.35 * (1.0 - (double)percent)), (double)0.0);
        GlStateManager.func_179137_b((double)((double)(side * 1) * 0.0625), (double)0.0, (double)0.0);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(35.0f * (float)(-side)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-75.0f * percent), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        this.renderArm(hand.func_188468_a(), 0.0625f);
        if (reload < 0.5f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)(-side * 5) * 0.0625), (double)0.9375, (double)-0.0625);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
            RenderUtil.renderModel(new ItemStack((Item)ammo), ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    private void renderArm(EnumHandSide hand, float scale) {
        EntityPlayerSP abstractClientPlayer = Minecraft.func_71410_x().field_71439_g;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(abstractClientPlayer.func_110306_p());
        RenderPlayer renderPlayer = (RenderPlayer)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)abstractClientPlayer);
        GlStateManager.func_179129_p();
        if (hand == EnumHandSide.RIGHT) {
            renderPlayer.func_177087_b().field_178723_h.field_78795_f = 0.0f;
            renderPlayer.func_177087_b().field_178723_h.field_78796_g = 0.0f;
            renderPlayer.func_177087_b().field_178723_h.field_78808_h = 0.0f;
            renderPlayer.func_177087_b().field_178723_h.func_78785_a(scale);
        } else {
            renderPlayer.func_177087_b().field_178724_i.field_78795_f = 0.0f;
            renderPlayer.func_177087_b().field_178724_i.field_78796_g = 0.0f;
            renderPlayer.func_177087_b().field_178724_i.field_78808_h = 0.0f;
            renderPlayer.func_177087_b().field_178724_i.func_78785_a(scale);
        }
        GlStateManager.func_179089_o();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void blindPlayer(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        PotionEffect effect = Minecraft.func_71410_x().field_71439_g.func_70660_b(ModPotions.BLINDED);
        if (effect != null) {
            float percent = Math.min((float)effect.func_76459_b() / (float)GunConfig.SERVER.stunGrenades.blind.alphaFadeThresholdSynced, 1.0f);
            Gui.func_73734_a((int)0, (int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)((int)((double)(percent * (float)GunConfig.SERVER.stunGrenades.blind.alphaOverlaySynced) + 0.5) << 24 | 0xFFFFFF));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderLastWorld(RenderWorldLastEvent event) {
        if (FMLClientHandler.instance().hasOptifine()) {
            try {
                Class<?> clazz = Class.forName("net.optifine.shaders.Shaders");
                if (clazz != null) {
                    Field field = clazz.getDeclaredField("activeProgramID");
                    int activeProgramID = (Integer)field.get(null);
                    shadersEnabled = activeProgramID != 0;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (!shadersEnabled) {
            if (screenTextureId == -1) {
                screenTextureId = GlStateManager.func_179146_y();
            }
            Minecraft mc = Minecraft.func_71410_x();
            GlStateManager.func_179144_i((int)screenTextureId);
            GL11.glCopyTexImage2D((int)3553, (int)0, (int)6407, (int)0, (int)0, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)0);
        } else if (screenTextureId != -1) {
            GlStateManager.func_179150_h((int)screenTextureId);
            screenTextureId = -1;
        }
    }

    public static CooldownTracker getCooldownTracker(UUID uuid) {
        if (!COOLDOWN_TRACKER_MAP.containsKey(uuid)) {
            COOLDOWN_TRACKER_MAP.put(uuid, new CooldownTracker());
        }
        return COOLDOWN_TRACKER_MAP.get(uuid);
    }

    @SubscribeEvent
    public void onRenderBullets(RenderWorldLastEvent event) {
        for (Bullet bullet : this.bullets) {
            this.renderBullet(bullet, event.getPartialTicks());
        }
    }

    private void renderBullet(Bullet bullet, float partialTicks) {
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (entity == null || bullet.isFinished() || bullet.getProjectile() == null) {
            return;
        }
        GlStateManager.func_179094_E();
        double doubleX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double doubleY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double doubleZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        double bulletX = bullet.getPosX() + bullet.getMotionX() * (double)partialTicks;
        double bulletY = bullet.getPosY() + bullet.getMotionY() * (double)partialTicks;
        double bulletZ = bullet.getPosZ() + bullet.getMotionZ() * (double)partialTicks;
        GlStateManager.func_179137_b((double)bulletX, (double)bulletY, (double)bulletZ);
        GlStateManager.func_179114_b((float)bullet.getRotationYaw(), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-bullet.getRotationPitch() + 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179123_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(WHITE_GRADIENT);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        Vec3d motionVec = new Vec3d(bullet.getMotionX(), bullet.getMotionY(), bullet.getMotionZ());
        double length = motionVec.func_72433_c() / 3.0 * bullet.getTrailLengthMultiplier();
        int trailColor = bullet.getTrailColor();
        float r = (float)(trailColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(trailColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(trailColor & 0xFF) / 255.0f;
        float a = 1.0f;
        buffer.func_181662_b(0.0, 0.0, -0.035).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 0.035).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(0.0, -length, 0.035).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(0.0, -length, -0.035).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(-0.035, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(0.035, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(0.035, -length, 0.0).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(-0.035, -length, 0.0).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179099_b();
        if (bullet.getProjectile().getItem().func_190926_b()) {
            GlStateManager.func_179121_F();
            return;
        }
        GlStateManager.func_179114_b((float)(((float)bullet.getProjectile().field_70173_aa + partialTicks) * 50.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.275, (double)0.275, (double)0.275);
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71460_t.func_180436_i();
        int brightness = 0;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)doubleX), 0, MathHelper.func_76128_c((double)doubleZ));
        if (mc.field_71441_e.func_175667_e((BlockPos)blockPos)) {
            blockPos.func_185336_p(MathHelper.func_76128_c((double)doubleY));
            brightness = mc.field_71441_e.func_175626_b((BlockPos)blockPos, 0);
        }
        int x = brightness % 65536;
        int y = brightness / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)x, (float)y);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(bullet.getProjectile().getItem(), ItemCameraTransforms.TransformType.NONE);
        mc.field_71460_t.func_175072_h();
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void onTickBullets(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.bullets.forEach(bullet -> bullet.tick((World)Minecraft.func_71410_x().field_71441_e));
            this.bullets.removeIf(Bullet::isFinished);
        }
    }

    public void addBullet(Bullet bullet) {
        this.bullets.add(bullet);
    }
}

