/*
 * Decompiled with CFR 0.152.
 */
package reborncore.api.praescriptum.ingredients.input;

import java.util.Objects;
import net.minecraftforge.fluids.FluidStack;
import reborncore.api.praescriptum.ingredients.input.InputIngredient;
import reborncore.common.util.FluidUtils;

public class FluidStackInputIngredient
extends InputIngredient<FluidStack> {
    public static FluidStackInputIngredient of(FluidStack ingredient) {
        return new FluidStackInputIngredient(ingredient);
    }

    public static FluidStackInputIngredient copyOf(FluidStack ingredient) {
        return new FluidStackInputIngredient(ingredient.copy());
    }

    protected FluidStackInputIngredient(FluidStack ingredient) {
        super(ingredient);
    }

    @Override
    public Object getUnspecific() {
        return ((FluidStack)this.ingredient).getFluid();
    }

    @Override
    public InputIngredient<FluidStack> copy() {
        return FluidStackInputIngredient.of(((FluidStack)this.ingredient).copy());
    }

    @Override
    public boolean isEmpty() {
        return ((FluidStack)this.ingredient).amount <= 0;
    }

    @Override
    public int getCount() {
        return ((FluidStack)this.ingredient).amount;
    }

    @Override
    public void shrink(int amount) {
        ((FluidStack)this.ingredient).amount -= amount;
    }

    @Override
    public boolean matches(Object other) {
        return other instanceof FluidStack && ((FluidStack)this.ingredient).isFluidEqual((FluidStack)other);
    }

    @Override
    public boolean matchesStrict(Object other) {
        return other instanceof FluidStack && ((FluidStack)this.ingredient).isFluidStackIdentical((FluidStack)other);
    }

    @Override
    public String toFormattedString() {
        return FluidUtils.toFormattedString((FluidStack)this.ingredient);
    }

    public int hashCode() {
        return Objects.hash(this.ingredient, this.consumable);
    }

    @Override
    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.matches(((FluidStackInputIngredient)object).ingredient) && this.consumable == ((FluidStackInputIngredient)object).consumable;
    }
}

