/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.tileentity;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.util.attribute.AbstractAttribute;
import com.carpentersblocks.util.attribute.AttributeHelper;
import com.carpentersblocks.util.attribute.AttributeItemStack;
import com.carpentersblocks.util.attribute.AttributeString;
import com.carpentersblocks.util.attribute.EnumAttributeLocation;
import com.carpentersblocks.util.attribute.EnumAttributeType;
import com.carpentersblocks.util.block.BlockUtil;
import com.carpentersblocks.util.protection.IProtected;
import com.carpentersblocks.util.protection.ProtectedObject;
import com.carpentersblocks.util.registry.ConfigRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CbTileEntity
extends TileEntity
implements IProtected {
    public static final String TAG_ATTR_LIST = "cbAttrList";
    public static final String TAG_METADATA = "cbMetadata";
    public static final String TAG_OWNER = "cbOwner";
    private Map<String, Object> _properties;
    private Map<AbstractAttribute.Key, AbstractAttribute> _cbAttrMap = new LinkedHashMap<AbstractAttribute.Key, AbstractAttribute>();
    private AttributeHelper _cbAttrHelper = new AttributeHelper(this._cbAttrMap);
    private int _cbMetadata;
    private String _cbOwner = "";
    private static boolean _calcLighting = false;
    private int _lightValue = -1;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this._cbAttrMap.clear();
        NBTTagList nbtTagList = nbt.func_150295_c(TAG_ATTR_LIST, 10);
        for (int idx = 0; idx < nbtTagList.func_74745_c(); ++idx) {
            NBTTagCompound nbt1 = nbtTagList.func_150305_b(idx);
            String identifier = nbt1.func_74779_i("cbAttrModel");
            AbstractAttribute attribute = null;
            if (identifier.equalsIgnoreCase("ItemStack")) {
                attribute = new AttributeItemStack();
            } else if (identifier.equalsIgnoreCase("String")) {
                attribute = new AttributeString();
            }
            if (attribute == null) continue;
            attribute.readFromNBT(nbt1);
            this._cbAttrMap.put(attribute.getKey(), attribute);
        }
        this._cbMetadata = nbt.func_74762_e(TAG_METADATA);
        this._cbOwner = nbt.func_74779_i(TAG_OWNER);
        this.update(false);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList nbtTagList = new NBTTagList();
        for (Map.Entry<AbstractAttribute.Key, AbstractAttribute> entry : this._cbAttrMap.entrySet()) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            AbstractAttribute attribute = entry.getValue();
            attribute.writeToNBT(nbt1);
            nbtTagList.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a(TAG_ATTR_LIST, (NBTBase)nbtTagList);
        nbt.func_74768_a(TAG_METADATA, this._cbMetadata);
        nbt.func_74778_a(TAG_OWNER, this._cbOwner);
        return nbt;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void copyOwner(CbTileEntity TE) {
        this._cbOwner = TE.getOwner();
        this.func_70296_d();
    }

    @Override
    public void setOwner(ProtectedObject obj) {
        this._cbOwner = obj.toString();
        this.func_70296_d();
    }

    @Override
    public String getOwner() {
        return this._cbOwner;
    }

    public ItemStack getDroppedItemStack(AbstractAttribute.Key key) {
        AbstractAttribute attribute = this._cbAttrHelper.getAttribute(key);
        if (attribute instanceof AttributeItemStack) {
            ItemStack itemStack = (ItemStack)attribute.getModel();
            if (EnumAttributeType.COVER.equals((Object)key.getType())) {
                IBlockState blockState = BlockUtil.getAttributeBlockState(this._cbAttrHelper, key.getLocation(), key.getType());
                int metadata = blockState.func_177230_c().func_176201_c(blockState);
                itemStack.func_77964_b(metadata);
            }
            return itemStack;
        }
        return null;
    }

    public boolean addAttribute(EnumAttributeLocation location, EnumAttributeType type, Object model) {
        if (this._cbAttrHelper.hasAttribute(location, type) || model == null) {
            return false;
        }
        if (model instanceof ItemStack) {
            ItemStack reducedStack = ((ItemStack)model).func_77946_l();
            reducedStack.func_190920_e(1);
            this._cbAttrMap.put(AbstractAttribute.generateKey(location, type), new AttributeItemStack(location, type, reducedStack));
            World world = this.func_145831_w();
            switch (type) {
                case COVER: 
                case ILLUMINATOR: 
                case DYE: 
                case PLANT: 
                case SOIL: {
                    break;
                }
                case FERTILIZER: {
                    break;
                }
            }
        } else if (model instanceof String) {
            this._cbAttrMap.put(AbstractAttribute.generateKey(location, type), new AttributeString(location, type, (String)model));
        } else {
            return false;
        }
        return true;
    }

    public boolean onAttrDropped(AbstractAttribute.Key key) {
        if (this._cbAttrMap.remove(key) == null) {
            return false;
        }
        this.update(true);
        return true;
    }

    private boolean createBlockDropEvent(AttributeItemStack attribute) {
        this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_145838_q(), BlockCoverable.EVENT_ID_DROP_ATTR, attribute.getKey().hashCode());
        return true;
    }

    public boolean removeAttribute(EnumAttributeLocation location, EnumAttributeType type) {
        if (this._cbAttrHelper.hasAttribute(location, type)) {
            AbstractAttribute attribute = this._cbAttrHelper.getAttribute(location, type);
            return this.removeAttribute(attribute);
        }
        return false;
    }

    private boolean removeAttribute(AbstractAttribute attribute) {
        return this._cbAttrMap.remove(attribute.getKey()) != null;
    }

    public boolean removeLastAddedDroppableAttribute(EnumAttributeLocation location) {
        AbstractAttribute attribute = this._cbAttrHelper.getLastAddedDroppableAttribute(location);
        if (attribute instanceof AttributeItemStack) {
            return this.createBlockDropEvent((AttributeItemStack)attribute);
        }
        return false;
    }

    public void removeAttributes(EnumAttributeLocation location) {
        for (Map.Entry<AbstractAttribute.Key, AbstractAttribute> pair : this._cbAttrMap.entrySet()) {
            AbstractAttribute attribute = pair.getValue();
            if (!attribute.getLocation().equals((Object)location)) continue;
            this.removeAttribute(attribute);
        }
    }

    public int getCbMetadata() {
        return this._cbMetadata;
    }

    public boolean setCbMetadata(int cbMetadata) {
        if (!this.func_145831_w().field_72995_K) {
            if (cbMetadata == this.getCbMetadata()) {
                return false;
            }
            this._cbMetadata = cbMetadata;
            this.update(true);
        }
        return true;
    }

    public List<ItemStack> getAllDroppableAttributes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Map.Entry<AbstractAttribute.Key, AbstractAttribute> pair : this._cbAttrMap.entrySet()) {
            if (!(pair.getValue() instanceof AttributeItemStack)) continue;
            list.add((ItemStack)((AttributeItemStack)pair.getValue()).getModel());
        }
        return list;
    }

    public AttributeHelper getAttributeHelper() {
        return this._cbAttrHelper;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public Object getProperty(String key) {
        if (this._properties == null) {
            return null;
        }
        return this._properties.get(key);
    }

    public void setProperty(String key, Object value) {
        if (this._properties == null) {
            this._properties = new HashMap<String, Object>();
        }
        this._properties.put(key, value);
    }

    public void removeProperty(String key) {
        if (this._properties != null) {
            this._properties.remove(key);
        }
    }

    public int getLightValue() {
        if (this._lightValue == -1 && !_calcLighting) {
            this.updateCachedLighting();
        }
        return this._lightValue;
    }

    protected int getDynamicLightValue() {
        int value = 0;
        if (ConfigRegistry.enableIllumination && this._cbAttrHelper.hasAttribute(EnumAttributeLocation.HOST, EnumAttributeType.ILLUMINATOR)) {
            return 15;
        }
        _calcLighting = true;
        for (IBlockState blockState : this._cbAttrHelper.getAttributeBlockStates()) {
            int posLightValue = blockState.func_177230_c().getLightValue(blockState, (IBlockAccess)this.func_145831_w(), this.func_174877_v());
            if (posLightValue > 0) {
                value = Math.max(value, posLightValue);
                continue;
            }
            value = Math.max(value, blockState.func_177230_c().func_149750_m(blockState));
        }
        _calcLighting = false;
        return value;
    }

    private void updateCachedLighting() {
        this._lightValue = this.getDynamicLightValue();
        this.func_145831_w().func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
    }

    public void update(boolean markDirty) {
        World world = this.func_145831_w();
        if (world != null) {
            IBlockState blockState = world.func_180495_p(this.field_174879_c);
            world.func_184138_a(this.field_174879_c, blockState, blockState, 4);
            Block block = this.func_145838_q();
            if (block.func_149744_f(blockState)) {
                world.func_175685_c(this.field_174879_c, this.field_145854_h, false);
            }
            this.updateCachedLighting();
            if (markDirty) {
                this.func_70296_d();
            }
        }
    }
}

