/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.block.data.SlopeData;
import com.carpentersblocks.tileentity.CbTileEntity;
import com.carpentersblocks.util.RotationUtil;
import com.carpentersblocks.util.handler.EventHandler;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCarpentersSlope
extends BlockCoverable {
    public static final String[] slopeType = new String[]{"wedge", "wedgeInterior", "wedgeExterior", "obliqueInterior", "obliqueExterior", "prismWedge", "prism", "invertPrism"};
    private boolean rayTracing;

    public BlockCarpentersSlope(Material material) {
        super(material);
    }

    @Override
    protected boolean onHammerLeftClick(CbTileEntity cbTileEntity, EntityPlayer entityPlayer) {
        return this.rotateBlock(cbTileEntity.func_145831_w(), cbTileEntity.func_174877_v(), EventHandler.eventFace);
    }

    @Override
    protected boolean onHammerRightClick(CbTileEntity cbTileEntity, EntityPlayer entityPlayer) {
        new SlopeData();
        SlopeData.setNextType(cbTileEntity);
        return true;
    }

    @Override
    protected boolean shareFaces(CbTileEntity cbTileEntity_adj, CbTileEntity cbTileEntity_src, EnumFacing side_adj, EnumFacing side_src) {
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        _threadLocalHitCoords.set(new Float[]{Float.valueOf(hitX), Float.valueOf(hitY), Float.valueOf(hitZ)});
        _threadLocalFacing.set(facing);
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, IBlockState blockState, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.func_180633_a(world, blockPos, blockState, entityLivingBase, itemStack);
        CbTileEntity cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos);
        if (cbTileEntity != null) {
            switch (itemStack.func_77952_i()) {
                case 0: {
                    SlopeData.setType(cbTileEntity, SlopeData.Type.WEDGE);
                    break;
                }
                case 1: {
                    SlopeData.setType(cbTileEntity, SlopeData.Type.WEDGE_INTERIOR);
                    break;
                }
                case 2: {
                    SlopeData.setType(cbTileEntity, SlopeData.Type.WEDGE_EXTERIOR);
                    break;
                }
                case 3: {
                    SlopeData.setType(cbTileEntity, SlopeData.Type.OBLIQUE_INTERIOR);
                    break;
                }
                case 4: {
                    SlopeData.setType(cbTileEntity, SlopeData.Type.OBLIQUE_EXTERIOR);
                    break;
                }
                case 5: {
                    SlopeData.setType(cbTileEntity, SlopeData.Type.PRISM_WEDGE);
                    break;
                }
                case 6: {
                    SlopeData.setType(cbTileEntity, SlopeData.Type.PRISM);
                    break;
                }
                default: {
                    SlopeData.setType(cbTileEntity, SlopeData.Type.INVERT_PRISM);
                }
            }
            float x = ((Float[])_threadLocalHitCoords.get())[0].floatValue();
            float y = ((Float[])_threadLocalHitCoords.get())[1].floatValue();
            float z = ((Float[])_threadLocalHitCoords.get())[2].floatValue();
            _threadLocalHitCoords.remove();
            EnumFacing facing = (EnumFacing)_threadLocalFacing.get();
            _threadLocalFacing.remove();
            RotationUtil.Rotation rotation = RotationUtil.Rotation.X0_Y0_Z0;
            EnumFacing cardinalFacing = entityLivingBase.func_174811_aO().func_176734_d();
            block9 : switch (facing) {
                case DOWN: {
                    if (x >= 0.2f && x <= 0.8f && z >= 0.2f && z <= 0.8f) {
                        switch (entityLivingBase.func_174811_aO()) {
                            case NORTH: {
                                rotation = RotationUtil.Rotation.X0_Y0_Z180;
                                break block9;
                            }
                            case SOUTH: {
                                rotation = RotationUtil.Rotation.X180_Y0_Z0;
                                break block9;
                            }
                            case WEST: {
                                rotation = RotationUtil.Rotation.X180_Y90_Z0;
                                break block9;
                            }
                            case EAST: {
                                rotation = RotationUtil.Rotation.X180_Y270_Z0;
                                break block9;
                            }
                        }
                        break;
                    }
                    if (1.0f - x > z && x <= 0.5f && x < z) {
                        rotation = RotationUtil.Rotation.X180_Y90_Z0;
                        break;
                    }
                    if (z > x && z >= 0.5f) {
                        rotation = RotationUtil.Rotation.X180_Y0_Z0;
                        break;
                    }
                    if (x > 1.0f - z) {
                        rotation = RotationUtil.Rotation.X180_Y270_Z0;
                        break;
                    }
                    rotation = RotationUtil.Rotation.X0_Y0_Z180;
                    break;
                }
                case UP: {
                    if (x >= 0.2f && x <= 0.8f && z >= 0.2f && z <= 0.8f) {
                        switch (entityLivingBase.func_174811_aO()) {
                            case NORTH: {
                                rotation = RotationUtil.Rotation.X0_Y0_Z0;
                                break block9;
                            }
                            case SOUTH: {
                                rotation = RotationUtil.Rotation.X0_Y180_Z0;
                                break block9;
                            }
                            case WEST: {
                                rotation = RotationUtil.Rotation.X0_Y270_Z0;
                                break block9;
                            }
                            case EAST: {
                                rotation = RotationUtil.Rotation.X0_Y90_Z0;
                                break block9;
                            }
                        }
                        break;
                    }
                    if (x < z && x <= 0.5f && 1.0f - x > z) {
                        rotation = RotationUtil.Rotation.X0_Y270_Z0;
                        break;
                    }
                    if (1.0f - z > x && z <= 0.5f) {
                        rotation = RotationUtil.Rotation.X0_Y0_Z0;
                        break;
                    }
                    if (x > z) {
                        rotation = RotationUtil.Rotation.X0_Y90_Z0;
                        break;
                    }
                    rotation = RotationUtil.Rotation.X0_Y180_Z0;
                    break;
                }
                case NORTH: {
                    if (x >= 0.2f && x <= 0.8f) {
                        if (y >= 0.5f) {
                            rotation = RotationUtil.Rotation.X90_Y0_Z180;
                            break;
                        }
                        rotation = RotationUtil.Rotation.X90_Y0_Z0;
                        break;
                    }
                    if (x > y && x >= 0.5f && x > 1.0f - y) {
                        rotation = RotationUtil.Rotation.X90_Y0_Z270;
                        break;
                    }
                    if (y > 1.0f - x && y >= 0.5f) {
                        rotation = RotationUtil.Rotation.X90_Y0_Z180;
                        break;
                    }
                    if (x < y) {
                        rotation = RotationUtil.Rotation.X90_Y0_Z90;
                        break;
                    }
                    rotation = RotationUtil.Rotation.X90_Y0_Z0;
                    break;
                }
                case SOUTH: {
                    if (x >= 0.2f && x <= 0.8f) {
                        if (y >= 0.5f) {
                            rotation = RotationUtil.Rotation.X270_Y0_Z0;
                            break;
                        }
                        rotation = RotationUtil.Rotation.X90_Y180_Z0;
                        break;
                    }
                    if (1.0f - x > y && x <= 0.5f && x < y) {
                        rotation = RotationUtil.Rotation.X90_Y180_Z90;
                        break;
                    }
                    if (y > x && y >= 0.5f) {
                        rotation = RotationUtil.Rotation.X270_Y0_Z0;
                        break;
                    }
                    if (x > 1.0f - y) {
                        rotation = RotationUtil.Rotation.X270_Y0_Z90;
                        break;
                    }
                    rotation = RotationUtil.Rotation.X90_Y180_Z0;
                    break;
                }
                case WEST: {
                    if (z >= 0.2f && z <= 0.8f) {
                        if (y >= 0.5f) {
                            rotation = RotationUtil.Rotation.X270_Y90_Z0;
                            break;
                        }
                        rotation = RotationUtil.Rotation.X90_Y270_Z0;
                        break;
                    }
                    if (1.0f - z > y && z <= 0.5f && z < y) {
                        rotation = RotationUtil.Rotation.X0_Y0_Z270;
                        break;
                    }
                    if (y > z && y >= 0.5f) {
                        rotation = RotationUtil.Rotation.X270_Y90_Z0;
                        break;
                    }
                    if (z > 1.0f - y) {
                        rotation = RotationUtil.Rotation.X180_Y0_Z90;
                        break;
                    }
                    rotation = RotationUtil.Rotation.X90_Y270_Z0;
                    break;
                }
                case EAST: {
                    if (z >= 0.2f && z <= 0.8f) {
                        if (y >= 0.5f) {
                            rotation = RotationUtil.Rotation.X0_Y270_Z90;
                            break;
                        }
                        rotation = RotationUtil.Rotation.X90_Y90_Z0;
                        break;
                    }
                    rotation = z > y && z >= 0.5f && z > 1.0f - y ? RotationUtil.Rotation.X0_Y180_Z90 : (y > 1.0f - z && y >= 0.5f ? RotationUtil.Rotation.X0_Y270_Z90 : (z < y ? RotationUtil.Rotation.X0_Y0_Z90 : RotationUtil.Rotation.X90_Y90_Z0));
                }
            }
            SlopeData.setRotation(cbTileEntity, rotation);
        }
    }

    public EnumFacing[] getValidRotations(World world, BlockPos blockPos) {
        return EnumFacing.field_82609_l;
    }

    public boolean rotateBlock(World world, BlockPos blockPos, EnumFacing facing) {
        CbTileEntity cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos);
        if (cbTileEntity != null) {
            SlopeData.rotate(cbTileEntity, facing.func_176740_k());
            return true;
        }
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState blockState) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }
}

