/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.capability;

import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class PlayerActivityTracker {
    private static final Set<UUID> activePlayers = new LinkedHashSet<UUID>();
    private static final Set<UUID> onlinePlayers = new LinkedHashSet<UUID>();
    private static final Map<UUID, ActiveTime> lastActiveTimePerPlayer = new HashMap<UUID, ActiveTime>();
    private static final SortedSet<ActiveTime> sortedActiveTimes = new TreeSet<ActiveTime>();
    private static boolean dirty = false;

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        ActiveTime lastActiveTime;
        UUID playerId = e.player.func_110124_au();
        onlinePlayers.add(playerId);
        if (!activePlayers.contains(playerId)) {
            activePlayers.add(playerId);
            if (PlayerActivityTracker.isInactivityTimeOutEnabled()) {
                Arrays.stream(DimensionManager.getWorlds()).forEach(level -> ChunkLoadingCapability.get((World)level).castServer().togglePlayerActivity(playerId, true));
            }
        }
        if ((lastActiveTime = lastActiveTimePerPlayer.remove(playerId)) != null) {
            sortedActiveTimes.remove(lastActiveTime);
        }
        dirty = true;
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent e) {
        UUID playerId = e.player.func_110124_au();
        onlinePlayers.remove(playerId);
        ActiveTime lastActiveTime = new ActiveTime(playerId, System.currentTimeMillis());
        lastActiveTimePerPlayer.put(playerId, lastActiveTime);
        sortedActiveTimes.add(lastActiveTime);
        dirty = true;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            return;
        }
        long timeoutTime = System.currentTimeMillis() - PlayerActivityTracker.getInactivityTimeout();
        while (!sortedActiveTimes.isEmpty()) {
            ActiveTime earliestExpiringTime = sortedActiveTimes.first();
            if (earliestExpiringTime.lastActiveTime >= timeoutTime) break;
            sortedActiveTimes.remove(earliestExpiringTime);
            lastActiveTimePerPlayer.remove(earliestExpiringTime.player);
            activePlayers.remove(earliestExpiringTime.player);
            dirty = true;
            ActiveTime finalEarliestExpiringTime = earliestExpiringTime;
            if (!PlayerActivityTracker.isInactivityTimeOutEnabled()) continue;
            Arrays.stream(DimensionManager.getWorlds()).forEach(level -> ChunkLoadingCapability.get((World)level).castServer().togglePlayerActivity(finalEarliestExpiringTime.player, false));
        }
    }

    public static void onServerStarting(FMLServerAboutToStartEvent e) {
        activePlayers.clear();
        onlinePlayers.clear();
        lastActiveTimePerPlayer.clear();
        sortedActiveTimes.clear();
        dirty = false;
        File file = e.getServer().func_71254_M().func_186352_b(e.getServer().func_71270_I(), "chunkloaders/active_players.nbt");
        if (!file.exists()) {
            return;
        }
        try {
            NBTTagCompound data = CompressedStreamTools.func_74797_a((File)file);
            if (data != null) {
                PlayerActivityTracker.read(data);
            }
        }
        catch (IOException exception) {
            ChunkLoaders.LOGGER.error("Failed to load player activity data!", (Throwable)exception);
        }
    }

    @SubscribeEvent
    public static void onWorldSave(WorldEvent.Save e) {
        if (!(e.getWorld() instanceof WorldServer)) {
            return;
        }
        if (dirty) {
            NBTTagCompound data = PlayerActivityTracker.write();
            File file = e.getWorld().func_73046_m().func_71254_M().func_186352_b(e.getWorld().func_73046_m().func_71270_I(), "chunkloaders/active_players.nbt");
            file.getParentFile().mkdirs();
            try {
                CompressedStreamTools.func_74795_b((NBTTagCompound)data, (File)file);
            }
            catch (IOException exception) {
                ChunkLoaders.LOGGER.error("Failed to write active player data!", (Throwable)exception);
                return;
            }
            dirty = false;
        }
    }

    public static boolean isPlayerActive(UUID player) {
        return !PlayerActivityTracker.isInactivityTimeOutEnabled() || activePlayers.contains(player);
    }

    private static boolean isInactivityTimeOutEnabled() {
        return ChunkLoadersConfig.inactivityTimeout.get() > 0L;
    }

    private static long getInactivityTimeout() {
        return ChunkLoadersConfig.inactivityTimeout.get() * 60L * 1000L;
    }

    private static NBTTagCompound write() {
        NBTTagCompound tag;
        NBTTagList activeTimes = new NBTTagList();
        for (UUID player : onlinePlayers) {
            tag = new NBTTagCompound();
            tag.func_186854_a("player", player);
            tag.func_74772_a("time", System.currentTimeMillis());
            activeTimes.func_74742_a((NBTBase)tag);
        }
        for (ActiveTime activeTime : lastActiveTimePerPlayer.values()) {
            tag = new NBTTagCompound();
            tag.func_186854_a("player", activeTime.player);
            tag.func_74772_a("time", activeTime.lastActiveTime);
            activeTimes.func_74742_a((NBTBase)tag);
        }
        NBTTagCompound tag2 = new NBTTagCompound();
        tag2.func_74782_a("times", (NBTBase)activeTimes);
        return tag2;
    }

    private static void read(NBTTagCompound tag) {
        NBTTagList activeTimes = tag.func_150295_c("times", 10);
        for (NBTBase nbt : activeTimes) {
            NBTTagCompound timeTag;
            if (!(nbt instanceof NBTTagCompound) || !(timeTag = (NBTTagCompound)nbt).func_150297_b("playerLeast", 4) || !timeTag.func_150297_b("time", 4)) continue;
            ActiveTime activeTime = new ActiveTime(timeTag.func_186857_a("player"), timeTag.func_74763_f("time"));
            activePlayers.add(activeTime.player);
            sortedActiveTimes.add(activeTime);
        }
    }

    private static class ActiveTime
    implements Comparable<ActiveTime> {
        public final UUID player;
        public long lastActiveTime;

        public ActiveTime(UUID player, long lastActiveTime) {
            this.player = player;
            this.lastActiveTime = lastActiveTime;
        }

        @Override
        public int compareTo(ActiveTime other) {
            return Long.compare(this.lastActiveTime, other.lastActiveTime);
        }
    }
}

