/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.capability;

import com.supermartijn642.chunkloaders.ChunkLoaderType;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class ChunkLoaderCache {
    public final BlockPos chunkLoaderPos;
    public final ChunkPos chunkPos;
    public final ChunkLoaderType chunkLoaderType;
    public final UUID owner;

    public ChunkLoaderCache(BlockPos pos, ChunkLoaderType type, UUID owner) {
        if (pos == null) {
            throw new IllegalArgumentException("Chunk loader position must not be null!");
        }
        if (type == null) {
            throw new IllegalArgumentException("Chunk loader type must not be null!");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Owner must not be null!");
        }
        this.chunkLoaderPos = pos;
        this.chunkPos = new ChunkPos(pos);
        this.chunkLoaderType = type;
        this.owner = owner;
    }

    public NBTTagCompound write() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74772_a("chunkLoaderPos", this.chunkLoaderPos.func_177986_g());
        compound.func_74768_a("chunkLoaderType", this.chunkLoaderType.getIndex());
        compound.func_186854_a("owner", this.owner);
        return compound;
    }

    public static ChunkLoaderCache read(NBTTagCompound compound) {
        return new ChunkLoaderCache(BlockPos.func_177969_a((long)compound.func_74763_f("chunkLoaderPos")), ChunkLoaderType.byIndex(compound.func_74762_e("chunkLoaderType")), compound.func_186857_a("owner"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkLoaderCache that = (ChunkLoaderCache)o;
        if (!this.chunkLoaderPos.equals((Object)that.chunkLoaderPos)) {
            return false;
        }
        if (!this.chunkPos.equals((Object)that.chunkPos)) {
            return false;
        }
        if (this.chunkLoaderType != that.chunkLoaderType) {
            return false;
        }
        return this.owner.equals(that.owner);
    }

    public int hashCode() {
        int result = this.chunkLoaderPos.hashCode();
        result = 31 * result + this.chunkPos.hashCode();
        result = 31 * result + this.chunkLoaderType.hashCode();
        result = 31 * result + this.owner.hashCode();
        return result;
    }
}

