/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.simpleteleporters.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import party.lemons.simpleteleporters.block.TileEntityTeleporter;
import party.lemons.simpleteleporters.config.ModConfig;
import party.lemons.simpleteleporters.item.SimpleTeleportersItems;

public class BlockTeleporter
extends Block
implements ITileEntityProvider {
    public static final PropertyBool ON = PropertyBool.func_177716_a((String)"on");
    protected static final AxisAlignedBB TELE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3, 1.0);

    public BlockTeleporter() {
        super(Material.field_151576_e);
        this.func_149663_c("teleporter");
        this.setRegistryName("teleporter");
        this.func_149647_a(CreativeTabs.field_78029_e);
        this.func_149715_a(1.0f);
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileEntityTeleporter teleporter;
        if (entityIn.func_70093_af() && (teleporter = (TileEntityTeleporter)worldIn.func_175625_s(pos)).hasCrystal() && teleporter.isInDimension(entityIn)) {
            entityIn.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            if (!worldIn.field_72995_K) {
                BlockPos teleportPos = teleporter.getTeleportPosition();
                EntityPlayerMP emp = (EntityPlayerMP)entityIn;
                float pYaw = emp.field_70177_z;
                if (ModConfig.teleport_use_crystal_direction) {
                    pYaw = teleporter.getFacingDirection();
                }
                emp.field_71135_a.func_147364_a((double)teleportPos.func_177958_n() + 0.5, (double)teleportPos.func_177956_o(), (double)teleportPos.func_177952_p() + 0.5, pYaw, emp.field_70127_C);
                entityIn.field_70181_x = 0.5;
            }
            entityIn.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityTeleporter();
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 1) {
            return this.func_176223_P().func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf(true));
        }
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ON) == false ? 0 : 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ON});
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return TELE_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)ON)).booleanValue()) {
            for (int i = 0; i < ModConfig.teleporter_particle_amount; ++i) {
                worldIn.func_175688_a(EnumParticleTypes.PORTAL, (double)((float)pos.func_177958_n() + 0.2f + rand.nextFloat() / 2.0f), (double)((float)pos.func_177956_o() + 0.4f), (double)((float)pos.func_177952_p() + 0.2f + rand.nextFloat() / 2.0f), 0.0, (double)rand.nextFloat(), 0.0, new int[0]);
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState blockstate) {
        TileEntityTeleporter te = (TileEntityTeleporter)world.func_175625_s(pos);
        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)te.getCrystal());
        super.func_180663_b(world, pos, blockstate);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float x, float y, float z) {
        TileEntityTeleporter tele = (TileEntityTeleporter)worldIn.func_175625_s(pos);
        if (tele.hasCrystal()) {
            ItemStack crystalStack = tele.getCrystal();
            playerIn.field_71071_by.func_70441_a(crystalStack);
            playerIn.func_184185_a(SoundEvents.field_187737_v, 0.5f, 0.4f / (worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f));
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf(false)));
            tele.setCrystal(ItemStack.field_190927_a);
            return true;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == SimpleTeleportersItems.teleCrystal && stack.func_77978_p() != null) {
            playerIn.func_184185_a(SoundEvents.field_187737_v, 0.5f, 0.4f / (worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f));
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf(true)));
            tele = (TileEntityTeleporter)worldIn.func_175625_s(pos);
            ItemStack setstack = stack.func_77946_l();
            setstack.func_190920_e(1);
            tele.setCrystal(setstack);
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }
}

