/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.interfaces.IDimensionManager;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.util.Dimension;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;

public class DimensionManager
implements IDimensionManager {
    IVoxelMap master;
    public ArrayList<Dimension> dimensions;
    private static Method providersGetDimensionMethod = null;

    public DimensionManager(IVoxelMap master) {
        this.master = master;
        this.dimensions = new ArrayList();
    }

    @Override
    public ArrayList<Dimension> getDimensions() {
        return this.dimensions;
    }

    @Override
    public void populateDimensions() {
        this.dimensions.clear();
        for (int t = -1; t <= 1; ++t) {
            String name = "notLoaded";
            WorldProvider provider = null;
            try {
                provider = DimensionType.func_186069_a((int)t).func_186070_d();
            }
            catch (Exception e) {
                provider = null;
            }
            if (provider == null) continue;
            try {
                name = provider.func_186058_p().func_186065_b();
            }
            catch (Exception e) {
                name = "failedToLoad";
            }
            Dimension dim = new Dimension(name, t);
            this.dimensions.add(dim);
        }
        for (Waypoint pt : this.master.getWaypointManager().getWaypoints()) {
            for (Integer t : pt.dimensions) {
                if (this.getDimensionByID(t) != null) continue;
                String name = "notLoaded";
                WorldProvider provider = null;
                try {
                    provider = DimensionType.func_186069_a((int)t).func_186070_d();
                }
                catch (Exception e) {
                    provider = null;
                }
                if (provider == null) continue;
                try {
                    name = provider.func_186058_p().func_186065_b();
                }
                catch (Exception e) {
                    name = "failedToLoad";
                }
                Dimension dim = new Dimension(name, t);
                this.dimensions.add(dim);
            }
        }
        Collections.sort(this.dimensions, new Comparator<Dimension>(){

            @Override
            public int compare(Dimension dim1, Dimension dim2) {
                return dim1.ID - dim2.ID;
            }
        });
    }

    @Override
    public void enteredDimension(int ID) {
        Dimension dim = this.getDimensionByID(ID);
        if (dim == null) {
            dim = new Dimension("notLoaded", ID);
            this.dimensions.add(dim);
            Collections.sort(this.dimensions, new Comparator<Dimension>(){

                @Override
                public int compare(Dimension dim1, Dimension dim2) {
                    return dim1.ID - dim2.ID;
                }
            });
        }
        if (dim.name.equals("notLoaded") || dim.name.equals("failedToLoad")) {
            try {
                dim.name = Minecraft.func_71410_x().field_71441_e.field_73011_w.func_186058_p().func_186065_b() + " " + ID;
            }
            catch (Exception e) {
                dim.name = "dimension " + ID + "(" + Minecraft.func_71410_x().field_71441_e.field_73011_w.getClass().getSimpleName() + ")";
            }
        }
    }

    @Override
    public Dimension getDimensionByID(int ID) {
        for (Dimension dim : this.dimensions) {
            if (dim.ID != ID) continue;
            return dim;
        }
        return null;
    }

    public static int getDimensionIDfromProvider(WorldProvider provider) {
        int id = 0;
        if (providersGetDimensionMethod != null) {
            try {
                id = (Integer)providersGetDimensionMethod.invoke((Object)provider, new Object[0]);
            }
            catch (IllegalAccessException e) {
                id = provider.func_186058_p().func_186068_a();
            }
            catch (IllegalArgumentException e) {
                id = provider.func_186058_p().func_186068_a();
            }
            catch (InvocationTargetException e) {
                id = provider.func_186058_p().func_186068_a();
            }
        } else {
            id = provider.func_186058_p().func_186068_a();
        }
        return id;
    }

    static {
        try {
            Class<?> worldProviderClass = Class.forName("net.minecraft.world.WorldProvider");
            Class[] argClasses = new Class[]{};
            providersGetDimensionMethod = worldProviderClass.getMethod("getDimension", argClasses);
        }
        catch (ClassNotFoundException e) {
            providersGetDimensionMethod = null;
        }
        catch (NoSuchMethodException e) {
            providersGetDimensionMethod = null;
        }
    }
}

