/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;

public class BlockRepository {
    public static Block air;
    public static int airID;
    public static BlockPistonMoving pistonTechBlock;
    public static BlockLiquid water;
    public static BlockLiquid flowingWater;
    public static Block lava;
    public static Block flowingLava;
    public static Block ice;
    public static Block grass;
    public static Block leaves;
    public static Block tallGrass;
    public static Block reeds;
    public static Block vine;
    public static Block lilypad;
    public static Block leaves2;
    public static Block tallFlower;
    public static Block cobweb;
    public static Block stickyPiston;
    public static Block piston;
    public static Block redstone;
    public static Block sign;
    public static Block ladder;
    public static Block wallSign;
    public static Block woodDoor;
    public static Block ironDoor;
    public static Block spruceDoor;
    public static Block birchDoor;
    public static Block jungleDoor;
    public static Block darkOakDoor;
    public static Block acaciaDoor;
    public static Block barrier;
    public static Block chorusPlant;
    public static Block chorusFlower;
    public static HashSet<Block> biomeBlocks;
    public static Block[] biomeBlocksArray;
    public static HashSet<Block> shapedBlocks;
    public static Block[] doorsArray;
    public static Block[] shapedBlocksArray;
    private static Reference2IntOpenHashMap<IBlockState> stateToInt;
    private static ReferenceArrayList<IBlockState> blockStates;
    private static int count;
    private static ReadWriteLock incrementLock;
    public static BiMap<IBlockState, Integer> defaultStorageStateIDs;
    public static BiMap<Block, Integer> blockIDs;

    public static void getBlocks() {
        air = Block.func_149684_b((String)"minecraft:air");
        airID = BlockRepository.getStateId(air.func_176223_P());
        pistonTechBlock = (BlockPistonMoving)Block.func_149684_b((String)"minecraft:piston_extension");
        water = (BlockLiquid)Block.func_149684_b((String)"minecraft:water");
        flowingWater = (BlockLiquid)Block.func_149684_b((String)"minecraft:flowing_water");
        lava = Block.func_149684_b((String)"minecraft:lava");
        flowingLava = Block.func_149684_b((String)"minecraft:flowing_lava");
        ice = Block.func_149684_b((String)"minecraft:ice");
        grass = Block.func_149684_b((String)"minecraft:grass");
        leaves = Block.func_149684_b((String)"minecraft:leaves");
        tallGrass = Block.func_149684_b((String)"minecraft:tallgrass");
        reeds = Block.func_149684_b((String)"minecraft:reeds");
        vine = Block.func_149684_b((String)"minecraft:vine");
        lilypad = Block.func_149684_b((String)"minecraft:waterlily");
        leaves2 = Block.func_149684_b((String)"minecraft:leaves2");
        tallFlower = Block.func_149684_b((String)"minecraft:double_plant");
        cobweb = Block.func_149684_b((String)"minecraft:web");
        stickyPiston = Block.func_149684_b((String)"minecraft:sticky_piston");
        piston = Block.func_149684_b((String)"minecraft:piston");
        redstone = Block.func_149684_b((String)"minecraft:redstone_wire");
        sign = Block.func_149684_b((String)"minecraft:standing_sign");
        ladder = Block.func_149684_b((String)"minecraft:ladder");
        wallSign = Block.func_149684_b((String)"minecraft:wall_sign");
        woodDoor = Block.func_149684_b((String)"minecraft:wooden_door");
        ironDoor = Block.func_149684_b((String)"minecraft:iron_door");
        spruceDoor = Block.func_149684_b((String)"minecraft:spruce_door");
        birchDoor = Block.func_149684_b((String)"minecraft:birch_door");
        jungleDoor = Block.func_149684_b((String)"minecraft:jungle_door");
        darkOakDoor = Block.func_149684_b((String)"minecraft:dark_oak_door");
        acaciaDoor = Block.func_149684_b((String)"minecraft:acacia_door");
        barrier = Block.func_149684_b((String)"minecraft:barrier");
        chorusPlant = Block.func_149684_b((String)"minecraft:chorus_plant");
        chorusFlower = Block.func_149684_b((String)"minecraft:chorus_flower");
        biomeBlocksArray = new Block[]{grass, leaves, tallGrass, reeds, vine, lilypad, leaves2, tallFlower, water, flowingWater};
        biomeBlocks = new HashSet<Block>(Arrays.asList(biomeBlocksArray));
        doorsArray = new Block[]{woodDoor, ironDoor, spruceDoor, birchDoor, jungleDoor, darkOakDoor, acaciaDoor};
        shapedBlocksArray = new Block[]{sign, ladder, wallSign, vine};
        shapedBlocks = new HashSet<Block>(Arrays.asList(shapedBlocksArray));
        shapedBlocks.addAll(Arrays.asList(doorsArray));
    }

    public static int getStateId(IBlockState blockState) {
        incrementLock.readLock().lock();
        int id = stateToInt.getInt((Object)blockState);
        incrementLock.readLock().unlock();
        if (id == -1) {
            incrementLock.writeLock().lock();
            id = stateToInt.getInt((Object)blockState);
            if (id == -1) {
                id = count++;
                blockStates.add((Object)blockState);
                stateToInt.put((Object)blockState, id);
            }
            incrementLock.writeLock().unlock();
        }
        return id;
    }

    public static IBlockState getStateById(int id) {
        return (IBlockState)blockStates.get(id);
    }

    public static void loadDefaultStorageStateIDs() {
        for (ResourceLocation resourceLocation : Block.field_149771_c.func_148742_b()) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
            if (block == Blocks.field_150350_a && (!resourceLocation.func_110624_b().equals("minecraft") || !resourceLocation.func_110623_a().equals("air"))) continue;
            ImmutableList blockStates = block.func_176194_O().func_177619_a();
            for (IBlockState blockState : blockStates) {
                defaultStorageStateIDs.forcePut((Object)blockState, (Object)Block.func_176210_f((IBlockState)blockState));
            }
        }
    }

    public static void loadBlockIDs() {
        try {
            String sCurrentLine;
            String filename = "conf/blockIDs.txt";
            InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("voxelmap", filename)).func_110527_b();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((sCurrentLine = br.readLine()) != null) {
                try {
                    BlockRepository.parseLine(sCurrentLine, blockIDs);
                }
                catch (Exception e) {
                    System.out.println("Error parsing blockID storage line: " + sCurrentLine);
                }
            }
            br.close();
            is.close();
        }
        catch (IOException e) {
            System.out.println("Error loading old block IDs config file from litemod!");
            e.printStackTrace();
        }
    }

    public static void parseLine(String line, BiMap<Block, Integer> map) {
        String[] lineParts = line.split(" ");
        int id = Integer.parseInt(lineParts[0]);
        Block block = Block.func_149684_b((String)lineParts[1]);
        if (block != null) {
            map.forcePut((Object)block, (Object)id);
        }
    }

    static {
        airID = 0;
        biomeBlocksArray = new Block[]{grass, leaves, tallGrass, reeds, vine, lilypad, leaves2, tallFlower, water, flowingWater};
        doorsArray = new Block[]{woodDoor, ironDoor, spruceDoor, birchDoor, jungleDoor, darkOakDoor, acaciaDoor};
        shapedBlocksArray = new Block[]{sign, woodDoor, ladder, wallSign, ironDoor, vine};
        stateToInt = new Reference2IntOpenHashMap(1024);
        blockStates = new ReferenceArrayList(16384);
        count = 1;
        incrementLock = new ReentrantReadWriteLock();
        stateToInt.defaultReturnValue(-1);
        IBlockState airBlockState = Blocks.field_150350_a.func_176223_P();
        stateToInt.put((Object)airBlockState, 0);
        blockStates.add((Object)airBlockState);
        defaultStorageStateIDs = HashBiMap.create((int)2000);
        blockIDs = HashBiMap.create((int)256);
    }
}

