/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.tiles.devices;

import com.verdantartifice.thaumicwonders.common.blocks.BlocksTW;
import com.verdantartifice.thaumicwonders.common.items.ItemsTW;
import com.verdantartifice.thaumicwonders.common.tiles.base.TileTWInventory;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.blocks.IBlockEnabled;
import thaumcraft.common.blocks.IBlockFacingHorizontal;
import thaumcraft.common.lib.SoundsTC;

public class TilePrimordialAccelerator
extends TileTWInventory
implements ITickable {
    protected static final int MAX_TUNNELS = 10;

    public TilePrimordialAccelerator() {
        super(1);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public void func_73660_a() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!this.field_145850_b.field_72995_K && state != null && state.func_177230_c() == BlocksTW.PRIMORDIAL_ACCELERATOR) {
            boolean powered = (Boolean)state.func_177229_b((IProperty)IBlockEnabled.ENABLED) == false;
            ItemStack pearlStack = this.func_70301_a(0);
            if (powered && pearlStack != null && !pearlStack.func_190926_b() && pearlStack.func_77973_b() == ItemsTC.primordialPearl && pearlStack.func_77952_i() < 7) {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)IBlockFacingHorizontal.FACING);
                BlockPos curPos = this.field_174879_c;
                int tunnelCount = 0;
                boolean done = false;
                this.func_70299_a(0, ItemStack.field_190927_a);
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.zap, SoundCategory.BLOCKS, 1.0f, (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.wind, SoundCategory.BLOCKS, 1.0f, (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                for (int index = 0; index < 20 && !done; ++index) {
                    EnumFacing curFacing;
                    IBlockState curState = this.field_145850_b.func_180495_p(curPos = curPos.func_177972_a(facing));
                    if (curState.func_177230_c() == BlocksTW.PRIMORDIAL_ACCELERATOR_TERMINUS) {
                        curFacing = (EnumFacing)curState.func_177229_b((IProperty)IBlockFacingHorizontal.FACING);
                        if (curFacing == facing) {
                            this.completeReaction(curPos, tunnelCount, pearlStack);
                            done = true;
                            continue;
                        }
                        this.explode(curPos);
                        done = true;
                        continue;
                    }
                    if (curState.func_177230_c() == BlocksTW.PRIMORDIAL_ACCELERATOR_TUNNEL) {
                        curFacing = (EnumFacing)curState.func_177229_b((IProperty)IBlockFacingHorizontal.FACING);
                        if (curFacing == facing && tunnelCount < 10) {
                            ++tunnelCount;
                            continue;
                        }
                        this.explode(curPos);
                        done = true;
                        continue;
                    }
                    if (curState.func_185904_a() == Material.field_151579_a) {
                        done = true;
                        continue;
                    }
                    this.explode(curPos);
                    done = true;
                }
                if (!done) {
                    this.explode(curPos);
                }
            }
        }
    }

    protected void completeReaction(BlockPos terminusPos, int tunnelCount, ItemStack pearlStack) {
        int count = MathHelper.func_76125_a((int)(pearlStack.func_77958_k() - pearlStack.func_77952_i()), (int)0, (int)8);
        for (int index = 0; index < count; ++index) {
            this.ejectGrain(terminusPos);
            if (this.field_145850_b.field_73012_v.nextInt(20) < 10 + tunnelCount) {
                this.ejectGrain(terminusPos);
            }
            if (this.field_145850_b.field_73012_v.nextInt(20) >= tunnelCount) continue;
            this.ejectGrain(terminusPos);
        }
    }

    protected void ejectGrain(BlockPos ejectPos) {
        ItemStack stack = new ItemStack(ItemsTW.PRIMORDIAL_GRAIN);
        EntityItem entity = new EntityItem(this.field_145850_b, (double)ejectPos.func_177958_n() + 0.5, (double)ejectPos.func_177956_o() + 1.0, (double)ejectPos.func_177952_p() + 0.5, stack);
        entity.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * 0.1;
        entity.field_70181_x = 0.3;
        entity.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * 0.1;
        this.field_145850_b.func_72838_d((Entity)entity);
    }

    protected void explode(BlockPos explosionPos) {
        this.field_145850_b.func_72876_a(null, (double)explosionPos.func_177958_n() + 0.5, (double)explosionPos.func_177956_o() + 0.5, (double)explosionPos.func_177952_p() + 0.5, 4.0f, true);
    }
}

