/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.tiles.devices;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.entities.EntityVoidPortal;
import com.verdantartifice.thaumicwonders.common.network.PacketHandler;
import com.verdantartifice.thaumicwonders.common.network.packets.PacketLocalizedMessage;
import com.verdantartifice.thaumicwonders.common.tiles.base.TileTW;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.items.IGogglesDisplayExtended;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.blocks.IBlockEnabled;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.entities.monster.EntityEldritchGuardian;
import thaumcraft.common.entities.monster.EntityInhabitedZombie;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.entities.monster.cult.EntityCultistPortalLesser;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.RandomItemChooser;
import thaumcraft.common.tiles.devices.TileStabilizer;

public class TilePortalGenerator
extends TileTW
implements ITickable,
IGogglesDisplayExtended {
    protected static DecimalFormat decFormatter = new DecimalFormat("#######.##");
    protected static List<RandomItemChooser.Item> instabilityEvents = new ArrayList<RandomItemChooser.Item>();
    protected static List<RandomItemChooser.Item> spawnEvents = new ArrayList<RandomItemChooser.Item>();
    protected static List<RandomItemChooser.Item> subvertEvents = new ArrayList<RandomItemChooser.Item>();
    protected int linkX = 0;
    protected int linkY = 0;
    protected int linkZ = 0;
    protected int linkDim = 0;
    protected float stability = 0.0f;
    protected int sparkCounter = 0;
    protected int ticksExisted = 0;
    protected boolean lastEnabled = true;
    protected float lastStabilityIncrease = 0.0f;
    protected float lastStabilityDecrease = 0.0f;

    @Override
    protected void readFromTileNBT(NBTTagCompound compound) {
        this.linkX = compound.func_74762_e("linkX");
        this.linkY = compound.func_74762_e("linkY");
        this.linkZ = compound.func_74762_e("linkZ");
        this.linkDim = compound.func_74762_e("linkDim");
        this.stability = compound.func_74760_g("stability");
        this.lastStabilityIncrease = compound.func_74760_g("lastStabilityIncrease");
        this.lastStabilityDecrease = compound.func_74760_g("lastStabilityDecrease");
    }

    @Override
    protected NBTTagCompound writeToTileNBT(NBTTagCompound compound) {
        compound.func_74768_a("linkX", this.linkX);
        compound.func_74768_a("linkY", this.linkY);
        compound.func_74768_a("linkZ", this.linkZ);
        compound.func_74768_a("linkDim", this.linkDim);
        compound.func_74776_a("stability", this.stability);
        compound.func_74776_a("lastStabilityIncrease", this.lastStabilityIncrease);
        compound.func_74776_a("lastStabilityDecrease", this.lastStabilityDecrease);
        return super.writeToTileNBT(compound);
    }

    public void setLink(int linkX, int linkY, int linkZ, int linkDim) {
        this.linkX = linkX;
        this.linkY = linkY;
        this.linkZ = linkZ;
        this.linkDim = linkDim;
    }

    public void setStability(float stability) {
        this.stability = stability > 100.0f ? 100.0f : (stability < -100.0f ? -100.0f : stability);
    }

    public float getStability() {
        return this.stability;
    }

    public Stability getStabilityLevel() {
        if (this.stability >= 50.0f) {
            return Stability.VERY_STABLE;
        }
        if (this.stability >= 0.0f) {
            return Stability.STABLE;
        }
        if (this.stability >= -25.0f) {
            return Stability.UNSTABLE;
        }
        return Stability.VERY_UNSTABLE;
    }

    public void spawnPortal() {
        if (!this.field_145850_b.field_72995_K) {
            double posX = (double)this.field_174879_c.func_177984_a().func_177958_n() + 0.5;
            double posY = this.field_174879_c.func_177984_a().func_177956_o();
            double posZ = (double)this.field_174879_c.func_177984_a().func_177952_p() + 0.5;
            EntityVoidPortal portal = new EntityVoidPortal(this.field_145850_b);
            portal.func_70107_b(posX, posY, posZ);
            portal.setLinkX(this.linkX);
            portal.setLinkY(this.linkY);
            portal.setLinkZ(this.linkZ);
            portal.setLinkDim(this.linkDim);
            this.field_145850_b.func_72838_d((Entity)portal);
        }
    }

    public void despawnPortal(boolean playSound) {
        EntityVoidPortal portal;
        if (!this.field_145850_b.field_72995_K && (portal = this.getActivePortal()) != null) {
            portal.func_70106_y();
            if (playSound) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.shock, SoundCategory.BLOCKS, 1.0f, (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    protected EntityVoidPortal getActivePortal() {
        AxisAlignedBB bb = new AxisAlignedBB(this.field_174879_c.func_177984_a());
        List portalList = this.field_145850_b.func_72872_a(EntityVoidPortal.class, bb);
        return portalList.size() > 0 ? (EntityVoidPortal)((Object)portalList.get(0)) : null;
    }

    protected boolean isPortalActive() {
        return this.getActivePortal() != null;
    }

    public void onLoad() {
        super.onLoad();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.lastEnabled = (Boolean)state.func_177229_b((IProperty)IBlockEnabled.ENABLED);
    }

    public void func_73660_a() {
        ++this.sparkCounter;
        ++this.ticksExisted;
        if (this.field_145850_b.field_72995_K && this.sparkCounter == 20) {
            BlockPos sourcePos = this.field_174879_c.func_177984_a();
            if (this.field_145850_b.field_73012_v.nextInt() % 2 == 0) {
                sourcePos = sourcePos.func_177968_d();
            }
            if (this.field_145850_b.field_73012_v.nextInt() % 2 == 0) {
                sourcePos = sourcePos.func_177974_f();
            }
            Color color = new Color(Aspect.FLUX.getColor());
            float r = (float)color.getRed() / 255.0f;
            float g = (float)color.getGreen() / 255.0f;
            float b = (float)color.getBlue() / 255.0f;
            FXDispatcher.INSTANCE.drawLightningFlash((double)sourcePos.func_177958_n(), (double)sourcePos.func_177956_o(), (double)sourcePos.func_177952_p(), r, g, b, 1.0f, 2.5f);
            this.sparkCounter -= 20 + this.field_145850_b.field_73012_v.nextInt(80);
        }
        if (!this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            boolean enabled = (Boolean)state.func_177229_b((IProperty)IBlockEnabled.ENABLED);
            if (enabled != this.lastEnabled) {
                if (enabled && !this.isPortalActive()) {
                    this.spawnPortal();
                } else if (!enabled && this.isPortalActive()) {
                    this.despawnPortal(true);
                }
            }
            this.lastEnabled = enabled;
            float lastStability = this.stability;
            boolean active = this.isPortalActive();
            if (this.ticksExisted % 120 == 0) {
                this.lastStabilityIncrease = 0.0f;
                this.lastStabilityDecrease = 0.0f;
                if (active) {
                    List portals;
                    for (BlockPos.MutableBlockPos mbp : BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(-8, -8, -8), (BlockPos)this.field_174879_c.func_177982_a(8, 8, 8))) {
                        TileEntity tile = this.field_145850_b.func_175625_s((BlockPos)mbp);
                        if (!(tile instanceof TileStabilizer)) continue;
                        TileStabilizer stabilizer = (TileStabilizer)tile;
                        if (this.getStabilityLevel() == Stability.VERY_STABLE || !stabilizer.mitigate(1)) continue;
                        this.lastStabilityIncrease += 0.75f;
                        this.setStability(this.stability + 0.75f);
                        stabilizer.func_70296_d();
                        stabilizer.syncTile(false);
                        if (stabilizer.getEnergy() != 0) continue;
                        break;
                    }
                    if ((portals = this.field_145850_b.func_72872_a(EntityVoidPortal.class, new AxisAlignedBB(this.field_174879_c.func_177984_a()).func_186662_g(16.0))).size() > 0) {
                        this.lastStabilityDecrease = 0.04f * (float)portals.size() * (float)portals.size();
                        this.setStability(this.stability - this.lastStabilityDecrease);
                    }
                }
            }
            if (this.stability != lastStability) {
                this.func_70296_d();
                this.syncTile(false);
            }
            if (active && this.ticksExisted % 600 == 0 && this.getStability() < 0.0f && (float)this.field_145850_b.field_73012_v.nextInt(1000) < Math.abs(this.getStability())) {
                this.executeInstabilityEvent();
            }
        }
    }

    protected void executeInstabilityEvent() {
        if (instabilityEvents.size() <= 0) {
            return;
        }
        RandomItemChooser ric = new RandomItemChooser();
        InstabilityEventEntry event = (InstabilityEventEntry)ric.chooseOnWeight(instabilityEvents);
        if (event == null) {
            return;
        }
        if (this.stability >= event.requiredInstability) {
            return;
        }
        switch (event.eventId) {
            case 0: {
                this.fluxBurst();
                break;
            }
            case 1: {
                this.spawnInvader();
                break;
            }
            case 2: {
                this.subvertPortal();
                break;
            }
            default: {
                ThaumicWonders.LOGGER.warn("Unexpected instability event ID {}", (Object)event.eventId);
            }
        }
    }

    protected void fluxBurst() {
        float amount = (float)Math.sqrt(Math.abs(this.stability));
        AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)amount, (boolean)true);
    }

    protected void spawnInvader() {
        if (spawnEvents.size() <= 0) {
            return;
        }
        RandomItemChooser ric = new RandomItemChooser();
        InstabilityEventEntry event = (InstabilityEventEntry)ric.chooseOnWeight(spawnEvents);
        if (event == null) {
            return;
        }
        if (this.stability >= event.requiredInstability) {
            return;
        }
        BlockPos portalPos = this.field_174879_c.func_177984_a();
        int count = 0;
        switch (event.eventId) {
            case 0: {
                count = 1 + (int)Math.floor(Math.abs(this.getStability()) / 20.0f);
                break;
            }
            case 1: {
                count = 1 + (int)Math.floor(Math.abs(this.getStability()) / 30.0f);
                break;
            }
            case 2: {
                count = 1 + (int)Math.floor(Math.abs(this.getStability()) / 40.0f);
                break;
            }
            case 3: {
                count = 1;
                break;
            }
            case 4: {
                count = 1;
                break;
            }
            default: {
                ThaumicWonders.LOGGER.warn("Unexpected spawn event ID {}", (Object)event.eventId);
                return;
            }
        }
        boolean spawned = false;
        for (int i = 0; i < count; ++i) {
            EntityLiving entity = this.getInvader(event.eventId);
            entity.func_70012_b((double)portalPos.func_177958_n() + this.field_145850_b.field_73012_v.nextGaussian() * 3.0, (double)portalPos.func_177956_o() + this.field_145850_b.field_73012_v.nextGaussian() * 3.0, (double)portalPos.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian() * 3.0, 0.0f, 0.0f);
            if (!entity.func_70601_bi() || !this.field_145850_b.func_72838_d((Entity)entity)) continue;
            spawned = true;
        }
        if (spawned) {
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketLocalizedMessage("event.void_portal.invader"), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 16.0));
        }
    }

    protected EntityLiving getInvader(int type) {
        switch (type) {
            case 0: {
                return new EntityWisp(this.field_145850_b);
            }
            case 1: {
                return new EntityPigZombie(this.field_145850_b);
            }
            case 2: {
                return new EntityEnderman(this.field_145850_b);
            }
            case 3: {
                return new EntityInhabitedZombie(this.field_145850_b);
            }
            case 4: {
                return new EntityEldritchGuardian(this.field_145850_b);
            }
        }
        ThaumicWonders.LOGGER.warn("No invader known for type {}", (Object)type);
        return null;
    }

    protected void subvertPortal() {
        if (subvertEvents.size() <= 0) {
            return;
        }
        RandomItemChooser ric = new RandomItemChooser();
        InstabilityEventEntry event = (InstabilityEventEntry)ric.chooseOnWeight(subvertEvents);
        if (event == null) {
            return;
        }
        if (this.stability >= event.requiredInstability) {
            return;
        }
        switch (event.eventId) {
            case 0: {
                EntityCultistPortalLesser lesserPortal = new EntityCultistPortalLesser(this.field_145850_b);
                lesserPortal.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5);
                this.despawnPortal(false);
                lesserPortal.func_180482_a(this.field_145850_b.func_175649_E(new BlockPos((Entity)lesserPortal)), null);
                this.field_145850_b.func_72838_d((Entity)lesserPortal);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketLocalizedMessage("event.void_portal.subvert.lesser_crimson"), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 16.0));
                break;
            }
            case 1: {
                EntityFluxRift rift = new EntityFluxRift(this.field_145850_b);
                rift.setRiftSeed(this.field_145850_b.field_73012_v.nextInt());
                rift.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, (float)this.field_145850_b.field_73012_v.nextInt(360), 0.0f);
                double size = Math.sqrt(2.0f * Math.abs(this.getStability()) * 3.0f);
                this.despawnPortal(false);
                if (this.field_145850_b.func_72838_d((Entity)rift)) {
                    rift.setRiftSize((int)size);
                }
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketLocalizedMessage("event.void_portal.subvert.flux_rift"), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 16.0));
                break;
            }
            default: {
                ThaumicWonders.LOGGER.warn("Unexpected subversion event ID {}", (Object)event.eventId);
                return;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getIGogglesText() {
        return new String[]{TextFormatting.BOLD + I18n.func_135052_a((String)("stability." + this.getStabilityLevel().name()), (Object[])new Object[0]), TextFormatting.GOLD + "" + TextFormatting.ITALIC + decFormatter.format(this.lastStabilityIncrease) + " " + I18n.func_135052_a((String)"stability.gain", (Object[])new Object[0]), TextFormatting.RED + "" + TextFormatting.ITALIC + decFormatter.format(this.lastStabilityDecrease) + " " + I18n.func_135052_a((String)"stability.loss", (Object[])new Object[0])};
    }

    static {
        instabilityEvents.add(new InstabilityEventEntry(0, 60, 0.0f));
        instabilityEvents.add(new InstabilityEventEntry(1, 35, 0.0f));
        instabilityEvents.add(new InstabilityEventEntry(2, 5, -50.0f));
        spawnEvents.add(new InstabilityEventEntry(0, 40, 0.0f));
        spawnEvents.add(new InstabilityEventEntry(1, 30, -20.0f));
        spawnEvents.add(new InstabilityEventEntry(2, 20, -40.0f));
        spawnEvents.add(new InstabilityEventEntry(3, 7, -60.0f));
        spawnEvents.add(new InstabilityEventEntry(4, 3, -80.0f));
        subvertEvents.add(new InstabilityEventEntry(0, 75, -50.0f));
        subvertEvents.add(new InstabilityEventEntry(1, 25, -75.0f));
    }

    protected static class InstabilityEventEntry
    implements RandomItemChooser.Item {
        public int eventId;
        public int weight;
        public float requiredInstability;

        protected InstabilityEventEntry(int eventId, int weight, float reqInstability) {
            this.eventId = eventId;
            this.weight = weight;
            this.requiredInstability = reqInstability;
        }

        public double getWeight() {
            return this.weight;
        }
    }

    public static enum Stability {
        VERY_STABLE,
        STABLE,
        UNSTABLE,
        VERY_UNSTABLE;

    }
}

