/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.tiles.devices;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.tiles.base.TileTW;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.common.blocks.IBlockFacingHorizontal;

public class TileMeteorb
extends TileTW
implements IAspectContainer,
IEssentiaTransport,
ITickable {
    private static final int CAPACITY = 50;
    public static final int MIN_FUEL = 50;
    protected int airEssentia = 0;
    protected int waterEssentia = 0;
    protected int energyEssentia = 0;
    protected int tickCounter = 0;

    @Override
    protected void readFromTileNBT(NBTTagCompound compound) {
        this.airEssentia = compound.func_74765_d("airEssentia");
        this.waterEssentia = compound.func_74765_d("waterEssentia");
        this.energyEssentia = compound.func_74765_d("energyEssentia");
    }

    @Override
    protected NBTTagCompound writeToTileNBT(NBTTagCompound compound) {
        compound.func_74777_a("airEssentia", (short)this.airEssentia);
        compound.func_74777_a("waterEssentia", (short)this.waterEssentia);
        compound.func_74777_a("energyEssentia", (short)this.energyEssentia);
        return compound;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && ++this.tickCounter % 5 == 0) {
            this.fill();
        }
    }

    protected void fill() {
        for (EnumFacing face : EnumFacing.field_176754_o) {
            IEssentiaTransport otherTile;
            TileEntity te;
            if (!this.canInputFrom(face) || this.getEssentiaAmount(face) >= 50 || (te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)face)) == null || !(te instanceof IEssentiaTransport) || !(otherTile = (IEssentiaTransport)te).canOutputTo(face.func_176734_d()) || otherTile.getEssentiaType(face.func_176734_d()) != this.getEssentiaType(face) || otherTile.getEssentiaAmount(face.func_176734_d()) <= 0 || this.getSuctionAmount(face) <= otherTile.getSuctionAmount(face.func_176734_d()) || this.getSuctionAmount(face) < otherTile.getMinimumSuction()) continue;
            int taken = otherTile.takeEssentia(this.getEssentiaType(face), 1, face.func_176734_d());
            int leftover = this.addToContainer(this.getEssentiaType(face), taken);
            if (leftover > 0) {
                ThaumicWonders.LOGGER.info("Meteorb spilling {} essentia on fill", (Object)leftover);
                AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)leftover, (boolean)true);
            }
            this.syncTile(false);
            this.func_70296_d();
        }
    }

    public EnumFacing getRelativeFacing(EnumFacing absFace) {
        if (this.func_145838_q() instanceof IBlockFacingHorizontal && absFace != EnumFacing.UP && absFace != EnumFacing.DOWN) {
            EnumFacing blockFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IBlockFacingHorizontal.FACING);
            int rotations = 0;
            EnumFacing relativeFacing = absFace;
            while (blockFacing != EnumFacing.NORTH) {
                blockFacing = blockFacing.func_176746_e();
                ++rotations;
            }
            for (int index = 0; index < rotations; ++index) {
                relativeFacing = relativeFacing.func_176746_e();
            }
            return relativeFacing;
        }
        return absFace;
    }

    public int addEssentia(Aspect aspect, int amt, EnumFacing face) {
        if (this.canInputFrom(face) && aspect == this.getEssentiaType(face)) {
            return amt - this.addToContainer(aspect, amt);
        }
        return 0;
    }

    public boolean canInputFrom(EnumFacing face) {
        EnumFacing relFace = this.getRelativeFacing(face);
        return relFace == EnumFacing.WEST || relFace == EnumFacing.EAST || relFace == EnumFacing.SOUTH;
    }

    public boolean canOutputTo(EnumFacing face) {
        return false;
    }

    public int getEssentiaAmount(EnumFacing face) {
        EnumFacing relFace = this.getRelativeFacing(face);
        if (relFace == EnumFacing.WEST) {
            return this.airEssentia;
        }
        if (relFace == EnumFacing.EAST) {
            return this.waterEssentia;
        }
        if (relFace == EnumFacing.SOUTH) {
            return this.energyEssentia;
        }
        return 0;
    }

    public Aspect getEssentiaType(EnumFacing face) {
        EnumFacing relFace = this.getRelativeFacing(face);
        if (relFace == EnumFacing.WEST) {
            return Aspect.AIR;
        }
        if (relFace == EnumFacing.EAST) {
            return Aspect.WATER;
        }
        if (relFace == EnumFacing.SOUTH) {
            return Aspect.ENERGY;
        }
        return null;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public int getSuctionAmount(EnumFacing face) {
        return this.getEssentiaAmount(face) >= 50 ? 0 : 128;
    }

    public Aspect getSuctionType(EnumFacing face) {
        return this.getEssentiaType(face);
    }

    public boolean isConnectable(EnumFacing face) {
        return this.canInputFrom(face);
    }

    public void setSuction(Aspect aspect, int amt) {
    }

    public int takeEssentia(Aspect aspect, int amt, EnumFacing face) {
        return 0;
    }

    public int addToContainer(Aspect aspect, int toAdd) {
        int retVal = 0;
        if (toAdd == 0) {
            return 0;
        }
        if (this.airEssentia < 50 && aspect == Aspect.AIR) {
            int added = Math.min(toAdd, 50 - this.airEssentia);
            this.airEssentia += added;
            retVal = toAdd - added;
        } else if (this.waterEssentia < 50 && aspect == Aspect.WATER) {
            int added = Math.min(toAdd, 50 - this.waterEssentia);
            this.waterEssentia += added;
            retVal = toAdd - added;
        } else if (this.energyEssentia < 50 && aspect == Aspect.ENERGY) {
            int added = Math.min(toAdd, 50 - this.energyEssentia);
            this.energyEssentia += added;
            retVal = toAdd - added;
        } else {
            retVal = toAdd;
        }
        this.syncTile(false);
        this.func_70296_d();
        return retVal;
    }

    public int containerContains(Aspect aspect) {
        if (aspect == Aspect.AIR) {
            return this.airEssentia;
        }
        if (aspect == Aspect.WATER) {
            return this.waterEssentia;
        }
        if (aspect == Aspect.ENERGY) {
            return this.energyEssentia;
        }
        return 0;
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return aspect == Aspect.AIR || aspect == Aspect.WATER || aspect == Aspect.ENERGY;
    }

    public boolean doesContainerContain(AspectList aspectList) {
        boolean satisfied = true;
        for (Aspect aspect : aspectList.getAspects()) {
            satisfied = satisfied && this.doesContainerContainAmount(aspect, aspectList.getAmount(aspect));
        }
        return satisfied;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int amt) {
        return aspect == Aspect.AIR && this.airEssentia >= amt || aspect == Aspect.WATER && this.waterEssentia >= amt || aspect == Aspect.ENERGY && this.energyEssentia >= amt;
    }

    public AspectList getAspects() {
        AspectList list = new AspectList();
        if (this.airEssentia > 0) {
            list.add(Aspect.AIR, this.airEssentia);
        }
        if (this.waterEssentia > 0) {
            list.add(Aspect.WATER, this.waterEssentia);
        }
        if (this.energyEssentia > 0) {
            list.add(Aspect.ENERGY, this.energyEssentia);
        }
        return list;
    }

    public void setAspects(AspectList aspects) {
        if (aspects != null && aspects.size() > 0) {
            this.airEssentia = aspects.getAmount(Aspect.AIR);
            this.waterEssentia = aspects.getAmount(Aspect.WATER);
            this.energyEssentia = aspects.getAmount(Aspect.ENERGY);
        }
    }

    public boolean takeFromContainer(AspectList aspectList) {
        if (!this.doesContainerContain(aspectList)) {
            return false;
        }
        boolean satisfied = true;
        for (Aspect aspect : aspectList.getAspects()) {
            satisfied = satisfied && this.takeFromContainer(aspect, aspectList.getAmount(aspect));
        }
        return satisfied;
    }

    public boolean takeFromContainer(Aspect aspect, int amt) {
        if (aspect == Aspect.AIR && this.airEssentia >= amt) {
            this.airEssentia -= amt;
        } else if (aspect == Aspect.WATER && this.waterEssentia >= amt) {
            this.waterEssentia -= amt;
        } else if (aspect == Aspect.ENERGY && this.energyEssentia >= amt) {
            this.energyEssentia -= amt;
        } else {
            return false;
        }
        this.syncTile(false);
        this.func_70296_d();
        return true;
    }
}

