/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.tiles.devices;

import com.verdantartifice.thaumicwonders.common.blocks.BlocksTW;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockFluxCapacitor;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockFluxDistiller;
import com.verdantartifice.thaumicwonders.common.tiles.base.TileTW;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;

public class TileFluxDistiller
extends TileTW
implements IAspectContainer,
IEssentiaTransport,
ITickable {
    protected static final int PROCESS_TIME = 20;
    protected static final int MAX_CHARGE = 10;
    protected static final int MAX_ESSENTIA = 1;
    protected int amount = 0;
    protected int tickCounter = 0;

    public int getAmount() {
        return this.amount;
    }

    @Override
    protected void readFromTileNBT(NBTTagCompound compound) {
        this.amount = compound.func_74765_d("essentia");
    }

    @Override
    protected NBTTagCompound writeToTileNBT(NBTTagCompound compound) {
        compound.func_74777_a("essentia", (short)this.amount);
        return compound;
    }

    public void func_73660_a() {
        IBlockState capacitorState;
        if (!this.field_145850_b.field_72995_K && ++this.tickCounter % 20 == 0 && (capacitorState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b())) != null && capacitorState.func_177230_c() == BlocksTW.FLUX_CAPACITOR) {
            BlockFluxCapacitor capacitorBlock = (BlockFluxCapacitor)capacitorState.func_177230_c();
            int capacitorCharge = capacitorBlock.getCharge(this.field_145850_b, this.field_174879_c.func_177977_b());
            int distillerCharge = this.getCharge();
            if (capacitorCharge > 0 && distillerCharge < 10) {
                capacitorBlock.decrementCharge(this.field_145850_b, this.field_174879_c.func_177977_b(), 1);
                this.setCharge(distillerCharge + 1);
            } else if (distillerCharge >= 10 && this.amount < 1) {
                ++this.amount;
                this.setCharge(0);
                this.syncTile(false);
                this.func_70296_d();
            }
        }
    }

    protected int getCharge() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == BlocksTW.FLUX_DISTILLER) {
            return state.func_177230_c().func_176201_c(state);
        }
        return 0;
    }

    protected void setCharge(int charge) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == BlocksTW.FLUX_DISTILLER) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockFluxDistiller.CHARGE, (Comparable)Integer.valueOf(charge)));
        }
    }

    public int addEssentia(Aspect aspect, int amt, EnumFacing face) {
        return 0;
    }

    public boolean canInputFrom(EnumFacing face) {
        return false;
    }

    public boolean canOutputTo(EnumFacing face) {
        return face == EnumFacing.UP;
    }

    public int getEssentiaAmount(EnumFacing face) {
        return this.amount;
    }

    public Aspect getEssentiaType(EnumFacing face) {
        return Aspect.FLUX;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public int getSuctionAmount(EnumFacing face) {
        return 0;
    }

    public Aspect getSuctionType(EnumFacing face) {
        return null;
    }

    public boolean isConnectable(EnumFacing face) {
        return face == EnumFacing.UP;
    }

    public void setSuction(Aspect aspect, int amt) {
    }

    public int takeEssentia(Aspect aspect, int amt, EnumFacing face) {
        return this.canOutputTo(face) && this.takeFromContainer(aspect, amt) ? amt : 0;
    }

    public int addToContainer(Aspect aspect, int toAdd) {
        if (toAdd == 0) {
            return 0;
        }
        if (this.amount >= 1 || aspect != Aspect.FLUX) {
            this.syncTile(false);
            this.func_70296_d();
            return toAdd;
        }
        int added = Math.min(toAdd, 1 - this.amount);
        this.amount += added;
        this.syncTile(false);
        this.func_70296_d();
        return toAdd - added;
    }

    public int containerContains(Aspect aspect) {
        return aspect == Aspect.FLUX ? this.amount : 0;
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return aspect == Aspect.FLUX;
    }

    public boolean doesContainerContain(AspectList aspectList) {
        boolean satisfied = true;
        for (Aspect aspect : aspectList.getAspects()) {
            satisfied = satisfied && this.doesContainerContainAmount(aspect, aspectList.getAmount(aspect));
        }
        return satisfied;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int amt) {
        return aspect == Aspect.FLUX && this.amount >= amt;
    }

    public AspectList getAspects() {
        AspectList list = new AspectList();
        if (this.amount > 0) {
            list.add(Aspect.FLUX, this.amount);
        }
        return list;
    }

    public void setAspects(AspectList aspectList) {
        if (aspectList != null && aspectList.size() > 0) {
            this.amount = aspectList.getAmount(Aspect.FLUX);
        }
    }

    public boolean takeFromContainer(AspectList aspectList) {
        if (!this.doesContainerContain(aspectList)) {
            return false;
        }
        boolean satisfied = true;
        for (Aspect aspect : aspectList.getAspects()) {
            satisfied = satisfied && this.takeFromContainer(aspect, aspectList.getAmount(aspect));
        }
        return satisfied;
    }

    public boolean takeFromContainer(Aspect aspect, int amt) {
        if (aspect == Aspect.FLUX && this.amount >= amt) {
            this.amount -= amt;
            this.syncTile(false);
            this.func_70296_d();
            return true;
        }
        return false;
    }
}

