/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.network.packets;

import com.verdantartifice.thaumicwonders.common.items.misc.ItemStructureDiviner;
import com.verdantartifice.thaumicwonders.common.network.PacketHandler;
import com.verdantartifice.thaumicwonders.common.network.packets.PacketLocalizedMessage;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketStructureDivinerAction
implements IMessage {
    private int targetType;

    public PacketStructureDivinerAction() {
        this.targetType = -1;
    }

    public PacketStructureDivinerAction(int type) {
        this.targetType = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.targetType = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.targetType);
    }

    public static class Handler
    implements IMessageHandler<PacketStructureDivinerAction, IMessage> {
        public IMessage onMessage(PacketStructureDivinerAction message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketStructureDivinerAction message, MessageContext ctx) {
            EntityPlayerMP entityPlayer = ctx.getServerHandler().field_147369_b;
            ItemStack divinerStack = this.getDivinerStack(entityPlayer);
            if (divinerStack == null) {
                return;
            }
            String targetStr = this.getTargetStr(message.targetType);
            if (targetStr == null) {
                if (divinerStack.func_77942_o()) {
                    divinerStack.func_77978_p().func_82580_o("targetPoint");
                }
            } else {
                BlockPos targetPos = entityPlayer.func_130014_f_().func_190528_a(targetStr, entityPlayer.func_180425_c(), false);
                if (targetPos == null) {
                    if (divinerStack.func_77942_o()) {
                        divinerStack.func_77978_p().func_82580_o("targetPoint");
                    }
                    PacketHandler.INSTANCE.sendTo((IMessage)new PacketLocalizedMessage("event.structure_diviner.not_found"), entityPlayer);
                } else {
                    if (!divinerStack.func_77942_o()) {
                        divinerStack.func_77982_d(new NBTTagCompound());
                    }
                    divinerStack.func_77978_p().func_74772_a("targetPoint", targetPos.func_177986_g());
                    BlockPos fudgedPos = new BlockPos(targetPos.func_177958_n(), entityPlayer.func_180425_c().func_177956_o(), targetPos.func_177952_p());
                    double distanceSq = entityPlayer.func_180425_c().func_177951_i((Vec3i)fudgedPos);
                    String key = distanceSq < 100.0 ? "event.structure_diviner.found.here" : (distanceSq < 10000.0 ? "event.structure_diviner.found.near" : (distanceSq < 1000000.0 ? "event.structure_diviner.found.far" : (distanceSq < 1.0E8 ? "event.structure_diviner.found.very_far" : "event.structure_diviner.found.extreme")));
                    PacketHandler.INSTANCE.sendTo((IMessage)new PacketLocalizedMessage(key), entityPlayer);
                }
            }
        }

        @Nullable
        private ItemStack getDivinerStack(EntityPlayerMP entityPlayer) {
            ItemStack stack = entityPlayer.func_184614_ca();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemStructureDiviner) {
                return stack;
            }
            stack = entityPlayer.func_184592_cb();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemStructureDiviner) {
                return stack;
            }
            return null;
        }

        @Nullable
        private String getTargetStr(int targetType) {
            switch (targetType) {
                case 0: {
                    return "Village";
                }
                case 1: {
                    return "Temple";
                }
                case 2: {
                    return "Mineshaft";
                }
                case 3: {
                    return "Monument";
                }
                case 4: {
                    return "Mansion";
                }
                case 5: {
                    return "Stronghold";
                }
                case 6: {
                    return "Fortress";
                }
                case 7: {
                    return "EndCity";
                }
            }
            return null;
        }
    }
}

