/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.network.packets;

import com.verdantartifice.thaumicwonders.common.network.PacketHandler;
import com.verdantartifice.thaumicwonders.common.network.packets.PacketLocalizedMessage;
import com.verdantartifice.thaumicwonders.common.network.packets.PacketMeteorbFx;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TileMeatyOrb;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;

public class PacketMeatyOrbAction
implements IMessage {
    private BlockPos tilePos;

    public PacketMeatyOrbAction() {
        this.tilePos = null;
    }

    public PacketMeatyOrbAction(BlockPos tilePos) {
        this.tilePos = tilePos;
    }

    public void fromBytes(ByteBuf buf) {
        this.tilePos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.tilePos.func_177986_g());
    }

    public static class Handler
    implements IMessageHandler<PacketMeatyOrbAction, IMessage> {
        public IMessage onMessage(PacketMeatyOrbAction message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketMeatyOrbAction message, MessageContext ctx) {
            EntityPlayerMP entityPlayer = ctx.getServerHandler().field_147369_b;
            World world = entityPlayer.func_130014_f_();
            TileEntity tileEntity = world.func_175625_s(message.tilePos);
            if (tileEntity != null && tileEntity instanceof TileMeatyOrb) {
                TileMeatyOrb tile = (TileMeatyOrb)tileEntity;
                if (tile.doesContainerContainAmount(Aspect.WATER, 250) && tile.doesContainerContainAmount(Aspect.LIFE, 250) && tile.doesContainerContainAmount(Aspect.ELDRITCH, 250)) {
                    tile.takeFromContainer(Aspect.WATER, 250);
                    tile.takeFromContainer(Aspect.LIFE, 250);
                    tile.takeFromContainer(Aspect.ELDRITCH, 250);
                    AuraHelper.polluteAura((World)world, (BlockPos)message.tilePos, (float)10.0f, (boolean)true);
                    tile.setActive(true);
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketLocalizedMessage("event.meaty_orb.used"), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)message.tilePos.func_177958_n(), (double)message.tilePos.func_177956_o(), (double)message.tilePos.func_177952_p(), 32.0));
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketMeteorbFx(message.tilePos, Aspect.ELDRITCH.getColor()), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)message.tilePos.func_177958_n(), (double)message.tilePos.func_177956_o(), (double)message.tilePos.func_177952_p(), 32.0));
                } else {
                    PacketHandler.INSTANCE.sendTo((IMessage)new PacketLocalizedMessage("event.meaty_orb.unfueled"), entityPlayer);
                }
            }
        }
    }
}

