/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.items.entities;

import com.verdantartifice.thaumicwonders.common.entities.EntityFlyingCarpet;
import com.verdantartifice.thaumicwonders.common.items.base.ItemTW;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.RechargeHelper;

public class ItemFlyingCarpet
extends ItemTW
implements IRechargable {
    public static final int CAPACITY = 240;

    public ItemFlyingCarpet() {
        super("flying_carpet");
        this.func_185043_a(new ResourceLocation("thaumicwonders", "color"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                EnumDyeColor color = null;
                if (stack != null && stack.func_77973_b() instanceof ItemFlyingCarpet) {
                    color = ((ItemFlyingCarpet)stack.func_77973_b()).getDyeColor(stack);
                }
                if (color == null) {
                    color = EnumDyeColor.RED;
                }
                return (float)color.func_176765_a() / 16.0f;
            }
        });
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IBlockState state = world.func_180495_p(pos);
        if (!world.field_72995_K && state.func_177230_c() == Blocks.field_150383_bp) {
            int level = (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
            if (level > 0) {
                this.removeDyeColor(player.func_184586_b(hand));
                Blocks.field_150383_bp.func_176590_a(world, pos, state, level - 1);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        if (!world.field_72995_K && state.func_177230_c() != BlocksTC.rechargePedestal) {
            if (side != EnumFacing.UP) {
                return EnumActionResult.PASS;
            }
            double posX = (double)pos.func_177958_n() + (double)hitX;
            double posY = (double)pos.func_177956_o() + (double)hitY;
            double posZ = (double)pos.func_177952_p() + (double)hitZ;
            EntityFlyingCarpet entityCarpet = new EntityFlyingCarpet(world, posX, posY, posZ);
            if (player.func_184586_b(hand).func_77942_o()) {
                entityCarpet.setVisCharge(RechargeHelper.getCharge((ItemStack)player.func_184586_b(hand)));
                entityCarpet.setEnergy(player.func_184586_b(hand).func_77978_p().func_74762_e("energy"));
                entityCarpet.setDyeColor(this.getDyeColor(player.func_184586_b(hand)));
            }
            entityCarpet.field_70177_z = player.field_70177_z;
            world.func_72838_d((Entity)entityCarpet);
            world.func_184148_a(null, posX, posY, posZ, SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 1.0f, 1.0f);
            player.func_184586_b(hand).func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public int getMaxCharge(ItemStack stack, EntityLivingBase player) {
        return 240;
    }

    public IRechargable.EnumChargeDisplay showInHud(ItemStack stack, EntityLivingBase player) {
        return IRechargable.EnumChargeDisplay.NORMAL;
    }

    public EnumDyeColor getDyeColor(ItemStack stack) {
        NBTTagCompound innerCompound;
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && (innerCompound = compound.func_74775_l("display")) != null && innerCompound.func_74764_b("color")) {
            return EnumDyeColor.func_176764_b((int)innerCompound.func_74762_e("color"));
        }
        return null;
    }

    public void setDyeColor(ItemStack stack, EnumDyeColor color) {
        NBTTagCompound compound;
        if (color == null) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(compound = stack.func_77978_p()).func_74764_b("display")) {
            compound.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        compound.func_74775_l("display").func_74768_a("color", color.func_176765_a());
    }

    public void removeDyeColor(ItemStack stack) {
        NBTTagCompound innerCompound;
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && (innerCompound = compound.func_74775_l("display")) != null && innerCompound.func_74764_b("color")) {
            innerCompound.func_82580_o("color");
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }
}

