/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.items.consumables;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.items.base.IVariantItem;
import java.util.ArrayList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import thaumcraft.common.lib.potions.PotionWarpWard;

public class ItemPanacea
extends ItemFood
implements IVariantItem {
    protected final String baseName;
    protected String[] variants;
    protected int[] variantsMeta;

    public ItemPanacea() {
        super(6, 1.8f, false);
        this.baseName = "panacea";
        this.setRegistryName("thaumicwonders", this.baseName);
        this.func_77655_b("thaumicwonders." + this.getRegistryName().func_110623_a());
        this.func_77637_a(ThaumicWonders.CREATIVE_TAB);
        this.func_77848_i();
        this.variants = new String[]{"normal", "enchanted"};
        this.func_77627_a(true);
        this.variantsMeta = new int[this.variants.length];
        for (int index = 0; index < this.variants.length; ++index) {
            this.variantsMeta[index] = index;
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (this.func_77614_k() && stack.func_77960_j() < this.variants.length && this.variants[stack.func_77960_j()] != this.baseName) {
            return String.format(super.func_77658_a() + ".%s", this.variants[stack.func_77960_j()]);
        }
        return super.func_77667_c(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || stack.func_77960_j() > 0;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return stack.func_77960_j() == 0 ? EnumRarity.RARE : EnumRarity.EPIC;
    }

    protected void func_77849_c(ItemStack stack, World worldIn, EntityPlayer player) {
        if (!worldIn.field_72995_K) {
            ArrayList<Potion> activeBadPotions = new ArrayList<Potion>();
            for (PotionEffect effect : player.func_70651_bq()) {
                if (!effect.func_188419_a().func_76398_f()) continue;
                activeBadPotions.add(effect.func_188419_a());
            }
            for (Potion potion : activeBadPotions) {
                player.func_184589_d(potion);
            }
            if (stack.func_77960_j() > 0) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 400, 1));
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 6000, 0));
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 6000, 0));
                player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 2400, 3));
                player.func_70690_d(new PotionEffect(PotionWarpWard.instance, 18000, 0, true, true));
            } else {
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, 1));
                player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 2400, 0));
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == ThaumicWonders.CREATIVE_TAB || tab == CreativeTabs.field_78027_g) {
            if (!this.func_77614_k()) {
                super.func_150895_a(tab, items);
            } else {
                for (int meta : this.variantsMeta) {
                    items.add((Object)new ItemStack((Item)this, 1, meta));
                }
            }
        }
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public String[] getVariantNames() {
        return this.variants;
    }

    @Override
    public int[] getVariantMeta() {
        return this.variantsMeta;
    }

    @Override
    public ModelResourceLocation getCustomModelResourceLocation(String variant) {
        if (this.baseName.equals(variant)) {
            return new ModelResourceLocation("thaumicwonders:" + this.baseName);
        }
        return new ModelResourceLocation("thaumicwonders:" + this.baseName, variant);
    }
}

