/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.items.armor;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.render.IRenderBauble;
import com.verdantartifice.thaumicwonders.ThaumicWonders;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftMaterials;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.items.RechargeHelper;
import thaumcraft.client.lib.UtilsFX;

public class ItemNightVisionGoggles
extends ItemArmor
implements IBauble,
IRenderBauble,
IRechargable {
    protected static final ResourceLocation BAUBLE_TEXTURE = new ResourceLocation("thaumicwonders", "textures/items/night_vision_goggles_bauble.png");
    protected static final int VIS_CAPACITY = 100;
    protected static final int ENERGY_PER_VIS = 360;

    public ItemNightVisionGoggles() {
        super(ThaumcraftMaterials.ARMORMAT_SPECIAL, 4, EntityEquipmentSlot.HEAD);
        this.setRegistryName("thaumicwonders", "night_vision_goggles");
        this.func_77655_b("thaumicwonders." + this.getRegistryName().func_110623_a());
        this.func_77637_a(ThaumicWonders.CREATIVE_TAB);
        this.func_77656_e(350);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "thaumicwonders:textures/entities/armor/night_vision_goggles.png";
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77969_a(new ItemStack(ItemsTC.ingots, 1, 2)) ? true : super.func_82789_a(toRepair, repair);
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType type, float partialTicks) {
        if (type == IRenderBauble.RenderType.HEAD) {
            boolean wearingHelm = player.func_184582_a(EntityEquipmentSlot.HEAD) != null;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(BAUBLE_TEXTURE);
            IRenderBauble.Helper.translateToHeadLevel((EntityPlayer)player);
            IRenderBauble.Helper.translateToFace();
            IRenderBauble.Helper.defaultTransforms();
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)(wearingHelm ? 0.12 : 0.0));
            UtilsFX.renderTextureIn3D((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)16, (int)26, (float)0.1f);
        }
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.HEAD;
    }

    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.doTick(stack, player);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        this.doTick(itemStack, (EntityLivingBase)player);
    }

    protected void doTick(ItemStack stack, EntityLivingBase player) {
        this.consumeEnergy(stack, player);
        if (this.hasEnergy(stack)) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300, 0, true, false));
        }
    }

    protected void consumeEnergy(ItemStack stack, EntityLivingBase player) {
        int energy = this.getEnergy(stack);
        if (energy > 0) {
            --energy;
        } else if (RechargeHelper.consumeCharge((ItemStack)stack, (EntityLivingBase)player, (int)1)) {
            energy = 360;
        }
        this.setEnergy(stack, energy);
    }

    protected int getEnergy(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("energy");
        }
        return 0;
    }

    protected void setEnergy(ItemStack stack, int energy) {
        stack.func_77983_a("energy", (NBTBase)new NBTTagInt(energy));
    }

    protected boolean hasEnergy(ItemStack stack) {
        return this.getEnergy(stack) > 0 || RechargeHelper.getCharge((ItemStack)stack) > 0;
    }

    public int getMaxCharge(ItemStack stack, EntityLivingBase player) {
        return 100;
    }

    public IRechargable.EnumChargeDisplay showInHud(ItemStack stack, EntityLivingBase player) {
        return IRechargable.EnumChargeDisplay.NORMAL;
    }
}

