/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.init;

import com.verdantartifice.thaumicwonders.common.blocks.BlocksTW;
import com.verdantartifice.thaumicwonders.common.crafting.recipes.RecipeDisjunctionClothUse;
import com.verdantartifice.thaumicwonders.common.crafting.recipes.RecipeFlyingCarpetDyes;
import com.verdantartifice.thaumicwonders.common.fluids.FluidQuicksilver;
import com.verdantartifice.thaumicwonders.common.items.ItemsTW;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.IDustTrigger;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.IngredientNBTTC;
import thaumcraft.api.crafting.Part;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.blocks.basic.BlockPillar;
import thaumcraft.common.lib.crafting.DustTriggerMultiblock;
import thaumcraft.common.lib.enchantment.EnumInfusionEnchantment;

public class InitRecipes {
    private static ResourceLocation defaultGroup = new ResourceLocation("");

    public static void initRecipes(IForgeRegistry<IRecipe> forgeRegistry) {
        InitRecipes.initNormalRecipes(forgeRegistry);
        InitRecipes.initArcaneRecipes();
        InitRecipes.initCrucibleRecipes();
        InitRecipes.initInfusionRecipes();
        InitRecipes.initMultiblockRecipes();
        InitRecipes.initSmelting();
    }

    private static void initMultiblockRecipes() {
        InitRecipes.initCatalyzationChamber();
        InitRecipes.initPrimordialAccretionChamber();
        InitRecipes.initCoalescencePlatform();
    }

    private static void initCatalyzationChamber() {
        Part AS = new Part((Object)BlocksTC.stoneArcane, (Object)new ItemStack(BlocksTW.PLACEHOLDER_ARCANE_STONE));
        Part OB = new Part((Object)Blocks.field_150343_Z, (Object)new ItemStack(BlocksTW.PLACEHOLDER_OBSIDIAN));
        Part IB = new Part((Object)Blocks.field_150411_aY, (Object)"AIR");
        Part QS = new Part((Object)BlocksTW.FLUID_QUICKSILVER, (Object)BlocksTW.CATALYZATION_CHAMBER, true);
        Part[][][] catalyzationChamberBlueprint = new Part[][][]{{{AS, OB, AS}, {OB, null, OB}, {AS, OB, AS}}, {{AS, OB, AS}, {OB, QS, OB}, {AS, IB, AS}}, {{AS, OB, AS}, {OB, OB, OB}, {AS, OB, AS}}};
        IDustTrigger.registerDustTrigger((IDustTrigger)new DustTriggerMultiblock("TWOND_CATALYZATION_CHAMBER@2", (Part[][][])catalyzationChamberBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog((ResourceLocation)new ResourceLocation("thaumicwonders", "catalyzation_chamber"), (ThaumcraftApi.BluePrint)new ThaumcraftApi.BluePrint("TWOND_CATALYZATION_CHAMBER@2", (Part[][][])catalyzationChamberBlueprint, new ItemStack[]{new ItemStack(BlocksTC.stoneArcane, 12), new ItemStack(Blocks.field_150343_Z, 12), new ItemStack(Blocks.field_150411_aY), FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidQuicksilver.INSTANCE, 1000))}));
    }

    private static void initPrimordialAccretionChamber() {
        Part TH = new Part((Object)BlocksTC.metalBlockThaumium, (Object)new ItemStack(BlocksTW.PLACEHOLDER_THAUMIUM_BLOCK));
        Part VM = new Part((Object)BlocksTC.metalBlockVoid, (Object)new ItemStack(BlocksTW.PLACEHOLDER_VOID_METAL_BLOCK));
        Part AA = new Part((Object)BlocksTC.metalAlchemicalAdvanced, (Object)new ItemStack(BlocksTW.PLACEHOLDER_ADV_ALCH_CONSTRUCT));
        Part IB = new Part((Object)Blocks.field_150411_aY, (Object)"AIR");
        Part QS = new Part((Object)BlocksTW.FLUID_QUICKSILVER, (Object)BlocksTW.PRIMORDIAL_ACCRETION_CHAMBER, true);
        Part[][][] accretionChamberBlueprint = new Part[][][]{{{VM, TH, VM}, {TH, null, TH}, {VM, TH, VM}}, {{AA, TH, AA}, {AA, QS, AA}, {AA, IB, AA}}, {{VM, TH, VM}, {TH, TH, TH}, {VM, TH, VM}}};
        IDustTrigger.registerDustTrigger((IDustTrigger)new DustTriggerMultiblock("TWOND_PRIMORDIAL_ACCRETION_CHAMBER", (Part[][][])accretionChamberBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog((ResourceLocation)new ResourceLocation("thaumicwonders", "primordial_accretion_chamber"), (ThaumcraftApi.BluePrint)new ThaumcraftApi.BluePrint("TWOND_PRIMORDIAL_ACCRETION_CHAMBER", (Part[][][])accretionChamberBlueprint, new ItemStack[]{new ItemStack(BlocksTC.metalBlockThaumium, 10), new ItemStack(BlocksTC.metalBlockVoid, 8), new ItemStack(BlocksTC.metalAlchemicalAdvanced, 6), new ItemStack(Blocks.field_150411_aY), FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidQuicksilver.INSTANCE, 1000))}));
    }

    private static void initCoalescencePlatform() {
        Part VMET = new Part((Object)BlocksTC.metalBlockVoid, null);
        Part ASBR = new Part((Object)BlocksTC.stoneArcaneBrick, null);
        Part SNTP = new Part((Object)BlocksTC.stoneArcane, (Object)"AIR");
        Part SNB1 = new Part((Object)BlocksTC.stoneArcane, (Object)new ItemStack(BlocksTC.pillarArcane, 1, BlockPillar.calcMeta((EnumFacing)EnumFacing.EAST)));
        Part SNB2 = new Part((Object)BlocksTC.stoneArcane, (Object)new ItemStack(BlocksTC.pillarArcane, 1, BlockPillar.calcMeta((EnumFacing)EnumFacing.NORTH)));
        Part SNB3 = new Part((Object)BlocksTC.stoneArcane, (Object)new ItemStack(BlocksTC.pillarArcane, 1, BlockPillar.calcMeta((EnumFacing)EnumFacing.SOUTH)));
        Part SNB4 = new Part((Object)BlocksTC.stoneArcane, (Object)new ItemStack(BlocksTC.pillarArcane, 1, BlockPillar.calcMeta((EnumFacing)EnumFacing.WEST)));
        Part CMAT = new Part((Object)BlocksTW.COALESCENCE_MATRIX_PRECURSOR, (Object)new ItemStack(BlocksTW.COALESCENCE_MATRIX));
        Part[][][] coalescencePlatformBlueprint = new Part[][][]{{{null, null, SNTP, null, null, null, SNTP, null, null}, {null, null, null, null, null, null, null, null, null}, {SNTP, null, null, null, null, null, null, null, SNTP}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {SNTP, null, null, null, null, null, null, null, SNTP}, {null, null, null, null, null, null, null, null, null}, {null, null, SNTP, null, null, null, SNTP, null, null}}, {{null, null, SNB1, null, null, null, SNB2, null, null}, {null, null, null, null, null, null, null, null, null}, {SNB1, null, null, null, null, null, null, null, SNB2}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, CMAT, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {SNB3, null, null, null, null, null, null, null, SNB4}, {null, null, null, null, null, null, null, null, null}, {null, null, SNB3, null, null, null, SNB4, null, null}}, {{null, null, ASBR, ASBR, ASBR, ASBR, ASBR, null, null}, {null, ASBR, VMET, VMET, VMET, VMET, VMET, ASBR, null}, {ASBR, VMET, VMET, VMET, VMET, VMET, VMET, VMET, ASBR}, {ASBR, VMET, VMET, VMET, VMET, VMET, VMET, VMET, ASBR}, {ASBR, VMET, VMET, VMET, VMET, VMET, VMET, VMET, ASBR}, {ASBR, VMET, VMET, VMET, VMET, VMET, VMET, VMET, ASBR}, {ASBR, VMET, VMET, VMET, VMET, VMET, VMET, VMET, ASBR}, {null, ASBR, VMET, VMET, VMET, VMET, VMET, ASBR, null}, {null, null, ASBR, ASBR, ASBR, ASBR, ASBR, null, null}}};
        IDustTrigger.registerDustTrigger((IDustTrigger)new DustTriggerMultiblock("TWOND_COALESCENCE_MATRIX", (Part[][][])coalescencePlatformBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog((ResourceLocation)new ResourceLocation("thaumicwonders", "coalescence_platform"), (ThaumcraftApi.BluePrint)new ThaumcraftApi.BluePrint("TWOND_COALESCENCE_MATRIX", (Part[][][])coalescencePlatformBlueprint, new ItemStack[]{new ItemStack(BlocksTC.metalBlockVoid, 45), new ItemStack(BlocksTC.stoneArcaneBrick, 24), new ItemStack(BlocksTC.stoneArcane, 16), new ItemStack(BlocksTW.COALESCENCE_MATRIX_PRECURSOR)}));
    }

    private static void initNormalRecipes(IForgeRegistry<IRecipe> forgeRegistry) {
        forgeRegistry.register((IForgeRegistryEntry)new RecipeDisjunctionClothUse());
        forgeRegistry.register((IForgeRegistryEntry)new RecipeFlyingCarpetDyes());
        ResourceLocation qsGroup = new ResourceLocation("thaumicwonders", "quicksilver_bucket_group");
        InitRecipes.shapelessOreDictRecipe("quicksilver_bucket", qsGroup, FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidQuicksilver.INSTANCE, 1000)), new Object[]{Items.field_151133_ar, new ItemStack(ItemsTC.quicksilver), new ItemStack(ItemsTC.quicksilver), new ItemStack(ItemsTC.quicksilver), new ItemStack(ItemsTC.quicksilver), new ItemStack(ItemsTC.quicksilver), new ItemStack(ItemsTC.quicksilver), new ItemStack(ItemsTC.quicksilver), new ItemStack(ItemsTC.quicksilver)});
        InitRecipes.shapelessOreDictRecipe("quicksilver_bucket_deconstruct", qsGroup, new ItemStack(ItemsTC.quicksilver, 8), new Object[]{new IngredientNBTTC(FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)FluidQuicksilver.INSTANCE, 1000)))});
    }

    private static IRecipe shapelessOreDictRecipe(@Nonnull String name, @Nullable ResourceLocation group, @Nonnull ItemStack result, Object[] inputs) {
        ShapelessOreRecipe recipe = new ShapelessOreRecipe(group, result, inputs);
        recipe.setRegistryName(new ResourceLocation("thaumicwonders", name));
        GameData.register_impl((IForgeRegistryEntry)recipe);
        return recipe;
    }

    private static void initArcaneRecipes() {
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "dimensional_ripper"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TWOND_DIMENSIONAL_RIPPER", 250, new AspectList().add(Aspect.AIR, 3).add(Aspect.ENTROPY, 3), BlocksTW.DIMENSIONAL_RIPPER, new Object[]{"BPB", "VAV", "VMV", Character.valueOf('B'), "plateBrass", Character.valueOf('P'), Ingredient.func_193367_a((Item)ItemsTC.primordialPearl), Character.valueOf('V'), "plateVoid", Character.valueOf('A'), new ItemStack(ItemsTC.turretPlacer, 1, 2), Character.valueOf('M'), new ItemStack(ItemsTC.mechanismComplex)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "inspiration_engine"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TWOND_INSPIRATION_ENGINE", 50, new AspectList().add(Aspect.AIR, 1).add(Aspect.WATER, 1).add(Aspect.ORDER, 1), BlocksTW.INSPIRATION_ENGINE, new Object[]{"BRB", "VMV", "SZS", Character.valueOf('B'), "plateBrass", Character.valueOf('R'), new ItemStack(ItemsTC.morphicResonator), Character.valueOf('V'), new ItemStack(ItemsTC.visResonator), Character.valueOf('M'), new ItemStack(ItemsTC.mechanismSimple), Character.valueOf('S'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('Z'), new ItemStack(ItemsTC.brain)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "portal_anchor"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TWOND_VOID_PORTAL@2", 150, new AspectList().add(Aspect.AIR, 3).add(Aspect.ORDER, 3).add(Aspect.ENTROPY, 3), BlocksTW.PORTAL_ANCHOR, new Object[]{"VPV", "PRP", "VPV", Character.valueOf('V'), "plateVoid", Character.valueOf('P'), new ItemStack(Items.field_151079_bi), Character.valueOf('R'), new ItemStack(ItemsTC.morphicResonator)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "hexamite"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TWOND_HEXAMITE", 125, new AspectList().add(Aspect.FIRE, 2).add(Aspect.ENTROPY, 2), BlocksTW.HEXAMITE, new Object[]{"AVA", "VGV", "AVA", Character.valueOf('A'), new ItemStack(ItemsTC.alumentum), Character.valueOf('V'), new IngredientNBTTC(ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FLUX)), Character.valueOf('G'), new ItemStack(Items.field_151016_H)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "bone_bow"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TWOND_BONE_BOW", 50, new AspectList().add(Aspect.AIR, 2).add(Aspect.ENTROPY, 2), (Item)ItemsTW.BONE_BOW, new Object[]{" BS", "BVS", " BS", Character.valueOf('B'), new ItemStack(Items.field_151103_aS), Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('V'), new IngredientNBTTC(ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.ENTROPY))}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "primal_arrow_air"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TWOND_PRIMAL_ARROWS", 10, new AspectList(), new ItemStack(ItemsTW.PRIMAL_ARROW, 9, 0), new Object[]{"AAA", "AVA", "AAA", Character.valueOf('A'), new ItemStack(Items.field_151032_g), Character.valueOf('V'), new IngredientNBTTC(ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.AIR))}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "primal_arrow_earth"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TWOND_PRIMAL_ARROWS", 10, new AspectList(), new ItemStack(ItemsTW.PRIMAL_ARROW, 9, 1), new Object[]{"AAA", "AVA", "AAA", Character.valueOf('A'), new ItemStack(Items.field_151032_g), Character.valueOf('V'), new IngredientNBTTC(ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.EARTH))}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "primal_arrow_fire"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TWOND_PRIMAL_ARROWS", 10, new AspectList(), new ItemStack(ItemsTW.PRIMAL_ARROW, 9, 2), new Object[]{"AAA", "AVA", "AAA", Character.valueOf('A'), new ItemStack(Items.field_151032_g), Character.valueOf('V'), new IngredientNBTTC(ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FIRE))}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "primal_arrow_water"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TWOND_PRIMAL_ARROWS", 10, new AspectList(), new ItemStack(ItemsTW.PRIMAL_ARROW, 9, 3), new Object[]{"AAA", "AVA", "AAA", Character.valueOf('A'), new ItemStack(Items.field_151032_g), Character.valueOf('V'), new IngredientNBTTC(ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.WATER))}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "primal_arrow_order"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TWOND_PRIMAL_ARROWS", 10, new AspectList(), new ItemStack(ItemsTW.PRIMAL_ARROW, 9, 4), new Object[]{"AAA", "AVA", "AAA", Character.valueOf('A'), new ItemStack(Items.field_151032_g), Character.valueOf('V'), new IngredientNBTTC(ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.ORDER))}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "primal_arrow_entropy"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TWOND_PRIMAL_ARROWS", 10, new AspectList(), new ItemStack(ItemsTW.PRIMAL_ARROW, 9, 5), new Object[]{"AAA", "AVA", "AAA", Character.valueOf('A'), new ItemStack(Items.field_151032_g), Character.valueOf('V'), new IngredientNBTTC(ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.ENTROPY))}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "flux_distiller"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TWOND_FLUX_DISTILLER", 750, new AspectList().add(Aspect.AIR, 8).add(Aspect.WATER, 8).add(Aspect.ORDER, 8), BlocksTW.FLUX_DISTILLER, new Object[]{"VLV", "MCM", "VAV", Character.valueOf('V'), "plateVoid", Character.valueOf('M'), ItemsTC.mechanismComplex, Character.valueOf('L'), BlocksTC.condenserlattice, Character.valueOf('C'), BlocksTC.condenser, Character.valueOf('A'), BlocksTC.metalAlchemicalAdvanced}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "primordial_accelerator_tunnel"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TWOND_PRIMORDIAL_ACCELERATOR", 100, new AspectList().add(Aspect.AIR, 2).add(Aspect.ORDER, 2), BlocksTW.PRIMORDIAL_ACCELERATOR_TUNNEL, new Object[]{"VEV", "ETE", "VEV", Character.valueOf('V'), "plateVoid", Character.valueOf('E'), new ItemStack(ItemsTC.nuggets, 1, 10), Character.valueOf('T'), BlocksTC.tube}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "primordial_accelerator_terminus"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TWOND_PRIMORDIAL_ACCELERATOR", 250, new AspectList().add(Aspect.EARTH, 5).add(Aspect.ORDER, 5), BlocksTW.PRIMORDIAL_ACCELERATOR_TERMINUS, new Object[]{" V ", "VCV", " V ", Character.valueOf('V'), "plateVoid", Character.valueOf('C'), new ItemStack(Blocks.field_192443_dR, 1, Short.MAX_VALUE)}));
    }

    private static void initCrucibleRecipes() {
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "hedge_soul_sand"), (CrucibleRecipe)new CrucibleRecipe("TWOND_NETHER_HEDGE", new ItemStack(Blocks.field_150425_aM), (Object)new ItemStack((Block)Blocks.field_150354_m), new AspectList().add(Aspect.SOUL, 3).add(Aspect.EARTH, 3).add(Aspect.TRAP, 1)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "hedge_ghast_tear"), (CrucibleRecipe)new CrucibleRecipe("TWOND_NETHER_HEDGE", new ItemStack(Items.field_151073_bk, 2), (Object)new ItemStack(Items.field_151073_bk), new AspectList().add(Aspect.SOUL, 10).add(Aspect.ALCHEMY, 10).add(Aspect.UNDEAD, 5)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "hedge_wither_skull"), (CrucibleRecipe)new CrucibleRecipe("TWOND_NETHER_HEDGE", new ItemStack(Items.field_151144_bL, 1, 1), (Object)new ItemStack(Items.field_151144_bL, 1, 0), new AspectList().add(Aspect.UNDEAD, 10).add(Aspect.DEATH, 10).add(Aspect.SOUL, 10).add(Aspect.DARKNESS, 5)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "hedge_end_stone"), (CrucibleRecipe)new CrucibleRecipe("TWOND_END_HEDGE", new ItemStack(Blocks.field_150377_bs), (Object)new ItemStack(Blocks.field_150348_b), new AspectList().add(Aspect.EARTH, 5).add(Aspect.DARKNESS, 5)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "hedge_chorus_fruit"), (CrucibleRecipe)new CrucibleRecipe("TWOND_END_HEDGE", new ItemStack(Items.field_185161_cS), (Object)new ItemStack(Items.field_151034_e), new AspectList().add(Aspect.ELDRITCH, 5).add(Aspect.SENSES, 5).add(Aspect.PLANT, 5)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "hedge_ender_pearl"), (CrucibleRecipe)new CrucibleRecipe("TWOND_END_HEDGE", new ItemStack(Items.field_151079_bi, 2), (Object)new ItemStack(Items.field_151079_bi), new AspectList().add(Aspect.MOTION, 15).add(Aspect.ELDRITCH, 10)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "disjunction_cloth"), (CrucibleRecipe)new CrucibleRecipe("TWOND_DISJUNCTION_CLOTH", new ItemStack(ItemsTW.DISJUNCTION_CLOTH), (Object)new ItemStack(ItemsTC.fabric), new AspectList().add(Aspect.MAGIC, 40).add(Aspect.VOID, 40).add(Aspect.AURA, 20)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "alchemist_stone"), (CrucibleRecipe)new CrucibleRecipe("TWOND_CATALYZATION_CHAMBER", new ItemStack(ItemsTW.ALCHEMIST_STONE), (Object)new ItemStack(Items.field_151045_i), new AspectList().add(Aspect.METAL, 50).add(Aspect.ORDER, 50).add(Aspect.ALCHEMY, 10)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "transmuter_stone"), (CrucibleRecipe)new CrucibleRecipe("TWOND_TRANSMUTER_STONE", new ItemStack(ItemsTW.TRANSMUTER_STONE), (Object)new ItemStack(ItemsTW.ALCHEMIST_STONE), new AspectList().add(Aspect.EXCHANGE, 50).add(Aspect.ALCHEMY, 10)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "primordial_pearl_reconstitution"), (CrucibleRecipe)new CrucibleRecipe("TWOND_PRIMORDIAL_ACCELERATOR&&!TWOND_PRIMORDIAL_GRAIN", new ItemStack(ItemsTC.primordialPearl, 1, 7), (Object)new ItemStack(ItemsTW.PRIMORDIAL_GRAIN), new AspectList().add(Aspect.AIR, 250).add(Aspect.EARTH, 250).add(Aspect.FIRE, 250).add(Aspect.WATER, 250).add(Aspect.ORDER, 250).add(Aspect.ENTROPY, 250)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "panacea"), (CrucibleRecipe)new CrucibleRecipe("TWOND_PANACEA", new ItemStack(ItemsTW.PANACEA), (Object)new ItemStack(Items.field_151153_ao), new AspectList().add(Aspect.LIFE, 20).add(Aspect.ORDER, 20).add(Aspect.VOID, 20)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "enchanted_panacea"), (CrucibleRecipe)new CrucibleRecipe("TWOND_PANACEA", new ItemStack(ItemsTW.PANACEA, 1, 1), (Object)new ItemStack(Items.field_151153_ao, 1, 1), new AspectList().add(Aspect.LIFE, 40).add(Aspect.ORDER, 40).add(Aspect.VOID, 40).add(Aspect.MIND, 40).add(Aspect.PROTECT, 40)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "alkahest_vat"), (CrucibleRecipe)new CrucibleRecipe("TWOND_ALKAHEST", new ItemStack(BlocksTW.ALKAHEST_VAT), (Object)new ItemStack(BlocksTC.crucible), new AspectList().add(Aspect.ALCHEMY, 25).add(Aspect.WATER, 25).add(Aspect.ENTROPY, 100).add(Aspect.PROTECT, 25)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "lethe_water"), (CrucibleRecipe)new CrucibleRecipe("TWOND_LETHE_WATER", new ItemStack(ItemsTW.LETHE_WATER), (Object)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b), new AspectList().add(Aspect.MAGIC, 20).add(Aspect.MIND, 20).add(Aspect.VOID, 20)));
    }

    private static void initInfusionRecipes() {
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "everburning_urn"), (InfusionRecipe)new InfusionRecipe("TWOND_EVERBURNING_URN", (Object)new ItemStack(BlocksTW.EVERBURNING_URN), 4, new AspectList().add(Aspect.FIRE, 40).add(Aspect.EARTH, 20).add(Aspect.ENERGY, 10).add(Aspect.CRAFT, 10), (Object)new ItemStack(BlocksTC.everfullUrn), new Object[]{new ItemStack(Items.field_151130_bT), new ItemStack(Items.field_151130_bT), new ItemStack(Items.field_151130_bT), new ItemStack(Items.field_151129_at), ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FIRE), new ItemStack(Blocks.field_150343_Z)}));
        ItemStack destroyer = new ItemStack((Item)ItemsTW.PRIMAL_DESTROYER);
        EnumInfusionEnchantment.addInfusionEnchantment((ItemStack)destroyer, (EnumInfusionEnchantment)EnumInfusionEnchantment.ESSENCE, (int)3);
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "primal_destroyer"), (InfusionRecipe)new InfusionRecipe("TWOND_PRIMAL_DESTROYER", (Object)destroyer, 8, new AspectList().add(Aspect.FIRE, 100).add(Aspect.ENTROPY, 50).add(Aspect.VOID, 50).add(Aspect.AVERSION, 100).add(Aspect.ELDRITCH, 75).add(Aspect.DARKNESS, 75).add(Aspect.DEATH, 100), (Object)Ingredient.func_193367_a((Item)ItemsTC.voidSword), new Object[]{Ingredient.func_193367_a((Item)ItemsTC.primordialPearl), new ItemStack(Items.field_151156_bN), "plateVoid", "plateVoid", ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FIRE), ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FIRE)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "flying_carpet"), (InfusionRecipe)new InfusionRecipe("TWOND_FLYING_CARPET", (Object)new ItemStack(ItemsTW.FLYING_CARPET), 6, new AspectList().add(Aspect.FLIGHT, 150).add(Aspect.MOTION, 100).add(Aspect.AIR, 100).add(Aspect.MAGIC, 50).add(Aspect.ENERGY, 50), (Object)new ItemStack(Blocks.field_150404_cg, 1, Short.MAX_VALUE), new Object[]{new ItemStack(BlocksTC.levitator), new ItemStack(Items.field_151141_av), new ItemStack(ItemsTC.visResonator), ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.AIR), ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.AIR)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "timewinder"), (InfusionRecipe)new InfusionRecipe("TWOND_TIMEWINDER", (Object)new ItemStack(ItemsTW.TIMEWINDER), 7, new AspectList().add(Aspect.ELDRITCH, 100).add(Aspect.DARKNESS, 100).add(Aspect.LIGHT, 100), (Object)new ItemStack(Items.field_151113_aN), new Object[]{new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151079_bi), new ItemStack(ItemsTC.quicksilver), new ItemStack(ItemsTC.celestialNotes, 1, 5), new ItemStack(ItemsTC.celestialNotes, 1, 6), new ItemStack(ItemsTC.celestialNotes, 1, 7), new ItemStack(ItemsTC.celestialNotes, 1, 8), new ItemStack(ItemsTC.celestialNotes, 1, 9), new ItemStack(ItemsTC.celestialNotes, 1, 10), new ItemStack(ItemsTC.celestialNotes, 1, 11), new ItemStack(ItemsTC.celestialNotes, 1, 12), new ItemStack(ItemsTC.celestialNotes, 1, 0)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "madness_engine"), (InfusionRecipe)new InfusionRecipe("TWOND_MADNESS_ENGINE", (Object)new ItemStack(BlocksTW.MADNESS_ENGINE), 6, new AspectList().add(Aspect.ELDRITCH, 150).add(Aspect.MIND, 100).add(Aspect.MECHANISM, 100).add(Aspect.AURA, 50), (Object)new ItemStack(BlocksTW.INSPIRATION_ENGINE), new Object[]{"plateVoid", "plateVoid", "plateThaumium", "plateThaumium", new ItemStack(ItemsTC.mind, 1, 1), new ItemStack(Items.field_151079_bi)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "portal_generator"), (InfusionRecipe)new InfusionRecipe("TWOND_VOID_PORTAL", (Object)new ItemStack(BlocksTW.PORTAL_GENERATOR), 8, new AspectList().add(Aspect.ELDRITCH, 150).add(Aspect.MOTION, 150).add(Aspect.EXCHANGE, 100), (Object)new ItemStack(BlocksTW.PORTAL_ANCHOR), new Object[]{Ingredient.func_193367_a((Item)ItemsTC.primordialPearl), new ItemStack(BlocksTC.mirror), new ItemStack(Items.field_151079_bi)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "flux_capacitor"), (InfusionRecipe)new InfusionRecipe("TWOND_FLUX_CAPACITOR", (Object)new ItemStack(BlocksTW.FLUX_CAPACITOR), 6, new AspectList().add(Aspect.FLUX, 50).add(Aspect.AURA, 50).add(Aspect.VOID, 50), (Object)new ItemStack(BlocksTC.visBattery), new Object[]{Ingredient.func_193367_a((Item)ItemsTC.primordialPearl), new ItemStack(BlocksTC.crystalTaint), new ItemStack(ItemsTC.visResonator), new ItemStack(BlocksTC.condenserlattice)}));
        ArrayList<Object> ingredients = new ArrayList<Object>();
        ingredients.add(Ingredient.func_193367_a((Item)ItemsTC.primordialPearl));
        ingredients.add(new ItemStack(ItemsTC.clusters, 1, 0));
        ingredients.add(new ItemStack(ItemsTC.clusters, 1, 1));
        if (OreDictionary.doesOreNameExist((String)"oreCopper") && !OreDictionary.getOres((String)"oreCopper", (boolean)false).isEmpty()) {
            ingredients.add(new ItemStack(ItemsTC.clusters, 1, 2));
        }
        if (OreDictionary.doesOreNameExist((String)"oreTin") && !OreDictionary.getOres((String)"oreTin", (boolean)false).isEmpty()) {
            ingredients.add(new ItemStack(ItemsTC.clusters, 1, 3));
        }
        if (OreDictionary.doesOreNameExist((String)"oreSilver") && !OreDictionary.getOres((String)"oreSilver", (boolean)false).isEmpty()) {
            ingredients.add(new ItemStack(ItemsTC.clusters, 1, 4));
        }
        if (OreDictionary.doesOreNameExist((String)"oreLead") && !OreDictionary.getOres((String)"oreLead", (boolean)false).isEmpty()) {
            ingredients.add(new ItemStack(ItemsTC.clusters, 1, 5));
        }
        ingredients.add(new ItemStack(ItemsTC.clusters, 1, 6));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "alienist_stone"), (InfusionRecipe)new InfusionRecipe("TWOND_ALIENIST_STONE", (Object)new ItemStack(ItemsTW.ALIENIST_STONE), 7, new AspectList().add(Aspect.METAL, 100).add(Aspect.FLUX, 100).add(Aspect.ALCHEMY, 25), (Object)new ItemStack(ItemsTW.ALCHEMIST_STONE), ingredients.toArray()));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "meteorb"), (InfusionRecipe)new InfusionRecipe("TWOND_METEORB", (Object)new ItemStack(BlocksTW.METEORB), 6, new AspectList().add(Aspect.AIR, 100).add(Aspect.WATER, 100).add(Aspect.ENERGY, 100).add(Aspect.ELDRITCH, 50), (Object)new ItemStack(Items.field_151079_bi), new Object[]{new ItemStack(BlocksTC.stoneArcane), new ItemStack((Block)BlocksTC.slabArcaneStone), new ItemStack(BlocksTC.tube), new ItemStack(BlocksTC.stoneArcane), new ItemStack((Block)BlocksTC.slabArcaneStone), new ItemStack(BlocksTC.tube), new ItemStack(BlocksTC.stoneArcane), new ItemStack((Block)BlocksTC.slabArcaneStone), new ItemStack(BlocksTC.tube), new ItemStack(BlocksTC.stoneArcane), new ItemStack((Block)BlocksTC.slabArcaneStone), new ItemStack(Blocks.field_150430_aB)}));
        ArrayList<String> divinerIngredients = new ArrayList<String>();
        divinerIngredients.add("oreIron");
        divinerIngredients.add("oreGold");
        if (OreDictionary.doesOreNameExist((String)"oreCopper") && !OreDictionary.getOres((String)"oreCopper", (boolean)false).isEmpty()) {
            ingredients.add("oreCopper");
        }
        if (OreDictionary.doesOreNameExist((String)"oreTin") && !OreDictionary.getOres((String)"oreTin", (boolean)false).isEmpty()) {
            ingredients.add("oreTin");
        }
        if (OreDictionary.doesOreNameExist((String)"oreSilver") && !OreDictionary.getOres((String)"oreSilver", (boolean)false).isEmpty()) {
            ingredients.add("oreSilver");
        }
        if (OreDictionary.doesOreNameExist((String)"oreLead") && !OreDictionary.getOres((String)"oreLead", (boolean)false).isEmpty()) {
            ingredients.add("oreLead");
        }
        divinerIngredients.add("oreCoal");
        divinerIngredients.add("oreRedstone");
        divinerIngredients.add("oreLapis");
        divinerIngredients.add("oreDiamond");
        divinerIngredients.add("oreEmerald");
        divinerIngredients.add("oreCinnabar");
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "ore_diviner"), (InfusionRecipe)new InfusionRecipe("TWOND_ORE_DIVINER", (Object)new ItemStack(BlocksTW.ORE_DIVINER), 6, new AspectList().add(Aspect.SENSES, 100).add(Aspect.EARTH, 50).add(Aspect.METAL, 50).add(Aspect.MAGIC, 50), (Object)new ItemStack(Blocks.field_150371_ca), divinerIngredients.toArray()));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "void_fortress_helm"), (InfusionRecipe)new InfusionRecipe("TWOND_VOID_FORTRESS_ARMOR", (Object)new ItemStack((Item)ItemsTW.VOID_FORTRESS_HELM), 8, new AspectList().add(Aspect.PROTECT, 45).add(Aspect.METAL, 45).add(Aspect.ELDRITCH, 50).add(Aspect.ENERGY, 25).add(Aspect.VOID, 25).add(Aspect.MAGIC, 25).add(Aspect.SENSES, 25).add(Aspect.UNDEAD, 40).add(Aspect.LIFE, 40), (Object)new ItemStack(ItemsTC.voidHelm), new Object[]{Ingredient.func_193367_a((Item)ItemsTC.primordialPearl), "plateVoid", "plateVoid", new ItemStack(ItemsTC.goggles, 1, Short.MAX_VALUE), new ItemStack(Items.field_151073_bk), new ItemStack(ItemsTC.salisMundus), "leather"}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "void_fortress_chest"), (InfusionRecipe)new InfusionRecipe("TWOND_VOID_FORTRESS_ARMOR", (Object)new ItemStack((Item)ItemsTW.VOID_FORTRESS_CHEST), 8, new AspectList().add(Aspect.PROTECT, 55).add(Aspect.METAL, 55).add(Aspect.ELDRITCH, 50).add(Aspect.ENERGY, 25).add(Aspect.VOID, 35).add(Aspect.MAGIC, 25), (Object)new ItemStack(ItemsTC.voidChest), new Object[]{Ingredient.func_193367_a((Item)ItemsTC.primordialPearl), "plateVoid", "plateVoid", "plateVoid", "plateVoid", new ItemStack(ItemsTC.salisMundus), "leather"}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "void_fortress_legs"), (InfusionRecipe)new InfusionRecipe("TWOND_VOID_FORTRESS_ARMOR", (Object)new ItemStack((Item)ItemsTW.VOID_FORTRESS_LEGS), 8, new AspectList().add(Aspect.PROTECT, 50).add(Aspect.METAL, 50).add(Aspect.ELDRITCH, 50).add(Aspect.ENERGY, 25).add(Aspect.VOID, 30).add(Aspect.MAGIC, 25), (Object)new ItemStack(ItemsTC.voidLegs), new Object[]{Ingredient.func_193367_a((Item)ItemsTC.primordialPearl), "plateVoid", "plateVoid", "plateVoid", new ItemStack(ItemsTC.salisMundus), "leather"}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "meaty_orb"), (InfusionRecipe)new InfusionRecipe("TWOND_MEATY_ORB", (Object)new ItemStack(BlocksTW.MEATY_ORB), 8, new AspectList().add(Aspect.WATER, 250).add(Aspect.LIFE, 250).add(Aspect.ELDRITCH, 250), (Object)new ItemStack(BlocksTW.METEORB), new Object[]{Ingredient.func_193367_a((Item)ItemsTC.primordialPearl), new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151147_al), new ItemStack(Items.field_151076_bf), new ItemStack(Items.field_179561_bm), new ItemStack(Items.field_179558_bo)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "structure_diviner"), (InfusionRecipe)new InfusionRecipe("TWOND_STRUCTURE_DIVINER", (Object)new ItemStack(ItemsTW.STRUCTURE_DIVINER), 6, new AspectList().add(Aspect.SENSES, 100).add(Aspect.MECHANISM, 50).add(Aspect.MAGIC, 50).add(Aspect.EARTH, 50), (Object)new ItemStack(Items.field_151111_aL), new Object[]{new ItemStack(Items.field_151061_bv), new ItemStack(Items.field_151166_bC), new ItemStack(Items.field_151061_bv), new ItemStack(Blocks.field_150385_bj), new ItemStack(Items.field_151061_bv), new ItemStack(Items.field_179563_cD)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "night_vision_goggles"), (InfusionRecipe)new InfusionRecipe("TWOND_NV_GOGGLES", (Object)new ItemStack((Item)ItemsTW.NIGHT_VISION_GOGGLES), 4, new AspectList().add(Aspect.SENSES, 50).add(Aspect.LIGHT, 50).add(Aspect.MAGIC, 25).add(Aspect.ENERGY, 25), (Object)new ItemStack(ItemsTC.goggles), new Object[]{new ItemStack(Items.field_151150_bK), "nitor", ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.SENSES), ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.SENSES)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "void_beacon"), (InfusionRecipe)new InfusionRecipe("TWOND_VOID_BEACON", (Object)new ItemStack(BlocksTW.VOID_BEACON), 10, new AspectList().add(Aspect.ELDRITCH, 250).add(Aspect.VOID, 250).add(Aspect.MAGIC, 250).add(Aspect.FLUX, 200).add(Aspect.AIR, 100).add(Aspect.EARTH, 100).add(Aspect.FIRE, 100).add(Aspect.WATER, 100).add(Aspect.ORDER, 100).add(Aspect.ENTROPY, 100), (Object)new ItemStack((Block)Blocks.field_150461_bJ), new Object[]{Ingredient.func_193367_a((Item)ItemsTC.primordialPearl), "plateVoid", Ingredient.func_193367_a((Item)ItemsTC.primordialPearl), "plateVoid", Ingredient.func_193367_a((Item)ItemsTC.primordialPearl), "plateVoid", Ingredient.func_193367_a((Item)ItemsTC.primordialPearl), "plateVoid"}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "cleansing_charm"), (InfusionRecipe)new InfusionRecipe("TWOND_CLEANSING_CHARM", (Object)new ItemStack(ItemsTW.CLEANSING_CHARM), 8, new AspectList().add(Aspect.MIND, 225).add(Aspect.ORDER, 225).add(Aspect.ELDRITCH, 150).add(Aspect.LIFE, 150), (Object)new ItemStack(Items.field_151079_bi), new Object[]{Ingredient.func_193367_a((Item)ItemsTC.primordialPearl), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "primordial_accelerator"), (InfusionRecipe)new InfusionRecipe("TWOND_PRIMORDIAL_ACCELERATOR", (Object)new ItemStack(BlocksTW.PRIMORDIAL_ACCELERATOR), 10, new AspectList().add(Aspect.MOTION, 250).add(Aspect.MECHANISM, 200).add(Aspect.ENERGY, 200).add(Aspect.ELDRITCH, 100), (Object)new ItemStack(Blocks.field_150367_z), new Object[]{new ItemStack(BlocksTW.PRIMORDIAL_ACCELERATOR_TUNNEL), "plateVoid", new ItemStack(ItemsTC.mechanismComplex), "plateVoid", new ItemStack(BlocksTC.metalAlchemicalAdvanced), "plateVoid", new ItemStack(ItemsTC.mechanismComplex), "plateVoid"}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "shimmerleaf_seed"), (InfusionRecipe)new InfusionRecipe("TWOND_MYSTIC_GARDENING", (Object)new ItemStack(ItemsTW.SHIMMERLEAF_SEED, 8), 2, new AspectList().add(Aspect.PLANT, 10).add(Aspect.LIFE, 10).add(Aspect.AURA, 5), (Object)new ItemStack(Items.field_151014_N), new Object[]{new ItemStack(BlocksTC.shimmerleaf), new ItemStack(ItemsTC.salisMundus)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "cinderpearl_seed"), (InfusionRecipe)new InfusionRecipe("TWOND_MYSTIC_GARDENING", (Object)new ItemStack(ItemsTW.CINDERPEARL_SEED, 8), 2, new AspectList().add(Aspect.PLANT, 10).add(Aspect.LIFE, 10).add(Aspect.FIRE, 5), (Object)new ItemStack(Items.field_151014_N), new Object[]{new ItemStack(BlocksTC.cinderpearl), new ItemStack(ItemsTC.salisMundus)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "vishroom_spore"), (InfusionRecipe)new InfusionRecipe("TWOND_MYSTIC_GARDENING", (Object)new ItemStack(ItemsTW.VISHROOM_SPORE, 8), 2, new AspectList().add(Aspect.PLANT, 10).add(Aspect.LIFE, 10).add(Aspect.MAGIC, 5), (Object)new ItemStack(Items.field_151014_N), new Object[]{new ItemStack(BlocksTC.vishroom), new ItemStack(ItemsTC.salisMundus)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicwonders", "coalescence_matrix"), (InfusionRecipe)new InfusionRecipe("TWOND_COALESCENCE_MATRIX", (Object)new ItemStack(BlocksTW.COALESCENCE_MATRIX_PRECURSOR), 10, new AspectList().add(Aspect.FLUX, 200).add(Aspect.MAN, 100).add(Aspect.MAGIC, 200).add(Aspect.ENERGY, 100), (Object)new ItemStack(Blocks.field_150340_R), new Object[]{Ingredient.func_193367_a((Item)ItemsTC.primordialPearl), new ItemStack(BlocksTC.inlay), new ItemStack(BlocksTC.inlay), new ItemStack(Items.field_151156_bN), new ItemStack(BlocksTC.inlay), new ItemStack(BlocksTC.inlay)}));
    }

    private static void initSmelting() {
        ItemStack stack;
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 0), (ItemStack)new ItemStack(Items.field_151042_j, 3, 0), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 1), (ItemStack)new ItemStack(Items.field_151043_k, 3, 0), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 6), (ItemStack)new ItemStack(ItemsTC.quicksilver, 3, 0), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 7), (ItemStack)new ItemStack(Items.field_151128_bU, 3, 0), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 8), (ItemStack)new ItemStack(ItemsTC.ingots, 2, 1), (float)1.0f);
        ThaumcraftApi.addSmeltingBonus((Object)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 0), (ItemStack)new ItemStack(Items.field_191525_da, 1, 0));
        ThaumcraftApi.addSmeltingBonus((Object)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 1), (ItemStack)new ItemStack(Items.field_151074_bl, 1, 0));
        ThaumcraftApi.addSmeltingBonus((Object)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 6), (ItemStack)new ItemStack(ItemsTC.nuggets, 1, 5));
        ThaumcraftApi.addSmeltingBonus((Object)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 7), (ItemStack)new ItemStack(ItemsTC.nuggets, 1, 9));
        ThaumcraftApi.addSmeltingBonus((Object)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 8), (ItemStack)new ItemStack(ItemsTC.nuggets, 1, 7));
        ThaumcraftApi.addSmeltingBonus((Object)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, Short.MAX_VALUE), (ItemStack)new ItemStack(ItemsTC.nuggets, 1, 10), (float)0.025f);
        ThaumcraftApi.addSmeltingBonus((Object)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, Short.MAX_VALUE), (ItemStack)ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FLUX), (float)0.1f);
        if (OreDictionary.doesOreNameExist((String)"ingotCopper") && !OreDictionary.getOres((String)"ingotCopper", (boolean)false).isEmpty()) {
            stack = (ItemStack)OreDictionary.getOres((String)"ingotCopper", (boolean)false).get(0);
            GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 2), (ItemStack)new ItemStack(stack.func_77973_b(), 3, stack.func_77952_i()), (float)1.0f);
            ThaumcraftApi.addSmeltingBonus((Object)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 2), (ItemStack)new ItemStack(ItemsTC.nuggets, 1, 1));
        }
        if (OreDictionary.doesOreNameExist((String)"ingotTin") && !OreDictionary.getOres((String)"ingotTin", (boolean)false).isEmpty()) {
            stack = (ItemStack)OreDictionary.getOres((String)"ingotTin", (boolean)false).get(0);
            GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 3), (ItemStack)new ItemStack(stack.func_77973_b(), 3, stack.func_77952_i()), (float)1.0f);
            ThaumcraftApi.addSmeltingBonus((Object)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 3), (ItemStack)new ItemStack(ItemsTC.nuggets, 1, 2));
        }
        if (OreDictionary.doesOreNameExist((String)"ingotSilver") && !OreDictionary.getOres((String)"ingotSilver", (boolean)false).isEmpty()) {
            stack = (ItemStack)OreDictionary.getOres((String)"ingotSilver", (boolean)false).get(0);
            GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 4), (ItemStack)new ItemStack(stack.func_77973_b(), 3, stack.func_77952_i()), (float)1.0f);
            ThaumcraftApi.addSmeltingBonus((Object)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 4), (ItemStack)new ItemStack(ItemsTC.nuggets, 1, 3));
        }
        if (OreDictionary.doesOreNameExist((String)"ingotLead") && !OreDictionary.getOres((String)"ingotLead", (boolean)false).isEmpty()) {
            stack = (ItemStack)OreDictionary.getOres((String)"ingotLead", (boolean)false).get(0);
            GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 5), (ItemStack)new ItemStack(stack.func_77973_b(), 3, stack.func_77952_i()), (float)1.0f);
            ThaumcraftApi.addSmeltingBonus((Object)new ItemStack(ItemsTW.ELDRITCH_CLUSTER, 1, 5), (ItemStack)new ItemStack(ItemsTC.nuggets, 1, 4));
        }
    }
}

