/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.blocks.misc;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.blocks.BlocksTW;
import com.verdantartifice.thaumicwonders.common.blocks.base.BlockTW;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockCatalyzationChamber;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.blocks.BlocksTC;

public class BlockTWPlaceholder
extends BlockTW {
    public BlockTWPlaceholder(String name) {
        super(Material.field_151576_e, name);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(null);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177230_c() == BlocksTW.PLACEHOLDER_ARCANE_STONE) {
            return Item.func_150898_a((Block)BlocksTC.stoneArcane);
        }
        if (state.func_177230_c() == BlocksTW.PLACEHOLDER_OBSIDIAN) {
            return Item.func_150898_a((Block)Blocks.field_150343_Z);
        }
        return Item.func_150899_d((int)0);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (state.func_177230_c() == BlocksTW.PLACEHOLDER_ARCANE_STONE || state.func_177230_c() == BlocksTW.PLACEHOLDER_OBSIDIAN) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        BlockPos targetPos = pos.func_177982_a(i, j, k);
                        IBlockState targetState = worldIn.func_180495_p(targetPos);
                        if (targetState.func_177230_c() != BlocksTW.CATALYZATION_CHAMBER) continue;
                        playerIn.openGui((Object)ThaumicWonders.INSTANCE, 2, worldIn, targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
                        return true;
                    }
                }
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!(state.func_177230_c() != BlocksTW.PLACEHOLDER_ARCANE_STONE && state.func_177230_c() != BlocksTW.PLACEHOLDER_OBSIDIAN || BlockCatalyzationChamber.ignoreDestroy || worldIn.field_72995_K)) {
            this.destroyCatalyzer(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    private void destroyCatalyzer(World worldIn, BlockPos pos) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos targetPos = pos.func_177982_a(i, j, k);
                    IBlockState targetState = worldIn.func_180495_p(targetPos);
                    if (targetState.func_177230_c() != BlocksTW.CATALYZATION_CHAMBER) continue;
                    BlockCatalyzationChamber.destroyChamber(worldIn, targetPos, targetState, pos);
                    return;
                }
            }
        }
    }
}

