/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.helper;

import de.eydamos.backpack.Backpack;
import de.eydamos.backpack.data.BackpackSave;
import de.eydamos.backpack.data.PlayerSave;
import de.eydamos.backpack.init.BackpackItems;
import de.eydamos.backpack.item.ESize;
import de.eydamos.backpack.tier.TierFrame;
import de.eydamos.backpack.tier.TierLeather;
import de.eydamos.backpack.util.GeneralUtil;
import de.eydamos.backpack.util.NBTItemStackUtil;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class BackpackHelper {
    public static void initialize(ItemStack backpack, ItemStack leather, ItemStack frame) {
        TierLeather tierLeather = TierLeather.getTierByItemStack(leather);
        TierFrame tierFrame = TierFrame.getTierByItemStack(frame);
        BackpackHelper.initialize(backpack, tierLeather, tierFrame);
    }

    public static void initialize(ItemStack backpack, TierLeather leather, TierFrame frame) {
        if (!BackpackHelper.isBackpack(backpack)) {
            Backpack.logger.error("ItemStack is null or not a backpack.");
            return;
        }
        ESize size = ESize.getSizeByBackpack(backpack);
        if (size == null || leather == null || frame == null) {
            Backpack.logger.error("Mandatory data missing can't initialize backpack.");
            return;
        }
        leather.setTier(backpack);
        frame.setTier(backpack);
        int slots = leather.getBaseSlots() * size.getSlotMultiplier();
        NBTItemStackUtil.setInteger(backpack, "slots", slots);
        NBTItemStackUtil.setInteger(backpack, "slots_used", 0);
        if (size.equals((Object)ESize.SMALL) && leather.equals((Object)TierLeather.II)) {
            NBTItemStackUtil.setInteger(backpack, "slots_per_row", 6);
        } else if (size.equals((Object)ESize.MEDIUM) && leather.equals((Object)TierLeather.I)) {
            NBTItemStackUtil.setInteger(backpack, "slots_per_row", 6);
        } else if (size.equals((Object)ESize.MEDIUM) && leather.equals((Object)TierLeather.II)) {
            NBTItemStackUtil.setInteger(backpack, "slots_per_row", 8);
        } else {
            NBTItemStackUtil.setInteger(backpack, "slots_per_row", 9);
        }
        NBTItemStackUtil.setInteger(backpack, "module_slots", size.getModuleSlots());
        NBTItemStackUtil.setString(backpack, "backpack-UID", UUID.randomUUID().toString());
    }

    public static int getSlots(ItemStack itemStack) {
        if (BackpackHelper.isBackpack(itemStack)) {
            return NBTItemStackUtil.getInteger(itemStack, "slots");
        }
        return 0;
    }

    public static int getSlotsUsed(ItemStack itemStack) {
        if (BackpackHelper.isBackpack(itemStack)) {
            return NBTItemStackUtil.getInteger(itemStack, "slots_used");
        }
        return 0;
    }

    public static int getSlotsPerRow(ItemStack itemStack) {
        if (BackpackHelper.isBackpack(itemStack)) {
            return NBTItemStackUtil.getInteger(itemStack, "slots_per_row");
        }
        return 9;
    }

    public static String getUUID(ItemStack itemStack) {
        if (BackpackHelper.isBackpack(itemStack)) {
            return NBTItemStackUtil.getString(itemStack, "backpack-UID");
        }
        return "";
    }

    public static IInventory getInventory(EntityPlayer player, boolean heldItem) {
        ItemStack itemStack = BackpackHelper.getBackpackFromPlayer(player, heldItem);
        if (BackpackHelper.isBackpack(itemStack)) {
            return BackpackSave.loadBackpack(player.field_70170_p, itemStack, player, heldItem);
        }
        return null;
    }

    public static boolean isBackpack(ItemStack itemStack) {
        return itemStack.func_77973_b() == BackpackItems.backpack && !itemStack.func_190926_b();
    }

    public static ItemStack getBackpackFromPlayer(EntityPlayer player, boolean heldItem) {
        ItemStack backpack;
        if (heldItem) {
            backpack = player.func_184614_ca();
        } else if (GeneralUtil.isServerSide(player.field_70170_p)) {
            PlayerSave playerSave = PlayerSave.loadPlayer(player.field_70170_p, player);
            backpack = playerSave.getBackpack();
        } else {
            backpack = Backpack.proxy.getClientBackpack(player);
        }
        if (BackpackHelper.isBackpack(backpack)) {
            return backpack;
        }
        return ItemStack.field_190927_a;
    }

    public static void setSlotsUsed(ItemStack backpack, int slotsUsed) {
        NBTItemStackUtil.setInteger(backpack, "slots_used", slotsUsed);
    }
}

