/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.part.gas;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import com.the9grounds.aeadditions.api.IWrenchHandler;
import com.the9grounds.aeadditions.api.gas.IAEGasStack;
import com.the9grounds.aeadditions.api.gas.IGasStorageChannel;
import com.the9grounds.aeadditions.integration.Integration;
import com.the9grounds.aeadditions.models.PartModels;
import com.the9grounds.aeadditions.part.PartECBase;
import com.the9grounds.aeadditions.part.gas.PartGasStorageMonitor$WhenMappings;
import com.the9grounds.aeadditions.util.AEUtils;
import com.the9grounds.aeadditions.util.GasUtil;
import com.the9grounds.aeadditions.util.StorageChannels;
import com.the9grounds.aeadditions.util.WrenchUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00f0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/J\u0010\u00100\u001a\u00020)2\u0006\u00101\u001a\u000202H\u0016J\u0012\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020:H\u0016J*\u0010;\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010=\u0018\u00010<2\u0006\u0010>\u001a\u00020?2\u000e\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010=0AH\u0016J\u0012\u0010B\u001a\u0004\u0018\u00010?2\u0006\u0010C\u001a\u00020?H\u0016J\u0010\u0010D\u001a\u00020)2\u0006\u0010E\u001a\u00020FH\u0002J&\u0010G\u001a\u00020\u001c2\b\u0010H\u001a\u0004\u0018\u00010I2\b\u0010J\u001a\u0004\u0018\u00010K2\b\u0010,\u001a\u0004\u0018\u00010LH\u0016J&\u0010M\u001a\u00020\u001c2\b\u0010H\u001a\u0004\u0018\u00010I2\b\u0010J\u001a\u0004\u0018\u00010K2\b\u0010,\u001a\u0004\u0018\u00010LH\u0017J\b\u0010N\u001a\u00020)H\u0017JJ\u0010N\u001a\u00020)2\f\u0010O\u001a\b\u0012\u0002\b\u0003\u0018\u00010P2\f\u0010Q\u001a\b\u0012\u0002\b\u0003\u0018\u00010R2\f\u0010S\u001a\b\u0012\u0002\b\u0003\u0018\u00010R2\b\u0010T\u001a\u0004\u0018\u00010U2\f\u0010V\u001a\b\u0012\u0002\b\u0003\u0018\u00010WH\u0016J\u0010\u0010X\u001a\u00020)2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010Y\u001a\u00020\u001c2\u0006\u0010>\u001a\u00020ZH\u0016J0\u0010[\u001a\u00020)2\u0006\u0010\\\u001a\u0002082\u0006\u0010]\u001a\u0002082\u0006\u0010^\u001a\u0002082\u0006\u0010_\u001a\u0002042\u0006\u0010`\u001a\u00020aH\u0017J\u0018\u0010b\u001a\u00020)2\u0006\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020fH\u0003J\b\u0010g\u001a\u00020\u001cH\u0016J\u0018\u0010h\u001a\u00020)2\u0006\u0010E\u001a\u00020F2\u0006\u0010i\u001a\u00020jH\u0002J\u0012\u0010k\u001a\u00020)2\b\u0010l\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010m\u001a\u00020)2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010n\u001a\u00020)2\u0006\u0010>\u001a\u00020ZH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001d\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006o"}, d2={"Lcom/the9grounds/aeadditions/part/gas/PartGasStorageMonitor;", "Lcom/the9grounds/aeadditions/part/PartECBase;", "Lappeng/api/networking/storage/IStackWatcherHost;", "()V", "amount", "", "getAmount", "()J", "setAmount", "(J)V", "dspList", "", "getDspList", "()Ljava/lang/Object;", "setDspList", "(Ljava/lang/Object;)V", "fluid", "Lnet/minecraftforge/fluids/Fluid;", "getFluid", "()Lnet/minecraftforge/fluids/Fluid;", "setFluid", "(Lnet/minecraftforge/fluids/Fluid;)V", "gasStorage", "Lappeng/api/storage/IMEMonitor;", "Lcom/the9grounds/aeadditions/api/gas/IAEGasStack;", "getGasStorage", "()Lappeng/api/storage/IMEMonitor;", "isMekanismEnabled", "", "()Z", "locked", "getLocked", "setLocked", "(Z)V", "watcher", "Lappeng/api/networking/storage/IStackWatcher;", "getWatcher", "()Lappeng/api/networking/storage/IStackWatcher;", "setWatcher", "(Lappeng/api/networking/storage/IStackWatcher;)V", "dropItems", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "stack", "Lnet/minecraft/item/ItemStack;", "getBoxes", "bch", "Lappeng/api/parts/IPartCollisionHelper;", "getCableConnectionLength", "", "aeCableType", "Lappeng/api/util/AECableType;", "getPowerUsage", "", "getStaticModels", "Lappeng/api/parts/IPartModel;", "getWailaBodey", "", "", "data", "Lnet/minecraft/nbt/NBTTagCompound;", "list", "", "getWailaTag", "tag", "moveToFace", "face", "Lnet/minecraft/util/EnumFacing;", "onActivate", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "Lnet/minecraft/util/math/Vec3d;", "onActivateGas", "onStackChange", "p0", "Lappeng/api/storage/data/IItemList;", "p1", "Lappeng/api/storage/data/IAEStack;", "p2", "p3", "Lappeng/api/networking/security/IActionSource;", "p4", "Lappeng/api/storage/IStorageChannel;", "readFromNBT", "readFromStream", "Lio/netty/buffer/ByteBuf;", "renderDynamic", "x", "y", "z", "partialTicks", "destroyStage", "", "renderFluid", "tess", "Lnet/minecraft/client/renderer/Tessellator;", "fluidStack", "Lappeng/api/storage/data/IAEFluidStack;", "requireDynamicRender", "rotateToFace", "spin", "", "updateWatcher", "w", "writeToNBT", "writeToStream", "AEAdditions-1.12.2"})
public class PartGasStorageMonitor
extends PartECBase
implements IStackWatcherHost {
    @Nullable
    private Fluid fluid;
    private long amount;
    @Nullable
    private Object dspList;
    private boolean locked;
    @Nullable
    private IStackWatcher watcher;
    private final boolean isMekanismEnabled = Integration.Mods.MEKANISMGAS.isEnabled();

    @Nullable
    public final Fluid getFluid() {
        return this.fluid;
    }

    public final void setFluid(@Nullable Fluid fluid) {
        this.fluid = fluid;
    }

    public final long getAmount() {
        return this.amount;
    }

    public final void setAmount(long l) {
        this.amount = l;
    }

    @Nullable
    public final Object getDspList() {
        return this.dspList;
    }

    public final void setDspList(@Nullable Object object) {
        this.dspList = object;
    }

    public final boolean getLocked() {
        return this.locked;
    }

    public final void setLocked(boolean bl) {
        this.locked = bl;
    }

    @Nullable
    public final IStackWatcher getWatcher() {
        return this.watcher;
    }

    public final void setWatcher(@Nullable IStackWatcher iStackWatcher) {
        this.watcher = iStackWatcher;
    }

    @Nullable
    public final IMEMonitor<IAEGasStack> getGasStorage() {
        IGridNode iGridNode = this.getGridNode();
        if (iGridNode == null) {
            return null;
        }
        IGridNode n = iGridNode;
        IGrid iGrid = n.getGrid();
        if (iGrid == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)iGrid, (String)"n.grid ?: return null");
        IGrid g = iGrid;
        IStorageGrid iStorageGrid = (IStorageGrid)g.getCache(IStorageGrid.class);
        if (iStorageGrid == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)iStorageGrid, (String)"g.getCache<IStorageGrid>\u2026lass.java) ?: return null");
        IStorageGrid storage = iStorageGrid;
        return storage.getInventory((IStorageChannel)StorageChannels.GAS);
    }

    public float getCableConnectionLength(@Nullable AECableType aeCableType) {
        return 1.0f;
    }

    public final void dropItems(@Nullable World world, @NotNull BlockPos pos, @Nullable ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        if (world == null) {
            return;
        }
        if (!world.field_72995_K) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
            entityitem.func_174867_a(10);
            world.func_72838_d((Entity)entityitem);
        }
    }

    @Override
    public void getBoxes(@NotNull IPartCollisionHelper bch) {
        Intrinsics.checkParameterIsNotNull((Object)bch, (String)"bch");
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    @Nullable
    public List<String> getWailaBodey(@NotNull NBTTagCompound data, @NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        super.getWailaBodey(data, list);
        long amount = 0L;
        Fluid fluid = null;
        if (data.func_74764_b("locked") && data.func_74767_n("locked")) {
            list.add(I18n.func_74838_a((String)"waila.appliedenergistics2.Locked"));
        } else {
            list.add(I18n.func_74838_a((String)"waila.appliedenergistics2.Unlocked"));
        }
        if (data.func_74764_b("amount")) {
            amount = data.func_74763_f("amount");
        }
        if (data.func_74764_b("fluid")) {
            String fluidName;
            String string = fluidName = data.func_74779_i("fluid");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fluidName");
            CharSequence charSequence = string;
            boolean bl = false;
            if (!(charSequence.length() == 0)) {
                fluid = FluidRegistry.getFluid((String)fluidName);
            }
        }
        if (fluid != null) {
            list.add(I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.fluid") + ": " + fluid.getLocalizedName(new FluidStack(fluid, 1000)));
            if (this.isActive()) {
                list.add(I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.amount") + ": " + amount + "mB");
            } else {
                list.add(I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.amount") + ": 0mB");
            }
        } else {
            list.add(I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.fluid") + ": " + I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.empty1"));
            list.add(I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.amount") + ": 0mB");
        }
        return list;
    }

    @Override
    @Nullable
    public NBTTagCompound getWailaTag(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        super.getWailaTag(tag);
        tag.func_74757_a("locked", this.locked);
        tag.func_74772_a("amount", this.amount);
        if (this.fluid == null) {
            tag.func_74778_a("fluid", "");
        } else {
            Fluid fluid = this.fluid;
            if (fluid == null) {
                Intrinsics.throwNpe();
            }
            tag.func_74778_a("fluid", fluid.getName());
        }
        return tag;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super.readFromNBT(data);
        if (data.func_74764_b("amount")) {
            this.amount = data.func_74763_f("amount");
        }
        if (data.func_74764_b("fluid")) {
            String name;
            String string = name = data.func_74779_i("fluid");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            CharSequence charSequence = string;
            boolean bl = false;
            this.fluid = charSequence.length() == 0 ? (Fluid)null : FluidRegistry.getFluid((String)name);
        }
        if (data.func_74764_b("locked")) {
            this.locked = data.func_74767_n("locked");
        }
    }

    @Override
    public boolean readFromStream(@NotNull ByteBuf data) throws IOException {
        String name;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super.readFromStream(data);
        this.amount = data.readLong();
        String string = name = ByteBufUtils.readUTF8String((ByteBuf)data);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        CharSequence charSequence = string;
        boolean bl = false;
        this.fluid = charSequence.length() == 0 ? (Fluid)null : FluidRegistry.getFluid((String)name);
        this.locked = data.readBoolean();
        return true;
    }

    public final boolean isMekanismEnabled() {
        return this.isMekanismEnabled;
    }

    @Override
    public boolean onActivate(@Nullable EntityPlayer player, @Nullable EnumHand hand, @Nullable Vec3d pos) {
        if (this.isMekanismEnabled) {
            return this.onActivateGas(player, hand, pos);
        }
        return false;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public boolean onActivateGas(@Nullable EntityPlayer player, @Nullable EnumHand hand, @Nullable Vec3d pos) {
        EntityPlayer entityPlayer = player;
        if ((entityPlayer != null ? entityPlayer.field_70170_p : null) == null || hand == null || pos == null) {
            return true;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack == null) {
            if (this.locked) {
                return false;
            }
            if (this.fluid == null) {
                return true;
            }
            if (this.watcher != null) {
                IStackWatcher iStackWatcher = this.watcher;
                if (iStackWatcher == null) {
                    Intrinsics.throwNpe();
                }
                IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
                if (iGasStorageChannel == null) {
                    Intrinsics.throwNpe();
                }
                Fluid fluid = this.fluid;
                if (fluid == null) {
                    Intrinsics.throwNpe();
                }
                iStackWatcher.remove(iGasStorageChannel.createStack(fluid));
            }
            this.fluid = null;
            this.amount = 0L;
            IPartHost iPartHost = this.getHost();
            if (iPartHost != null) {
                iPartHost.markForUpdate();
            }
            return true;
        }
        EnumFacing enumFacing = this.getFacing();
        DimensionalCoord dimensionalCoord = this.getLocation();
        if (dimensionalCoord == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)dimensionalCoord, (String)"location!!");
        RayTraceResult rayTraceResult = new RayTraceResult(pos, enumFacing, dimensionalCoord.getPos());
        IWrenchHandler wrenchHandler = WrenchUtil.getHandler(itemStack, player, rayTraceResult, hand);
        if (wrenchHandler != null) {
            this.locked = !this.locked;
            wrenchHandler.wrenchUsed(itemStack, player, rayTraceResult, hand);
            IPartHost iPartHost = this.getHost();
            if (iPartHost != null) {
                iPartHost.markForUpdate();
            }
            if (this.locked) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.appliedenergistics2.isNowLocked", new Object[0]));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.appliedenergistics2.isNowUnlocked", new Object[0]));
            }
            return true;
        }
        if (this.locked) {
            return false;
        }
        if (GasUtil.isFilled(itemStack)) {
            FluidStack fluidStack;
            if (this.fluid != null && this.watcher != null) {
                IStackWatcher iStackWatcher = this.watcher;
                if (iStackWatcher == null) {
                    Intrinsics.throwNpe();
                }
                IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
                if (iGasStorageChannel == null) {
                    Intrinsics.throwNpe();
                }
                Fluid fluid = this.fluid;
                if (fluid == null) {
                    Intrinsics.throwNpe();
                }
                iStackWatcher.remove(iGasStorageChannel.createStack(fluid));
            }
            GasStack gas = GasUtil.getGasFromContainer(itemStack);
            FluidStack fluidStack2 = fluidStack = GasUtil.getFluidStack(gas);
            Object object = this.fluid = fluidStack2 != null ? fluidStack2.getFluid() : null;
            if (this.watcher != null) {
                IStackWatcher iStackWatcher = this.watcher;
                if (iStackWatcher == null) {
                    Intrinsics.throwNpe();
                }
                IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
                if (iGasStorageChannel == null) {
                    Intrinsics.throwNpe();
                }
                Fluid fluid = this.fluid;
                if (fluid == null) {
                    Intrinsics.throwNpe();
                }
                iStackWatcher.add(iGasStorageChannel.createStack(fluid));
            }
            IPartHost iPartHost = this.getHost();
            if (iPartHost != null) {
                iPartHost.markForUpdate();
            }
            this.onStackChange();
            return true;
        }
        return false;
    }

    public void onStackChange(@Nullable IItemList<?> p0, @Nullable IAEStack<?> p1, @Nullable IAEStack<?> p2, @Nullable IActionSource p3, @Nullable IStorageChannel<?> p4) {
        this.onStackChange();
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public void onStackChange() {
        block8: {
            if (this.fluid == null) break block8;
            IGridNode iGridNode = this.getGridNode();
            if (iGridNode == null) {
                return;
            }
            IGridNode node = iGridNode;
            IGrid iGrid = node.getGrid();
            if (iGrid == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)iGrid, (String)"node.grid ?: return");
            IGrid grid = iGrid;
            IStorageGrid iStorageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
            if (iStorageGrid == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)iStorageGrid, (String)"grid.getCache<IStorageGr\u2026id::class.java) ?: return");
            IStorageGrid storage = iStorageGrid;
            IMEMonitor<IAEGasStack> iMEMonitor = this.getGasStorage();
            if (iMEMonitor == null) {
                return;
            }
            IMEMonitor<IAEGasStack> fluids = iMEMonitor;
            Gas gas = GasUtil.getGas(this.fluid);
            Iterator iterator = fluids.getStorageList().iterator();
            while (iterator.hasNext()) {
                IAEGasStack s;
                IAEGasStack iAEGasStack = s = (IAEGasStack)iterator.next();
                if (iAEGasStack == null) {
                    Intrinsics.throwNpe();
                }
                if (!Intrinsics.areEqual((Object)iAEGasStack.getGas(), (Object)gas)) continue;
                this.amount = s.getStackSize();
                IPartHost iPartHost = this.getHost();
                if (iPartHost != null) {
                    iPartHost.markForUpdate();
                }
                return;
            }
            this.amount = 0L;
            IPartHost iPartHost = this.getHost();
            if (iPartHost != null) {
                iPartHost.markForUpdate();
            }
        }
    }

    public void updateWatcher(@Nullable IStackWatcher w) {
        IStackWatcher iStackWatcher = w;
        if (iStackWatcher == null) {
            return;
        }
        this.watcher = iStackWatcher;
        if (this.fluid != null) {
            IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
            if (iGasStorageChannel == null) {
                Intrinsics.throwNpe();
            }
            Fluid fluid = this.fluid;
            if (fluid == null) {
                Intrinsics.throwNpe();
            }
            w.add(iGasStorageChannel.createStack(fluid));
        }
        this.onStackChange(null, null, null, null, null);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, float partialTicks, int destroyStage) {
        Tessellator tess;
        IAEFluidStack aeFluidStack;
        if (this.fluid == null) {
            return;
        }
        if (this.dspList == null) {
            this.dspList = GLAllocation.func_74526_a((int)1);
        }
        if (!this.isActive()) {
            return;
        }
        IAEFluidStack iAEFluidStack = aeFluidStack = AEUtils.createFluidStack(this.fluid);
        if (iAEFluidStack == null) {
            Intrinsics.throwNpe();
        }
        iAEFluidStack.setStackSize(this.amount);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        Integer n = (Integer)this.dspList;
        if (n == null) {
            Intrinsics.throwNpe();
        }
        GlStateManager.func_187423_f((int)n, (int)4865);
        Tessellator tessellator = tess = Tessellator.func_178181_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)tessellator, (String)"tess");
        this.renderFluid(tessellator, aeFluidStack);
        GlStateManager.func_187415_K();
        GlStateManager.func_179121_F();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    private final void renderFluid(Tessellator tess, IAEFluidStack fluidStack) {
        block12: {
            EnumFacing facing;
            GL11.glPushAttrib((int)1048575);
            AEPartLocation aEPartLocation = this.getSide();
            Intrinsics.checkExpressionValueIsNotNull((Object)aEPartLocation, (String)"side");
            EnumFacing enumFacing = facing = aEPartLocation.getFacing();
            Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"facing");
            this.moveToFace(enumFacing);
            this.rotateToFace(facing, (byte)1);
            GlStateManager.func_179094_E();
            try {
                ResourceLocation fluidStill;
                int br = 0x10000100;
                int var11 = br % 65536;
                int var12 = br / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)var11 * 0.8f), (float)((float)var12 * 0.8f));
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                GlStateManager.func_179101_C();
                Minecraft mc = Minecraft.func_71410_x();
                Fluid fluid = this.fluid;
                if (fluid == null) {
                    Intrinsics.throwNpe();
                }
                if ((fluidStill = fluid.getStill()) == null) break block12;
                Minecraft minecraft = mc;
                Intrinsics.checkExpressionValueIsNotNull((Object)minecraft, (String)"mc");
                TextureMap textureMap = minecraft.func_147117_R();
                TextureAtlasSprite fluidIcon = textureMap.func_110572_b(fluidStill.toString());
                if (fluidIcon == null) break block12;
                GL11.glTranslatef((float)0.0f, (float)0.14f, (float)-0.24f);
                GL11.glScalef((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
                GL11.glTranslated((double)-8.6, (double)-16.3, (double)-1.2);
                mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                BufferBuilder buffer = tess.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                try {
                    buffer.func_181662_b(0.0, 16.0, 0.0).func_187315_a((double)fluidIcon.func_94209_e(), (double)fluidIcon.func_94210_h()).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                    buffer.func_181662_b(16.0, 16.0, 0.0).func_187315_a((double)fluidIcon.func_94212_f(), (double)fluidIcon.func_94210_h()).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                    buffer.func_181662_b(16.0, 0.0, 0.0).func_187315_a((double)fluidIcon.func_94212_f(), (double)fluidIcon.func_94206_g()).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                    buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)fluidIcon.func_94209_e(), (double)fluidIcon.func_94206_g()).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                }
                finally {
                    tess.func_78381_a();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179109_b((float)0.0f, (float)0.14f, (float)-0.24f);
        GlStateManager.func_179152_a((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
        long qty = fluidStack.getStackSize();
        if (qty > 999999999999L) {
            qty = 999999999999L;
        }
        String msg = Long.toString(qty) + "mB";
        if (qty > (long)1000000000) {
            msg = Long.toString(qty / (long)1000000000) + "MB";
        } else if (qty > (long)1000000) {
            msg = Long.toString(qty / (long)1000000) + "KB";
        } else if (qty > (long)9999) {
            msg = Long.toString(qty / (long)1000) + 'B';
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int width = fr.func_78256_a(msg);
        GlStateManager.func_179109_b((float)(-0.5f * (float)width), (float)0.0f, (float)-1.0f);
        fr.func_78276_b(msg, 0, 0, 0);
        GlStateManager.func_179099_b();
    }

    private final void moveToFace(EnumFacing face) {
        GlStateManager.func_179137_b((double)((double)face.func_82601_c() * 0.77), (double)((double)face.func_96559_d() * 0.77), (double)((double)face.func_82599_e() * 0.77));
    }

    private final void rotateToFace(EnumFacing face, byte spin) {
        switch (PartGasStorageMonitor$WhenMappings.$EnumSwitchMapping$0[face.ordinal()]) {
            case 1: {
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)spin * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case 2: {
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)spin * -90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case 3: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                break;
            }
            case 6: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
    }

    @NotNull
    public IPartModel getStaticModels() {
        return this.isActive() && this.isPowered() ? (IPartModel)PartModels.STORAGE_MONITOR_HAS_CHANNEL : (IPartModel)(this.isPowered() ? PartModels.STORAGE_MONITOR_ON : PartModels.STORAGE_MONITOR_OFF);
    }

    @Override
    public boolean requireDynamicRender() {
        return true;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super.writeToNBT(data);
        data.func_74772_a("amount", this.amount);
        if (this.fluid == null) {
            data.func_74768_a("fluid", -1);
        } else {
            Fluid fluid = this.fluid;
            if (fluid == null) {
                Intrinsics.throwNpe();
            }
            data.func_74778_a("fluid", fluid.getName());
        }
        data.func_74757_a("locked", this.locked);
    }

    @Override
    public void writeToStream(@NotNull ByteBuf data) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super.writeToStream(data);
        data.writeLong(this.amount);
        if (this.fluid == null) {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)"");
        } else {
            Fluid fluid = this.fluid;
            if (fluid == null) {
                Intrinsics.throwNpe();
            }
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)fluid.getName());
        }
        data.writeBoolean(this.locked);
    }
}

