/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.part.gas;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.the9grounds.aeadditions.api.gas.IAEGasStack;
import com.the9grounds.aeadditions.api.gas.IGasStorageChannel;
import com.the9grounds.aeadditions.integration.Integration;
import com.the9grounds.aeadditions.integration.mekanism.gas.Capabilities;
import com.the9grounds.aeadditions.integration.mekanism.gas.MekanismGas;
import com.the9grounds.aeadditions.models.PartModels;
import com.the9grounds.aeadditions.part.gas.PartGasIO;
import com.the9grounds.aeadditions.util.GasUtil;
import com.the9grounds.aeadditions.util.PermissionUtil;
import com.the9grounds.aeadditions.util.StorageChannels;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Optional.InterfaceList(value={@Optional.Interface(striprefs=true, modid="MekanismAPI|gas", iface="mekanism.api.gas.IGasHandler"), @Optional.Interface(striprefs=true, modid="MekanismAPI|gas", iface="mekanism.api.gas.ITubeConnection")})
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0017J\u001c\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0017J\u0012\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J$\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0006H\u0017J\u001a\u0010\u0018\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0013H\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J#\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u0002H%\u0018\u00010'H\u0017\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0016\u0010-\u001a\u00020\u00062\f\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010'H\u0017J&\u0010.\u001a\u00020\u00062\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u0001022\b\u00103\u001a\u0004\u0018\u000104H\u0016J$\u00105\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\t2\b\u00106\u001a\u0004\u0018\u00010\u00162\u0006\u00107\u001a\u00020\u0006H\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/the9grounds/aeadditions/part/gas/PartGasImport;", "Lcom/the9grounds/aeadditions/part/gas/PartGasIO;", "Lmekanism/api/gas/IGasHandler;", "Lmekanism/api/gas/ITubeConnection;", "()V", "isMekanismEnabled", "", "canDrawGas", "p0", "Lnet/minecraft/util/EnumFacing;", "p1", "Lmekanism/api/gas/Gas;", "canReceiveGas", "side", "gas", "canTubeConnect", "enumFacing", "doWork", "rate", "", "ticksSinceLastCall", "drawGas", "Lmekanism/api/gas/GasStack;", "p2", "fillToNetwork", "fluid", "Lnet/minecraftforge/fluids/Fluid;", "toDrain", "getBoxes", "", "bch", "Lappeng/api/parts/IPartCollisionHelper;", "getCableConnectionLength", "", "aeCableType", "Lappeng/api/util/AECableType;", "getCapability", "T", "capabilityClass", "Lnet/minecraftforge/common/capabilities/Capability;", "(Lnet/minecraftforge/common/capabilities/Capability;)Ljava/lang/Object;", "getPowerUsage", "", "getStaticModels", "Lappeng/api/parts/IPartModel;", "hasCapability", "onActivate", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "enumHand", "Lnet/minecraft/util/EnumHand;", "pos", "Lnet/minecraft/util/math/Vec3d;", "receiveGas", "stack", "doTransfer", "AEAdditions-1.12.2"})
public final class PartGasImport
extends PartGasIO
implements IGasHandler,
ITubeConnection {
    private final boolean isMekanismEnabled = Integration.Mods.MEKANISMGAS.isEnabled();

    @Override
    public float getCableConnectionLength(@Nullable AECableType aeCableType) {
        return 5.0f;
    }

    @Override
    public void getBoxes(@NotNull IPartCollisionHelper bch) {
        Intrinsics.checkParameterIsNotNull((Object)bch, (String)"bch");
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(6.0, 6.0, 12.0, 10.0, 10.0, 13.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public boolean onActivate(@Nullable EntityPlayer player, @Nullable EnumHand enumHand, @Nullable Vec3d pos) {
        PartGasImport partGasImport = this;
        if (partGasImport == null) {
            throw new TypeCastException("null cannot be cast to non-null type appeng.api.parts.IPart");
        }
        return PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, partGasImport) && super.onActivate(player, enumHand, pos);
    }

    @NotNull
    public IPartModel getStaticModels() {
        return this.isActive() && this.isPowered() ? (IPartModel)PartModels.IMPORT_HAS_CHANNEL : (IPartModel)(this.isPowered() ? PartModels.IMPORT_ON : PartModels.IMPORT_OFF);
    }

    @Override
    public boolean doWork(int rate, int ticksSinceLastCall) {
        if (!this.isMekanismEnabled || this.getFacingGasTank() == null || !this.isActive()) {
            return false;
        }
        boolean empty = true;
        List<Fluid> activeFilters = this.getActiveFilters();
        for (Fluid fluid : activeFilters) {
            if (fluid == null) continue;
            empty = false;
            if (!this.fillToNetwork(fluid, rate * ticksSinceLastCall)) continue;
            return true;
        }
        return empty && this.fillToNetwork(null, rate * ticksSinceLastCall);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public final boolean fillToNetwork(@Nullable Fluid fluid, int toDrain) {
        Gas gasType;
        Object object;
        GasStack drained = null;
        IGasHandler facingTank = this.getFacingGasTank();
        EnumFacing side = this.getFacing();
        if (fluid == null) {
            object = null;
        } else {
            GasStack gasStack;
            GasStack gasStack2 = gasStack = GasUtil.getGasStack(new FluidStack(fluid, toDrain));
            object = gasType = gasStack2 != null ? gasStack2.getGas() : null;
        }
        if (gasType == null) {
            EnumFacing enumFacing = side;
            Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"side");
            drained = facingTank.drawGas(enumFacing.func_176734_d(), toDrain, false);
        } else {
            EnumFacing enumFacing = side;
            Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"side");
            if (facingTank.canDrawGas(enumFacing.func_176734_d(), gasType)) {
                drained = facingTank.drawGas(side.func_176734_d(), toDrain, false);
            }
        }
        if (drained == null || drained.amount <= 0 || drained.getGas() == null) {
            return false;
        }
        IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
        if (iGasStorageChannel == null) {
            Intrinsics.throwNpe();
        }
        IAEGasStack iAEGasStack = (IAEGasStack)iGasStorageChannel.createStack(drained);
        if (iAEGasStack == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)iAEGasStack, (String)"StorageChannels.GAS!!.cr\u2026(drained) ?: return false");
        IAEGasStack toFill = iAEGasStack;
        IAEGasStack notInjected = this.injectGas(toFill, Actionable.MODULATE);
        if (notInjected != null) {
            int amount = (int)(toFill.getStackSize() - notInjected.getStackSize());
            if (amount > 0) {
                facingTank.drawGas(side.func_176734_d(), amount, true);
                return true;
            }
            return false;
        }
        Object gasStack = toFill.getGasStack();
        if (gasStack instanceof GasStack) {
            facingTank.drawGas(side.func_176734_d(), toDrain, true);
            return true;
        }
        return false;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public int receiveGas(@Nullable EnumFacing side, @Nullable GasStack stack, boolean doTransfer) {
        if (!this.canDoWork()) {
            return 0;
        }
        if (stack == null || stack.amount <= 0 || !this.canReceiveGas(side, stack.getGas()) || !this.isActive()) {
            return 0;
        }
        Actionable action = doTransfer ? Actionable.MODULATE : Actionable.SIMULATE;
        int n = stack.amount;
        int n2 = this.getMaxAmountToTransfer();
        boolean bl = false;
        int amount = Math.min(n, n2);
        IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
        if (iGasStorageChannel == null) {
            Intrinsics.throwNpe();
        }
        IAEGasStack gasStack = (IAEGasStack)iGasStorageChannel.createStack(new GasStack(stack.getGas(), amount));
        IAEGasStack iAEGasStack = this.injectGas(gasStack, action);
        if (iAEGasStack == null) {
            return amount;
        }
        IAEGasStack notInjected = iAEGasStack;
        return amount - (int)notInjected.getStackSize();
    }

    @Optional.Method(modid="MekanismAPI|gas")
    @Nullable
    public GasStack drawGas(@Nullable EnumFacing p0, int p1, boolean p2) {
        return null;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public boolean canReceiveGas(@Nullable EnumFacing side, @Nullable Gas gas) {
        if (!this.canDoWork()) {
            return false;
        }
        Map<Gas, Fluid> map = MekanismGas.fluidGas;
        boolean bl = false;
        Fluid fluid = map.get(gas);
        boolean isEmpty = true;
        for (Fluid filter : this.filterFluids) {
            if (filter == null) continue;
            isEmpty = false;
            if (!Intrinsics.areEqual((Object)filter, (Object)fluid)) continue;
            return true;
        }
        return isEmpty;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public boolean canDrawGas(@Nullable EnumFacing p0, @Nullable Gas p1) {
        return false;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public boolean hasCapability(@Nullable Capability<?> capabilityClass) {
        return Intrinsics.areEqual(capabilityClass, Capabilities.GAS_HANDLER_CAPABILITY) || Intrinsics.areEqual(capabilityClass, Capabilities.TUBE_CONNECTION_CAPABILITY);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public <T> T getCapability(@Nullable Capability<T> capabilityClass) {
        if (Intrinsics.areEqual(capabilityClass, Capabilities.GAS_HANDLER_CAPABILITY)) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        if (Intrinsics.areEqual(capabilityClass, Capabilities.TUBE_CONNECTION_CAPABILITY)) {
            return (T)Capabilities.TUBE_CONNECTION_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capabilityClass);
    }

    public boolean canTubeConnect(@Nullable EnumFacing enumFacing) {
        boolean bl;
        if (enumFacing == null) {
            bl = false;
        } else {
            AEPartLocation aEPartLocation = this.getSide();
            Intrinsics.checkExpressionValueIsNotNull((Object)aEPartLocation, (String)"this.side");
            bl = enumFacing == aEPartLocation.getFacing();
        }
        return bl;
    }
}

