/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.part.gas;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.the9grounds.aeadditions.api.gas.IAEGasStack;
import com.the9grounds.aeadditions.api.gas.IGasStorageChannel;
import com.the9grounds.aeadditions.integration.Integration;
import com.the9grounds.aeadditions.integration.mekanism.gas.Capabilities;
import com.the9grounds.aeadditions.models.PartModels;
import com.the9grounds.aeadditions.part.gas.PartGasIO;
import com.the9grounds.aeadditions.util.PermissionUtil;
import com.the9grounds.aeadditions.util.StorageChannels;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Optional.Interface(iface="mekanism.api.gas.ITubeConnection", modid="MekanismAPI|gas", striprefs=true)
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J#\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u0002H\u0016\u0018\u00010\u0018H\u0017\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0018H\u0017J&\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/the9grounds/aeadditions/part/gas/PartGasExport;", "Lcom/the9grounds/aeadditions/part/gas/PartGasIO;", "Lmekanism/api/gas/ITubeConnection;", "()V", "isMekanismEnabled", "", "canTubeConnect", "enumFacing", "Lnet/minecraft/util/EnumFacing;", "doWork", "rate", "", "ticksSinceLastCall", "getBoxes", "", "bch", "Lappeng/api/parts/IPartCollisionHelper;", "getCableConnectionLength", "", "aeCableType", "Lappeng/api/util/AECableType;", "getCapability", "T", "capabilityClass", "Lnet/minecraftforge/common/capabilities/Capability;", "(Lnet/minecraftforge/common/capabilities/Capability;)Ljava/lang/Object;", "getPowerUsage", "", "getStaticModels", "Lappeng/api/parts/IPartModel;", "hasCapability", "onActivate", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "pos", "Lnet/minecraft/util/math/Vec3d;", "work", "AEAdditions-1.12.2"})
public final class PartGasExport
extends PartGasIO
implements ITubeConnection {
    private final boolean isMekanismEnabled = Integration.Mods.MEKANISMGAS.isEnabled();

    @Override
    public float getCableConnectionLength(@Nullable AECableType aeCableType) {
        return 5.0f;
    }

    @Override
    public void getBoxes(@NotNull IPartCollisionHelper bch) {
        Intrinsics.checkParameterIsNotNull((Object)bch, (String)"bch");
        bch.addBox(6.0, 6.0, 12.0, 10.0, 10.0, 13.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public boolean onActivate(@Nullable EntityPlayer player, @Nullable EnumHand hand, @Nullable Vec3d pos) {
        PartGasExport partGasExport = this;
        if (partGasExport == null) {
            throw new TypeCastException("null cannot be cast to non-null type appeng.api.parts.IPart");
        }
        return PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, partGasExport) ? super.onActivate(player, hand, pos) : false;
    }

    @NotNull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return PartModels.EXPORT_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return PartModels.EXPORT_ON;
        }
        return PartModels.EXPORT_OFF;
    }

    @Override
    public boolean doWork(int rate, int ticksSinceLastCall) {
        if (this.isMekanismEnabled) {
            return this.work(rate, ticksSinceLastCall);
        }
        return false;
    }

    protected final boolean work(int rate, int ticksSinceLastCall) {
        IGasHandler iGasHandler = this.getFacingGasTank();
        if (iGasHandler == null) {
            return false;
        }
        IGasHandler facingTank = iGasHandler;
        if (!this.isActive()) {
            return false;
        }
        List<Fluid> activeFilters = this.getActiveFilters();
        for (Fluid fluid : activeFilters) {
            IAEGasStack stack;
            if (fluid == null) continue;
            IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
            if (iGasStorageChannel == null) {
                Intrinsics.throwNpe();
            }
            if ((stack = this.extractGas((IAEGasStack)iGasStorageChannel.createStack(new FluidStack(fluid, rate * ticksSinceLastCall)), Actionable.SIMULATE)) == null) continue;
            Object object = stack.getGasStack();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type mekanism.api.gas.GasStack");
            }
            GasStack gasStack = (GasStack)object;
            if (gasStack == null) continue;
            EnumFacing enumFacing = this.getFacing();
            Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"facing");
            if (!facingTank.canReceiveGas(enumFacing.func_176734_d(), gasStack.getGas())) continue;
            EnumFacing enumFacing2 = this.getFacing();
            Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing2, (String)"facing");
            int filled = facingTank.receiveGas(enumFacing2.func_176734_d(), gasStack, true);
            if (filled <= 0) continue;
            IGasStorageChannel iGasStorageChannel2 = StorageChannels.GAS;
            if (iGasStorageChannel2 == null) {
                Intrinsics.throwNpe();
            }
            this.extractGas((IAEGasStack)iGasStorageChannel2.createStack(new FluidStack(fluid, filled)), Actionable.MODULATE);
            return true;
        }
        return false;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public boolean hasCapability(@Nullable Capability<?> capabilityClass) {
        return Intrinsics.areEqual(capabilityClass, Capabilities.TUBE_CONNECTION_CAPABILITY);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public <T> T getCapability(@Nullable Capability<T> capabilityClass) {
        if (Intrinsics.areEqual(capabilityClass, Capabilities.TUBE_CONNECTION_CAPABILITY)) {
            return (T)Capabilities.TUBE_CONNECTION_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capabilityClass);
    }

    public boolean canTubeConnect(@Nullable EnumFacing enumFacing) {
        boolean bl;
        if (enumFacing == null) {
            bl = false;
        } else {
            AEPartLocation aEPartLocation = this.getSide();
            Intrinsics.checkExpressionValueIsNotNull((Object)aEPartLocation, (String)"this.side");
            bl = enumFacing == aEPartLocation.getFacing();
        }
        return bl;
    }
}

