/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.part;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import com.the9grounds.aeadditions.inventory.IInventoryListener;
import com.the9grounds.aeadditions.inventory.InventoryPlain;
import com.the9grounds.aeadditions.models.PartModels;
import com.the9grounds.aeadditions.part.PartECBase;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PartBattery
extends PartECBase
implements IAEPowerStorage,
IInventoryListener {
    private ItemStack battery;
    IAEItemPowerStorage handler;
    private InventoryPlain inventory = new InventoryPlain("com.the9grounds.aeadditions.part.battery", 1, 1){

        @Override
        public boolean func_94041_b(int i, ItemStack itemStack) {
            return itemStack != null && itemStack.func_77973_b() instanceof IAEItemPowerStorage;
        }
    };

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack stack : this.inventory.slots) {
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    public float getCableConnectionLength(AECableType aeCableType) {
        return 2.0f;
    }

    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        if (this.handler == null || this.battery == null) {
            return 0.0;
        }
        return this.handler.extractAEPower(this.battery, usePowerMultiplier.multiply(amt), mode);
    }

    public double getAECurrentPower() {
        if (this.handler == null || this.battery == null) {
            return 0.0;
        }
        return this.handler.getAECurrentPower(this.battery);
    }

    public double getAEMaxPower() {
        if (this.handler == null || this.battery == null) {
            return 0.0;
        }
        return this.handler.getAEMaxPower(this.battery);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
    }

    public AccessRestriction getPowerFlow() {
        if (this.handler == null || this.battery == null) {
            return AccessRestriction.NO_ACCESS;
        }
        return this.handler.getPowerFlow(this.battery);
    }

    public double injectAEPower(double amt, Actionable mode) {
        if (this.handler == null || this.battery == null) {
            return 0.0;
        }
        return this.handler.injectAEPower(this.battery, amt, mode);
    }

    public boolean isAEPublicPowerStorage() {
        return true;
    }

    @Override
    public void onInventoryChanged() {
        this.battery = this.inventory.func_70301_a(0);
        this.handler = this.battery != null && this.battery.func_77973_b() instanceof IAEItemPowerStorage ? (IAEItemPowerStorage)this.battery.func_77973_b() : null;
        IGridNode node = this.getGridNode();
        if (node != null) {
            IGrid grid = node.getGrid();
            if (grid != null) {
                grid.postEvent((MENetworkEvent)new MENetworkPowerStorage((IAEPowerStorage)this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inventory.readFromNBT(data.func_150295_c("inventory", 10));
        this.onInventoryChanged();
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT());
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return PartModels.BATTERY_PLANE_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return PartModels.BATTERY_PLANE_ON;
        }
        return PartModels.BATTERY_PLANE_OFF;
    }
}

