/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.models.blocks;

import com.google.common.collect.ImmutableList;
import com.the9grounds.aeadditions.models.BlankModel;
import com.the9grounds.aeadditions.registries.ItemEnum;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidItemModel
implements IModel {
    public Fluid fluid;

    public FluidItemModel(Fluid fluid) {
        this.fluid = fluid;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.singletonList(this.fluid.getStill());
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite sprite = bakedTextureGetter.apply(this.fluid.getStill());
        if (sprite == null) {
            return new FluidItemBakedModel((ImmutableList<BakedQuad>)ImmutableList.of());
        }
        return new FluidItemBakedModel((ImmutableList<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)sprite, (VertexFormat)format, Optional.empty()));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    private class FluidItemBakedModel
    extends BlankModel {
        ImmutableList<BakedQuad> quads;

        public FluidItemBakedModel(ImmutableList<BakedQuad> quads) {
            this.quads = quads;
        }

        @Override
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            if (side != EnumFacing.UP) {
                return ImmutableList.of();
            }
            return this.quads;
        }

        @Override
        public boolean func_177556_c() {
            return false;
        }
    }

    public static class ModelLoader
    implements ICustomModelLoader {
        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("aeadditions") && modelLocation.func_110623_a().contains("models/item/fluid/");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            String fluidName = modelLocation.func_110623_a().replace("models/item/fluid/", "");
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            if (fluid == null) {
                fluid = FluidRegistry.WATER;
            }
            return new FluidItemModel(fluid);
        }

        public void func_110549_a(IResourceManager resourceManager) {
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                ModelBakery.registerItemVariants((Item)ItemEnum.FLUIDITEM.getItem(), (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("aeadditions:fluid/" + fluid.getName())});
            }
        }
    }
}

