/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.models;

import com.google.common.base.Preconditions;
import com.the9grounds.aeadditions.block.IColoredBlock;
import com.the9grounds.aeadditions.integration.Integration;
import com.the9grounds.aeadditions.item.IColoredItem;
import com.the9grounds.aeadditions.models.AEAModelLoader;
import com.the9grounds.aeadditions.models.BlockModelEntry;
import com.the9grounds.aeadditions.models.IItemModelRegister;
import com.the9grounds.aeadditions.models.IStateMapperRegister;
import com.the9grounds.aeadditions.models.blocks.FluidItemModel;
import com.the9grounds.aeadditions.models.blocks.GasItemModel;
import com.the9grounds.aeadditions.models.drive.HardDriveModel;
import com.the9grounds.aeadditions.models.drive.PartDriveModel;
import com.the9grounds.aeadditions.util.ModelUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelManager {
    private static final ModelManager INSTANCE = new ModelManager();
    private static final Map<String, IModel> customModels = new HashMap<String, IModel>();
    private static final List<IItemModelRegister> itemModelRegisters = new ArrayList<IItemModelRegister>();
    private static final List<IStateMapperRegister> stateMapperRegisters = new ArrayList<IStateMapperRegister>();
    private static final List<IColoredBlock> blockColorList = new ArrayList<IColoredBlock>();
    private static final List<IColoredItem> itemColorList = new ArrayList<IColoredItem>();
    private static IModelState defaultBlockState;
    private static IModelState defaultItemState;

    public static ModelManager getInstance() {
        return INSTANCE;
    }

    public void registerItemModel(Item item, int meta, String identifier) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)this.getModelLocation(identifier));
    }

    public void registerItemModel(Item item, int meta, String modID, String identifier) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)this.getModelLocation(modID, identifier));
    }

    public void registerItemModel(Item item) {
        this.registerItemModel(item, 0);
    }

    public void registerItemModel(Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)this.getModelLocation(item));
    }

    public void registerItemModel(Item item, ItemMeshDefinition definition) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)definition);
    }

    public ModelResourceLocation getModelLocation(Item item) {
        ResourceLocation resourceLocation = item.getRegistryName();
        Preconditions.checkNotNull((Object)resourceLocation);
        String itemName = resourceLocation.func_110623_a();
        return this.getModelLocation(itemName);
    }

    public ModelResourceLocation getModelLocation(String identifier) {
        return this.getModelLocation("aeadditions", identifier);
    }

    public ModelResourceLocation getModelLocation(String modID, String identifier) {
        return new ModelResourceLocation(modID + ":" + identifier, "inventory");
    }

    public static void registerBlockClient(Block block) {
        if (block instanceof IItemModelRegister) {
            itemModelRegisters.add((IItemModelRegister)block);
        }
        if (block instanceof IStateMapperRegister) {
            stateMapperRegisters.add((IStateMapperRegister)block);
        }
        if (block instanceof IColoredBlock) {
            blockColorList.add((IColoredBlock)block);
        }
    }

    public static void registerItemClient(Item item) {
        if (item instanceof IItemModelRegister) {
            itemModelRegisters.add((IItemModelRegister)item);
        }
        if (item instanceof IColoredItem) {
            itemColorList.add((IColoredItem)item);
        }
    }

    public static void registerModels() {
        for (IItemModelRegister itemModelRegister : itemModelRegisters) {
            Item item = null;
            if (itemModelRegister instanceof Block) {
                item = Item.func_150898_a((Block)((Block)itemModelRegister));
            } else if (itemModelRegister instanceof Item) {
                item = (Item)itemModelRegister;
            }
            if (item == null) continue;
            itemModelRegister.registerModel(item, INSTANCE);
        }
        for (IStateMapperRegister stateMapperRegister : stateMapperRegisters) {
            stateMapperRegister.registerStateMapper();
        }
    }

    public static void registerItemAndBlockColors() {
        Minecraft minecraft = Minecraft.func_71410_x();
        BlockColors blockColors = minecraft.func_184125_al();
        for (IColoredBlock blockColor : blockColorList) {
            if (!(blockColor instanceof Block)) continue;
            blockColors.func_186722_a((IBlockColor)ColoredBlockBlockColor.INSTANCE, new Block[]{(Block)blockColor});
        }
        ItemColors itemColors = minecraft.getItemColors();
        for (IColoredItem itemColor : itemColorList) {
            if (!(itemColor instanceof Item)) continue;
            itemColors.func_186730_a((IItemColor)ColoredItemItemColor.INSTANCE, new Item[]{(Item)itemColor});
        }
    }

    public static IModelState getDefaultBlockState() {
        return defaultBlockState;
    }

    public static IModelState getDefaultItemState() {
        return defaultItemState;
    }

    public static void addModel(String path, IModel model) {
        customModels.put(path, model);
    }

    public static void init() {
        ModelManager.addModel("models/block/builtin/hard_drive", new HardDriveModel());
        ModelManager.addModel("models/part/drive", new PartDriveModel());
        OBJLoader.INSTANCE.addDomain("aeadditions");
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new FluidItemModel.ModelLoader());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new AEAModelLoader(customModels));
        if (Integration.Mods.MEKANISMGAS.isEnabled()) {
            ModelLoaderRegistry.registerLoader((ICustomModelLoader)new GasItemModel.ModelLoader());
        }
    }

    public static void onBakeModels(ModelBakeEvent event) {
        defaultItemState = ModelUtil.loadModelState(new ResourceLocation("minecraft:models/item/generated"));
        defaultBlockState = ModelUtil.loadModelState(new ResourceLocation("minecraft:models/block/block"));
    }

    private static class BlockModeStateMapper
    extends StateMapperBase {
        private final BlockModelEntry index;

        public BlockModeStateMapper(BlockModelEntry index) {
            this.index = index;
        }

        protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
            return this.index.blockModelLocation;
        }
    }

    private static class ColoredBlockBlockColor
    implements IBlockColor {
        public static final ColoredBlockBlockColor INSTANCE = new ColoredBlockBlockColor();

        private ColoredBlockBlockColor() {
        }

        public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
            Block block = state.func_177230_c();
            if (block instanceof IColoredBlock && worldIn != null && pos != null) {
                return ((IColoredBlock)block).colorMultiplier(state, worldIn, pos, tintIndex);
            }
            return 0xFFFFFF;
        }
    }

    private static class ColoredItemItemColor
    implements IItemColor {
        public static final ColoredItemItemColor INSTANCE = new ColoredItemItemColor();

        private ColoredItemItemColor() {
        }

        public int func_186726_a(ItemStack stack, int tintIndex) {
            Item item = stack.func_77973_b();
            if (item instanceof IColoredItem) {
                return ((IColoredItem)item).getColorFromItemstack(stack, tintIndex);
            }
            return 0xFFFFFF;
        }
    }
}

