/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.me.storage;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import com.the9grounds.aeadditions.api.IAEAdditionsStorageCell;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 F*\u0010\b\u0000\u0010\u0001*\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001FB)\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010)\u001a\u00020\u001bH\u0016J\u001e\u0010*\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016J\b\u0010,\u001a\u00020\u001dH\u0016J\n\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u00020$H\u0016J\n\u00100\u001a\u0004\u0018\u000101H\u0016J\b\u00102\u001a\u000203H\u0016J\n\u00104\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u00105\u001a\u00020$H\u0016J\b\u00106\u001a\u00020$H\u0016J\b\u00107\u001a\u00020\u001dH\u0016J\b\u00108\u001a\u00020$H\u0016J\b\u00109\u001a\u00020$H\u0016J\b\u0010:\u001a\u00020$H\u0016J\b\u0010;\u001a\u00020$H\u0016J\b\u0010<\u001a\u00020\u001dH\u0016J\n\u0010=\u001a\u0004\u0018\u00010.H\u0016J\b\u0010>\u001a\u00020$H\u0016J\u001a\u0010?\u001a\u00020\u001b2\b\u0010@\u001a\u0004\u0018\u00010(2\u0006\u0010A\u001a\u00020$H$J\b\u0010B\u001a\u00020CH\u0014J\b\u0010D\u001a\u00020CH\u0016J\b\u0010E\u001a\u00020CH\u0014R$\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f8DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\"\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/the9grounds/aeadditions/me/storage/AbstractAEAdditionsInventory;", "T", "Lappeng/api/storage/data/IAEStack;", "Lappeng/api/storage/ICellInventory;", "cellType", "Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;", "o", "Lnet/minecraft/item/ItemStack;", "container", "Lappeng/api/storage/ISaveProvider;", "(Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;Lnet/minecraft/item/ItemStack;Lappeng/api/storage/ISaveProvider;)V", "cellItems", "Lappeng/api/storage/data/IItemList;", "getCellItems", "()Lappeng/api/storage/data/IItemList;", "setCellItems", "(Lappeng/api/storage/data/IItemList;)V", "getCellType", "()Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;", "setCellType", "(Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;)V", "getContainer", "()Lappeng/api/storage/ISaveProvider;", "setContainer", "(Lappeng/api/storage/ISaveProvider;)V", "i", "isPersisted", "", "itemsPerByte", "", "getItemsPerByte", "()I", "setItemsPerByte", "(I)V", "maxItemTypes", "storedItemCount", "", "storedItems", "", "tagCompound", "Lnet/minecraft/nbt/NBTTagCompound;", "canHoldNewItem", "getAvailableItems", "out", "getBytesPerType", "getConfigInventory", "Lnet/minecraftforge/items/IItemHandler;", "getFreeBytes", "getFuzzyMode", "Lappeng/api/config/FuzzyMode;", "getIdleDrain", "", "getItemStack", "getRemainingItemCount", "getRemainingItemTypes", "getStatusForCell", "getStoredItemCount", "getStoredItemTypes", "getTotalBytes", "getTotalItemTypes", "getUnusedItemCount", "getUpgradesInventory", "getUsedBytes", "loadCellItem", "compoundTag", "stackSize", "loadCellItems", "", "persist", "saveChanges", "Companion", "AEAdditions-1.12.2"})
public abstract class AbstractAEAdditionsInventory<T extends IAEStack<T>>
implements ICellInventory<T> {
    @Nullable
    private ISaveProvider container;
    private int maxItemTypes = 500;
    private short storedItems;
    private long storedItemCount;
    private ItemStack i;
    @Nullable
    private IAEAdditionsStorageCell<T> cellType;
    private int itemsPerByte;
    private boolean isPersisted = true;
    private NBTTagCompound tagCompound;
    @Nullable
    private IItemList<T> cellItems;
    private static final String ITEM_TYPE_TAG = "it";
    private static final String ITEM_COUNT_TAG = "ic";
    private static final String ITEM_SLOT = "#";
    private static final String ITEM_SLOT_COUNT = "@";
    @NotNull
    private static final String ITEM_PRE_FORMATTED_COUNT = "PF";
    @NotNull
    private static final String ITEM_PRE_FORMATTED_SLOT = "PF#";
    @NotNull
    private static final String ITEM_PRE_FORMATTED_NAME = "PN";
    @NotNull
    private static final String ITEM_PRE_FORMATTED_FUZZY = "FP";
    public static final Companion Companion = new Companion(null);

    @Nullable
    protected final ISaveProvider getContainer() {
        return this.container;
    }

    protected final void setContainer(@Nullable ISaveProvider iSaveProvider) {
        this.container = iSaveProvider;
    }

    @Nullable
    protected final IAEAdditionsStorageCell<T> getCellType() {
        return this.cellType;
    }

    protected final void setCellType(@Nullable IAEAdditionsStorageCell<T> iAEAdditionsStorageCell) {
        this.cellType = iAEAdditionsStorageCell;
    }

    protected final int getItemsPerByte() {
        return this.itemsPerByte;
    }

    protected final void setItemsPerByte(int n) {
        this.itemsPerByte = n;
    }

    @Nullable
    protected final IItemList<T> getCellItems() {
        if (this.cellItems == null) {
            this.cellItems = this.getChannel().createList();
            this.loadCellItems();
        }
        return this.cellItems;
    }

    protected final void setCellItems(@Nullable IItemList<T> iItemList) {
        this.cellItems = iItemList;
    }

    /*
     * WARNING - void declaration
     */
    public void persist() {
        if (this.isPersisted) {
            return;
        }
        long itemCount = 0L;
        int x = 0;
        IItemList<T> iItemList = this.getCellItems();
        if (iItemList == null) {
            Intrinsics.throwNpe();
        }
        Iterable $this$forEachIndexed$iv22 = (Iterable)iItemList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv22) {
            void element;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            IAEStack iAEStack = (IAEStack)item$iv;
            int index = n2;
            boolean bl2 = false;
            void v1 = element;
            if (v1 == null) {
                Intrinsics.throwNpe();
            }
            itemCount += v1.getStackSize();
            NBTTagCompound g = new NBTTagCompound();
            element.writeToNBT(g);
            NBTTagCompound nBTTagCompound = this.tagCompound;
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            nBTTagCompound.func_74782_a(ITEM_SLOT + index, (NBTBase)g);
            NBTTagCompound nBTTagCompound2 = this.tagCompound;
            if (nBTTagCompound2 == null) {
                Intrinsics.throwNpe();
            }
            nBTTagCompound2.func_74772_a(ITEM_SLOT_COUNT + index, element.getStackSize());
            x = index;
        }
        int $this$forEachIndexed$iv22 = x;
        x = $this$forEachIndexed$iv22 + 1;
        int oldStoredItems = this.storedItems;
        IItemList<T> iItemList2 = this.getCellItems();
        if (iItemList2 == null) {
            Intrinsics.throwNpe();
        }
        this.storedItems = (short)iItemList2.size();
        IItemList<T> iItemList3 = this.getCellItems();
        if (iItemList3 == null) {
            Intrinsics.throwNpe();
        }
        if (iItemList3.isEmpty()) {
            NBTTagCompound nBTTagCompound = this.tagCompound;
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            nBTTagCompound.func_82580_o(ITEM_TYPE_TAG);
        } else {
            NBTTagCompound nBTTagCompound = this.tagCompound;
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            nBTTagCompound.func_74777_a(ITEM_TYPE_TAG, this.storedItems);
        }
        this.storedItemCount = itemCount;
        if (itemCount == 0L) {
            NBTTagCompound nBTTagCompound = this.tagCompound;
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            nBTTagCompound.func_82580_o(ITEM_COUNT_TAG);
        } else {
            NBTTagCompound nBTTagCompound = this.tagCompound;
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            nBTTagCompound.func_74772_a(ITEM_COUNT_TAG, itemCount);
        }
        while (x < oldStoredItems && x < this.maxItemTypes) {
            NBTTagCompound nBTTagCompound = this.tagCompound;
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            nBTTagCompound.func_82580_o(ITEM_SLOT + x);
            NBTTagCompound nBTTagCompound3 = this.tagCompound;
            if (nBTTagCompound3 == null) {
                Intrinsics.throwNpe();
            }
            nBTTagCompound3.func_82580_o(ITEM_SLOT_COUNT + x);
            int n = x;
            x = n + 1;
        }
        this.isPersisted = true;
    }

    protected void saveChanges() {
        IItemList<T> iItemList = this.getCellItems();
        if (iItemList == null) {
            Intrinsics.throwNpe();
        }
        this.storedItems = (short)iItemList.size();
        this.storedItemCount = 0L;
        IItemList<T> iItemList2 = this.getCellItems();
        if (iItemList2 == null) {
            Intrinsics.throwNpe();
        }
        Iterator iterator = iItemList2.iterator();
        while (iterator.hasNext()) {
            IAEStack v;
            IAEStack iAEStack = v = (IAEStack)iterator.next();
            if (iAEStack == null) {
                Intrinsics.throwNpe();
            }
            this.storedItemCount += (long)((int)iAEStack.getStackSize());
        }
        this.isPersisted = false;
        if (this.container != null) {
            ISaveProvider iSaveProvider = this.container;
            if (iSaveProvider == null) {
                Intrinsics.throwNpe();
            }
            iSaveProvider.saveChanges((ICellInventory)this);
        } else {
            this.persist();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void loadCellItems() {
        if (this.getCellItems() == null) {
            this.cellItems = this.getChannel().createList();
        }
        IItemList<T> iItemList = this.getCellItems();
        if (iItemList == null) {
            Intrinsics.throwNpe();
        }
        iItemList.resetStatus();
        int types = (int)this.getStoredItemTypes();
        boolean needsUpdate = false;
        int n = 0;
        int n2 = types;
        while (n < n2) {
            long stackSize;
            void slot;
            NBTTagCompound nBTTagCompound = this.tagCompound;
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            NBTTagCompound compoundTag = nBTTagCompound.func_74775_l(ITEM_SLOT + (int)slot);
            NBTTagCompound nBTTagCompound2 = this.tagCompound;
            if (nBTTagCompound2 == null) {
                Intrinsics.throwNpe();
            }
            needsUpdate |= !this.loadCellItem(compoundTag, stackSize = nBTTagCompound2.func_74763_f(ITEM_SLOT_COUNT + (int)slot));
            ++slot;
        }
        if (needsUpdate) {
            this.saveChanges();
        }
    }

    protected abstract boolean loadCellItem(@Nullable NBTTagCompound var1, long var2);

    @Nullable
    public IItemList<T> getAvailableItems(@NotNull IItemList<T> out) {
        Intrinsics.checkParameterIsNotNull(out, (String)"out");
        IItemList<T> iItemList = this.getCellItems();
        if (iItemList == null) {
            Intrinsics.throwNpe();
        }
        for (IAEStack item : iItemList) {
            out.add(item);
        }
        return out;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.i;
    }

    public double getIdleDrain() {
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell = this.cellType;
        if (iAEAdditionsStorageCell == null) {
            Intrinsics.throwNpe();
        }
        return iAEAdditionsStorageCell.getIdleDrain();
    }

    @Nullable
    public FuzzyMode getFuzzyMode() {
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell = this.cellType;
        if (iAEAdditionsStorageCell == null) {
            Intrinsics.throwNpe();
        }
        return iAEAdditionsStorageCell.getFuzzyMode(this.i);
    }

    @Nullable
    public IItemHandler getConfigInventory() {
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell = this.cellType;
        if (iAEAdditionsStorageCell == null) {
            Intrinsics.throwNpe();
        }
        return iAEAdditionsStorageCell.getConfigInventory(this.i);
    }

    @Nullable
    public IItemHandler getUpgradesInventory() {
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell = this.cellType;
        if (iAEAdditionsStorageCell == null) {
            Intrinsics.throwNpe();
        }
        return iAEAdditionsStorageCell.getUpgradesInventory(this.i);
    }

    public int getBytesPerType() {
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell = this.cellType;
        if (iAEAdditionsStorageCell == null) {
            Intrinsics.throwNpe();
        }
        ItemStack itemStack = this.i;
        if (itemStack == null) {
            Intrinsics.throwNpe();
        }
        return iAEAdditionsStorageCell.getBytesPerType(itemStack);
    }

    public boolean canHoldNewItem() {
        long bytesFree = this.getFreeBytes();
        return (bytesFree > (long)this.getBytesPerType() || bytesFree == (long)this.getBytesPerType() && this.getUnusedItemCount() > 0) && this.getRemainingItemTypes() > 0L;
    }

    public long getTotalBytes() {
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell = this.cellType;
        if (iAEAdditionsStorageCell == null) {
            Intrinsics.throwNpe();
        }
        ItemStack itemStack = this.i;
        if (itemStack == null) {
            Intrinsics.throwNpe();
        }
        return iAEAdditionsStorageCell.getBytes(itemStack);
    }

    public long getFreeBytes() {
        return this.getTotalBytes() - this.getUsedBytes();
    }

    public long getTotalItemTypes() {
        return this.maxItemTypes;
    }

    public long getStoredItemCount() {
        return this.storedItemCount;
    }

    public long getStoredItemTypes() {
        return this.storedItems;
    }

    public long getRemainingItemTypes() {
        long baseOnTotal;
        long basedOnStorage = this.getFreeBytes() / (long)this.getBytesPerType();
        return basedOnStorage > (baseOnTotal = this.getTotalItemTypes() - this.getStoredItemTypes()) ? baseOnTotal : basedOnStorage;
    }

    public long getUsedBytes() {
        long bytesForItemCount = (this.getStoredItemCount() + (long)this.getUnusedItemCount()) / (long)this.itemsPerByte;
        return this.getStoredItemTypes() * (long)this.getBytesPerType() + bytesForItemCount;
    }

    public long getRemainingItemCount() {
        long remaining = this.getFreeBytes() * (long)this.itemsPerByte + (long)this.getUnusedItemCount();
        return remaining > 0L ? remaining : 0L;
    }

    public int getUnusedItemCount() {
        int div = (int)(this.getStoredItemCount() % (long)8);
        return div == 0 ? 0 : this.itemsPerByte - div;
    }

    public int getStatusForCell() {
        if (this.canHoldNewItem()) {
            return 1;
        }
        return this.getRemainingItemCount() > 0L ? 2 : 3;
    }

    public AbstractAEAdditionsInventory(@Nullable IAEAdditionsStorageCell<T> cellType, @Nullable ItemStack o, @Nullable ISaveProvider container) {
        this.i = o;
        this.cellType = cellType;
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell = this.cellType;
        if (iAEAdditionsStorageCell == null) {
            Intrinsics.throwNpe();
        }
        this.itemsPerByte = iAEAdditionsStorageCell.getChannel().getUnitsPerByte();
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell2 = this.cellType;
        if (iAEAdditionsStorageCell2 == null) {
            Intrinsics.throwNpe();
        }
        ItemStack itemStack = this.i;
        if (itemStack == null) {
            Intrinsics.throwNpe();
        }
        this.maxItemTypes = iAEAdditionsStorageCell2.getTotalTypes(itemStack);
        if (this.maxItemTypes < 1) {
            this.maxItemTypes = 1;
        }
        this.container = container;
        NBTTagCompound nBTTagCompound = this.tagCompound = Platform.openNbtData((ItemStack)o);
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        this.storedItems = nBTTagCompound.func_74765_d(ITEM_TYPE_TAG);
        NBTTagCompound nBTTagCompound2 = this.tagCompound;
        if (nBTTagCompound2 == null) {
            Intrinsics.throwNpe();
        }
        this.storedItemCount = nBTTagCompound2.func_74763_f(ITEM_COUNT_TAG);
        this.cellItems = null;
    }

    static {
        ITEM_TYPE_TAG = ITEM_TYPE_TAG;
        ITEM_COUNT_TAG = ITEM_COUNT_TAG;
        ITEM_SLOT = ITEM_SLOT;
        ITEM_SLOT_COUNT = ITEM_SLOT_COUNT;
        ITEM_PRE_FORMATTED_COUNT = ITEM_PRE_FORMATTED_COUNT;
        ITEM_PRE_FORMATTED_SLOT = ITEM_PRE_FORMATTED_SLOT;
        ITEM_PRE_FORMATTED_NAME = ITEM_PRE_FORMATTED_NAME;
        ITEM_PRE_FORMATTED_FUZZY = ITEM_PRE_FORMATTED_FUZZY;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/the9grounds/aeadditions/me/storage/AbstractAEAdditionsInventory$Companion;", "", "()V", "ITEM_COUNT_TAG", "", "ITEM_PRE_FORMATTED_COUNT", "getITEM_PRE_FORMATTED_COUNT", "()Ljava/lang/String;", "ITEM_PRE_FORMATTED_FUZZY", "getITEM_PRE_FORMATTED_FUZZY", "ITEM_PRE_FORMATTED_NAME", "getITEM_PRE_FORMATTED_NAME", "ITEM_PRE_FORMATTED_SLOT", "getITEM_PRE_FORMATTED_SLOT", "ITEM_SLOT", "ITEM_SLOT_COUNT", "ITEM_TYPE_TAG", "AEAdditions-1.12.2"})
    public static final class Companion {
        @NotNull
        protected final String getITEM_PRE_FORMATTED_COUNT() {
            return ITEM_PRE_FORMATTED_COUNT;
        }

        @NotNull
        protected final String getITEM_PRE_FORMATTED_SLOT() {
            return ITEM_PRE_FORMATTED_SLOT;
        }

        @NotNull
        protected final String getITEM_PRE_FORMATTED_NAME() {
            return ITEM_PRE_FORMATTED_NAME;
        }

        @NotNull
        protected final String getITEM_PRE_FORMATTED_FUZZY() {
            return ITEM_PRE_FORMATTED_FUZZY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

