/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.me.storage;

import appeng.api.config.Actionable;
import appeng.api.exceptions.AppEngException;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AEConfig;
import appeng.core.AELog;
import com.the9grounds.aeadditions.api.IAEAdditionsStorageCell;
import com.the9grounds.aeadditions.me.storage.AbstractAEAdditionsInventory;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u001d*\u0010\b\u0000\u0010\u0001*\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001dB%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ-\u0010\r\u001a\u0004\u0018\u00018\u00002\b\u0010\u000e\u001a\u0004\u0018\u00018\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\fH\u0016J+\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00028\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/the9grounds/aeadditions/me/storage/AEAdditionsCellInventory;", "T", "Lappeng/api/storage/data/IAEStack;", "Lcom/the9grounds/aeadditions/me/storage/AbstractAEAdditionsInventory;", "cellType", "Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;", "itemStack", "Lnet/minecraft/item/ItemStack;", "container", "Lappeng/api/storage/ISaveProvider;", "(Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;Lnet/minecraft/item/ItemStack;Lappeng/api/storage/ISaveProvider;)V", "channel", "Lappeng/api/storage/IStorageChannel;", "extractItems", "request", "mode", "Lappeng/api/config/Actionable;", "src", "Lappeng/api/networking/security/IActionSource;", "(Lappeng/api/storage/data/IAEStack;Lappeng/api/config/Actionable;Lappeng/api/networking/security/IActionSource;)Lappeng/api/storage/data/IAEStack;", "getChannel", "injectItems", "input", "loadCellItem", "", "compoundTag", "Lnet/minecraft/nbt/NBTTagCompound;", "stackSize", "", "Companion", "AEAdditions-1.12.2"})
public final class AEAdditionsCellInventory<T extends IAEStack<T>>
extends AbstractAEAdditionsInventory<T> {
    private IStorageChannel<T> channel;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public T injectItems(T input, @Nullable Actionable mode, @Nullable IActionSource src) {
        long remainingItemCount;
        IAEStack l;
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell = this.getCellType();
        if (iAEAdditionsStorageCell == null) {
            Intrinsics.throwNpe();
        }
        ItemStack itemStack = this.getItemStack();
        if (itemStack == null) {
            Intrinsics.throwNpe();
        }
        if (iAEAdditionsStorageCell.isBlackListed(itemStack, input)) {
            return input;
        }
        IItemList iItemList = this.getCellItems();
        if (iItemList == null) {
            Intrinsics.throwNpe();
        }
        if ((l = iItemList.findPrecise(input)) != null) {
            IAEStack iAEStack;
            long remainingItemCount2 = this.getRemainingItemCount();
            if (remainingItemCount2 <= 0L) {
                return input;
            }
            if (input.getStackSize() > remainingItemCount2) {
                IAEStack r;
                IAEStack iAEStack2 = r = input.copy();
                if (iAEStack2 == null) {
                    Intrinsics.throwNpe();
                }
                iAEStack2.setStackSize(r.getStackSize() - remainingItemCount2);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() + remainingItemCount2);
                    this.saveChanges();
                }
                iAEStack = r;
            } else {
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() + input.getStackSize());
                    this.saveChanges();
                }
                iAEStack = null;
            }
            return (T)iAEStack;
        }
        if (this.canHoldNewItem() && (remainingItemCount = this.getRemainingItemCount() - (long)(this.getBytesPerType() * this.getItemsPerByte())) > 0L) {
            if (input.getStackSize() > remainingItemCount) {
                IAEStack toReturn;
                IAEStack iAEStack = toReturn = input.copy();
                if (iAEStack == null) {
                    Intrinsics.throwNpe();
                }
                iAEStack.setStackSize(input.getStackSize() - remainingItemCount);
                if (mode == Actionable.MODULATE) {
                    IAEStack toWrite;
                    IAEStack iAEStack3 = toWrite = input.copy();
                    if (iAEStack3 == null) {
                        Intrinsics.throwNpe();
                    }
                    iAEStack3.setStackSize(remainingItemCount);
                    IItemList iItemList2 = this.getCellItems();
                    if (iItemList2 == null) {
                        Intrinsics.throwNpe();
                    }
                    iItemList2.add(toWrite);
                    this.saveChanges();
                }
                return (T)toReturn;
            }
            if (mode == Actionable.MODULATE) {
                IAEStack copy = input.copy();
                IItemList iItemList3 = this.getCellItems();
                if (iItemList3 == null) {
                    Intrinsics.throwNpe();
                }
                iItemList3.add(copy);
                this.saveChanges();
            }
            return null;
        }
        return input;
    }

    @Nullable
    public T extractItems(@Nullable T request, @Nullable Actionable mode, @Nullable IActionSource src) {
        IAEStack l;
        if (request == null) {
            return null;
        }
        long size = Math.min((long)Integer.MAX_VALUE, request.getStackSize());
        IAEStack Results = null;
        IItemList iItemList = this.getCellItems();
        if (iItemList == null) {
            Intrinsics.throwNpe();
        }
        if ((l = iItemList.findPrecise(request)) != null) {
            Results = l.copy();
            if (l.getStackSize() <= size) {
                IAEStack iAEStack = Results;
                if (iAEStack == null) {
                    Intrinsics.throwNpe();
                }
                iAEStack.setStackSize(l.getStackSize());
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(0L);
                    this.saveChanges();
                }
            } else {
                IAEStack iAEStack = Results;
                if (iAEStack == null) {
                    Intrinsics.throwNpe();
                }
                iAEStack.setStackSize(size);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() - size);
                    this.saveChanges();
                }
            }
        }
        return (T)Results;
    }

    @Nullable
    public IStorageChannel<T> getChannel() {
        return this.channel;
    }

    @Override
    protected boolean loadCellItem(@Nullable NBTTagCompound compoundTag, long stackSize) {
        IAEStack t = null;
        try {
            IStorageChannel<T> iStorageChannel = this.getChannel();
            if (iStorageChannel == null) {
                Intrinsics.throwNpe();
            }
            NBTTagCompound nBTTagCompound = compoundTag;
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            if ((t = iStorageChannel.createFromNBT(nBTTagCompound)) == null) {
                AELog.warn((String)("Removing item " + compoundTag + " from storage cell because the associated item type couldn't be found."), (Object[])new Object[0]);
                return false;
            }
        }
        catch (Throwable ex) {
            AEConfig aEConfig = AEConfig.instance();
            Intrinsics.checkExpressionValueIsNotNull((Object)aEConfig, (String)"AEConfig.instance()");
            if (aEConfig.isRemoveCrashingItemsOnLoad()) {
                AELog.warn((Throwable)ex, (String)("Removing item " + compoundTag + " from storage cell because loading the ItemStack crashed."));
                return false;
            }
            throw ex;
        }
        t.setStackSize(stackSize);
        if (stackSize > 0L) {
            IItemList iItemList = this.getCellItems();
            if (iItemList == null) {
                Intrinsics.throwNpe();
            }
            iItemList.add(t);
        }
        return true;
    }

    public AEAdditionsCellInventory(@NotNull IAEAdditionsStorageCell<T> cellType, @NotNull ItemStack itemStack, @Nullable ISaveProvider container) {
        Intrinsics.checkParameterIsNotNull(cellType, (String)"cellType");
        Intrinsics.checkParameterIsNotNull((Object)itemStack, (String)"itemStack");
        super(cellType, itemStack, container);
        this.channel = cellType.getChannel();
    }

    @JvmStatic
    @Nullable
    public static final <T extends IAEStack<T>> ICellInventory<T> createInventory(@Nullable ItemStack itemStack, @Nullable ISaveProvider container) {
        return Companion.createInventory(itemStack, container);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u0004\"\u0010\b\u0001\u0010\u0005*\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0018\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\u000f"}, d2={"Lcom/the9grounds/aeadditions/me/storage/AEAdditionsCellInventory$Companion;", "", "()V", "createInventory", "Lappeng/api/storage/ICellInventory;", "T", "Lappeng/api/storage/data/IAEStack;", "itemStack", "Lnet/minecraft/item/ItemStack;", "container", "Lappeng/api/storage/ISaveProvider;", "getStorageCell", "Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;", "isCell", "", "AEAdditions-1.12.2"})
    public static final class Companion {
        public final boolean isCell(@Nullable ItemStack itemStack) {
            return this.getStorageCell(itemStack) != null;
        }

        private final IAEAdditionsStorageCell<?> getStorageCell(ItemStack itemStack) {
            Item type;
            if (itemStack != null && (type = itemStack.func_77973_b()) instanceof IAEAdditionsStorageCell) {
                return (IAEAdditionsStorageCell)type;
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final <T extends IAEStack<T>> ICellInventory<T> createInventory(@Nullable ItemStack itemStack, @Nullable ISaveProvider container) {
            try {
                if (itemStack == null) {
                    throw (Throwable)new AppEngException("ItemStack was used as a cell, but was not a cell!");
                }
                Item type = itemStack.func_77973_b();
                IAEAdditionsStorageCell cellType = null;
                if (!(type instanceof IAEAdditionsStorageCell)) {
                    throw (Throwable)new AppEngException("ItemStack was used as a cell, but was not a cell!");
                }
                cellType = (IAEAdditionsStorageCell)type;
                if (!cellType.isStorageCell(itemStack)) {
                    throw (Throwable)new AppEngException("ItemStack was used as a cell, but was not a cell");
                }
                return new AEAdditionsCellInventory(cellType, itemStack, container);
            }
            catch (AppEngException e) {
                AELog.error((Throwable)e);
                return null;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

