/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.item;

import com.the9grounds.aeadditions.integration.Integration;
import com.the9grounds.aeadditions.models.IItemModelRegister;
import com.the9grounds.aeadditions.models.ModelManager;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0003J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0017J\u0016\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0003J\u001c\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0017J\u001a\u0010\u001a\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\bH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lcom/the9grounds/aeadditions/item/ItemGas;", "Lnet/minecraft/item/Item;", "Lcom/the9grounds/aeadditions/models/IItemModelRegister;", "()V", "isMekanismGasEnabled", "", "()Z", "getGasName", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "getItemStackDisplayName", "stack", "getItemStackDisplayNameGas", "getSubItems", "", "tab", "Lnet/minecraft/creativetab/CreativeTabs;", "items", "Lnet/minecraft/util/NonNullList;", "getSubItemsGas", "subItems", "registerModel", "item", "manager", "Lcom/the9grounds/aeadditions/models/ModelManager;", "setGasName", "fluidName", "AEAdditions-1.12.2"})
public final class ItemGas
extends Item
implements IItemModelRegister {
    private static final boolean isMekanismGasEnabled;
    public static final ItemGas INSTANCE;

    public final boolean isMekanismGasEnabled() {
        return isMekanismGasEnabled;
    }

    @JvmStatic
    public static final void setGasName(@Nullable ItemStack itemStack, @NotNull String fluidName) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)fluidName, (String)"fluidName");
            ItemStack itemStack2 = itemStack;
            if (itemStack2 == null) break block0;
            itemStack2.func_77983_a("gas", (NBTBase)new NBTTagString(fluidName));
        }
    }

    @JvmStatic
    @NotNull
    public static final String getGasName(@Nullable ItemStack itemStack) {
        if (itemStack == null || !itemStack.func_77942_o() || itemStack.func_77978_p() == null) {
            return "";
        }
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        String string = nBTTagCompound.func_74779_i("gas");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"itemStack.tagCompound!!.getString(\"gas\")");
        return string;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(@Nullable Item item, @Nullable ModelManager manager) {
        block0: {
            ModelManager modelManager = manager;
            if (modelManager == null) break block0;
            modelManager.registerItemModel(item, new ItemMeshDefinition(){

                @NotNull
                public ModelResourceLocation func_178113_a(@NotNull ItemStack stack) {
                    Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                    if (ItemGas.INSTANCE.isMekanismGasEnabled()) {
                        return new ModelResourceLocation("aeadditions:gas/" + ItemGas.getGasName(stack), "inventory");
                    }
                    return new ModelResourceLocation("aeadditions:fluid/water", "inventory");
                }
            });
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@NotNull CreativeTabs tab, @NotNull NonNullList<ItemStack> items) {
        Intrinsics.checkParameterIsNotNull((Object)tab, (String)"tab");
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        if (!this.func_194125_a(tab)) {
            return;
        }
        if (isMekanismGasEnabled) {
            this.getSubItemsGas(items);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="MekanismAPI|gas")
    private final void getSubItemsGas(NonNullList<ItemStack> subItems) {
        for (Gas gas : GasRegistry.getRegisteredGasses()) {
            ItemStack itemStack = new ItemStack((Item)this);
            Gas gas2 = gas;
            Intrinsics.checkExpressionValueIsNotNull((Object)gas2, (String)"gas");
            String string = gas2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gas.name");
            ItemGas.setGasName(itemStack, string);
            subItems.add((Object)itemStack);
        }
    }

    @NotNull
    public String func_77653_i(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (isMekanismGasEnabled) {
            return this.getItemStackDisplayNameGas(stack);
        }
        return "null";
    }

    @Optional.Method(modid="MekanismAPI|gas")
    private final String getItemStackDisplayNameGas(ItemStack stack) {
        String gasName = ItemGas.getGasName(stack);
        CharSequence charSequence = gasName;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return "null";
        }
        Gas gas = GasRegistry.getGas((String)gasName);
        if (gas != null) {
            String string = gas.getLocalizedName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gas.localizedName");
            return string;
        }
        return "null";
    }

    private ItemGas() {
    }

    static {
        ItemGas itemGas;
        INSTANCE = itemGas = new ItemGas();
        isMekanismGasEnabled = Integration.Mods.MEKANISMGAS.isEnabled();
    }
}

