/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.integration.opencomputers;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.features.ILocatable;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.WorldCoord;
import com.the9grounds.aeadditions.integration.opencomputers.WirelessHandlerUpgradeAE;
import com.the9grounds.aeadditions.registries.ItemEnum;
import com.the9grounds.aeadditions.util.FluidHelper;
import com.the9grounds.aeadditions.util.MachineSource;
import com.the9grounds.aeadditions.util.StorageChannels;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import li.cil.oc.api.internal.Agent;
import li.cil.oc.api.internal.Database;
import li.cil.oc.api.internal.Drone;
import li.cil.oc.api.internal.MultiTank;
import li.cil.oc.api.internal.Robot;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.Connector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\u0010\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u0003*\u00020\u00042\u00020\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\"\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$J\b\u0010&\u001a\u0004\u0018\u00010'J\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010$J\b\u0010*\u001a\u0004\u0018\u00010\u0004J\b\u0010+\u001a\u00020,H&J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0007J\u0012\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u000107H\u0016J\u001e\u00108\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0007J\u001e\u00109\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0007J\u001e\u0010:\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0007J\u001e\u0010;\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0007J\r\u0010<\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010=J\b\u0010>\u001a\u000205H\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006?"}, d2={"Lcom/the9grounds/aeadditions/integration/opencomputers/NetworkControl;", "T", "Lnet/minecraft/tileentity/TileEntity;", "Lappeng/api/networking/security/IActionHost;", "Lappeng/api/networking/IGridHost;", "Lli/cil/oc/api/prefab/AbstractManagedEnvironment;", "()V", "agent", "Lli/cil/oc/api/internal/Agent;", "getAgent", "()Lli/cil/oc/api/internal/Agent;", "drone", "Lli/cil/oc/api/internal/Drone;", "getDrone", "()Lli/cil/oc/api/internal/Drone;", "energy", "", "getEnergy", "()D", "isActive", "", "()Z", "setActive", "(Z)V", "robot", "Lli/cil/oc/api/internal/Robot;", "getRobot", "()Lli/cil/oc/api/internal/Robot;", "checkRange", "itemStack", "Lnet/minecraft/item/ItemStack;", "security", "getAEKey", "", "getComponent", "getFluidInventory", "Lappeng/api/storage/IMEMonitor;", "Lappeng/api/storage/data/IAEFluidStack;", "getGrid", "Lappeng/api/networking/IGrid;", "getItemInventory", "Lappeng/api/storage/data/IAEItemStack;", "getSecurity", "host", "Lli/cil/oc/api/network/EnvironmentHost;", "isLinked", "", "", "context", "Lli/cil/oc/api/machine/Context;", "args", "Lli/cil/oc/api/machine/Arguments;", "onMessage", "", "message", "Lli/cil/oc/api/network/Message;", "requestFluids", "requestItems", "sendFluids", "sendItems", "tile", "()Lnet/minecraft/tileentity/TileEntity;", "update", "AEAdditions-1.12.2"})
public abstract class NetworkControl<T extends TileEntity & IGridHost>
extends AbstractManagedEnvironment {
    private boolean isActive;

    @NotNull
    public abstract T tile();

    @NotNull
    public abstract EnvironmentHost host();

    @Nullable
    public final Robot getRobot() {
        EnvironmentHost environmentHost = this.host();
        if (!(environmentHost instanceof Robot)) {
            environmentHost = null;
        }
        return (Robot)environmentHost;
    }

    @Nullable
    public final Drone getDrone() {
        EnvironmentHost environmentHost = this.host();
        if (!(environmentHost instanceof Drone)) {
            environmentHost = null;
        }
        return (Drone)environmentHost;
    }

    @Nullable
    public final Agent getAgent() {
        EnvironmentHost environmentHost = this.host();
        if (!(environmentHost instanceof Agent)) {
            environmentHost = null;
        }
        return (Agent)environmentHost;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public final void setActive(boolean bl) {
        this.isActive = bl;
    }

    @Nullable
    public final ItemStack getComponent() {
        if (this.getRobot() != null) {
            Robot robot = this.getRobot();
            if (robot == null) {
                Intrinsics.throwNpe();
            }
            Robot robot2 = this.getRobot();
            if (robot2 == null) {
                Intrinsics.throwNpe();
            }
            return robot.func_70301_a(robot2.componentSlot(this.node().address()));
        }
        if (this.getDrone() != null) {
            Drone drone = this.getDrone();
            if (drone == null) {
                Intrinsics.throwNpe();
            }
            for (ItemStack item : drone.internalComponents()) {
                if (item == null || !Intrinsics.areEqual((Object)item.func_77973_b(), (Object)ItemEnum.OCUPGRADE.getItem())) continue;
                return item;
            }
        }
        return null;
    }

    @Nullable
    public final IGridHost getSecurity() {
        if (this.host().world().field_72995_K) {
            return null;
        }
        ItemStack itemStack = this.getComponent();
        if (itemStack == null) {
            return null;
        }
        ItemStack component = itemStack;
        ILocatable iLocatable = AEApi.instance().registries().locatable().getLocatableBy(this.getAEKey(component));
        if (iLocatable == null) {
            throw new TypeCastException("null cannot be cast to non-null type appeng.api.networking.IGridHost");
        }
        IGridHost security = (IGridHost)iLocatable;
        if (this.checkRange(component, security)) {
            return security;
        }
        return null;
    }

    public final boolean checkRange(@Nullable ItemStack itemStack, @Nullable IGridHost security) {
        Class clazz;
        if (itemStack == null || security == null) {
            return false;
        }
        IGridNode iGridNode = security.getGridNode(AEPartLocation.INTERNAL);
        if (iGridNode == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)iGridNode, (String)"security.getGridNode(AEP\u2026INTERNAL) ?: return false");
        IGridNode gridNode = iGridNode;
        IGrid iGrid = gridNode.getGrid();
        if (iGrid == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)iGrid, (String)"gridNode.grid ?: return false");
        IGrid grid = iGrid;
        switch (itemStack.func_77952_i()) {
            case 0: {
                Class wirelessAccessPoint;
                clazz = wirelessAccessPoint = (Class)AEApi.instance().definitions().blocks().wirelessAccessPoint().maybeEntity().get();
                if (clazz != null) break;
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out appeng.api.networking.IGridHost>");
            }
            case 1: {
                Class accessPoints;
                IGridBlock iGridBlock = gridNode.getGridBlock();
                if (iGridBlock == null) {
                    return false;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)iGridBlock, (String)"gridNode.gridBlock ?: return false");
                IGridBlock gridBlock = iGridBlock;
                DimensionalCoord dimensionalCoord = gridBlock.getLocation();
                if (dimensionalCoord == null) {
                    return false;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)dimensionalCoord, (String)"gridBlock.location ?: return false");
                DimensionalCoord location = dimensionalCoord;
                Class clazz2 = accessPoints = (Class)AEApi.instance().definitions().blocks().wirelessAccessPoint().maybeEntity().get();
                if (clazz2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out appeng.api.networking.IGridHost>");
                }
                Iterator iterator = grid.getMachines(clazz2).iterator();
                while (iterator.hasNext()) {
                    IGridNode node;
                    IGridNode iGridNode2 = node = (IGridNode)iterator.next();
                    if (iGridNode2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type appeng.api.implementations.tiles.IWirelessAccessPoint");
                    }
                    IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)iGridNode2;
                    DimensionalCoord dimensionalCoord2 = accessPoint.getLocation();
                    Agent agent = this.getAgent();
                    if (agent == null) {
                        Intrinsics.throwNpe();
                    }
                    int n = (int)agent.xPosition();
                    Agent agent2 = this.getAgent();
                    if (agent2 == null) {
                        Intrinsics.throwNpe();
                    }
                    int n2 = (int)agent2.yPosition();
                    Agent agent3 = this.getAgent();
                    if (agent3 == null) {
                        Intrinsics.throwNpe();
                    }
                    WorldCoord distance = dimensionalCoord2.subtract(n, n2, (int)agent3.zPosition());
                    int squaredDistance = distance.x * distance.x + distance.y * distance.y + distance.z * distance.z;
                    double range = accessPoint.getRange();
                    if (!((double)squaredDistance <= range * range)) continue;
                    return true;
                }
                return false;
            }
            default: {
                Class accessPoints;
                IGridBlock iGridBlock = gridNode.getGridBlock();
                if (iGridBlock == null) {
                    return false;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)iGridBlock, (String)"gridNode.gridBlock ?: return false");
                IGridBlock gridBlock = iGridBlock;
                DimensionalCoord dimensionalCoord = gridBlock.getLocation();
                if (dimensionalCoord == null) {
                    return false;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)dimensionalCoord, (String)"gridBlock.location ?: return false");
                DimensionalCoord location = dimensionalCoord;
                Class clazz3 = accessPoints = (Class)AEApi.instance().definitions().blocks().wirelessAccessPoint().maybeEntity().get();
                if (clazz3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out appeng.api.networking.IGridHost>");
                }
                Iterator iterator = grid.getMachines(clazz3).iterator();
                while (iterator.hasNext()) {
                    IGridNode node;
                    IGridNode iGridNode3 = node = (IGridNode)iterator.next();
                    if (iGridNode3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type appeng.api.implementations.tiles.IWirelessAccessPoint");
                    }
                    IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)iGridNode3;
                    DimensionalCoord dimensionalCoord3 = accessPoint.getLocation();
                    Agent agent = this.getAgent();
                    if (agent == null) {
                        Intrinsics.throwNpe();
                    }
                    int n = (int)agent.xPosition();
                    Agent agent4 = this.getAgent();
                    if (agent4 == null) {
                        Intrinsics.throwNpe();
                    }
                    int n3 = (int)agent4.yPosition();
                    Agent agent5 = this.getAgent();
                    if (agent5 == null) {
                        Intrinsics.throwNpe();
                    }
                    WorldCoord distance = dimensionalCoord3.subtract(n, n3, (int)agent5.zPosition());
                    int squaredDistance = distance.x * distance.x + distance.y * distance.y + distance.z * distance.z;
                    double range = accessPoint.getRange() / (double)2;
                    if (!((double)squaredDistance <= range * range)) continue;
                    return true;
                }
                return false;
            }
        }
        return grid.getMachines(clazz).iterator().hasNext();
    }

    @Nullable
    public final IGrid getGrid() {
        if (this.host().world().field_72995_K) {
            return null;
        }
        IGridHost iGridHost = this.getSecurity();
        return iGridHost != null && (iGridHost = iGridHost.getGridNode(AEPartLocation.INTERNAL)) != null ? iGridHost.getGrid() : null;
    }

    public final long getAEKey(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull((Object)itemStack, (String)"itemStack");
        try {
            String string = WirelessHandlerUpgradeAE.INSTANCE.getEncryptionKey(itemStack);
            boolean bl = false;
            return Long.parseLong(string);
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    @Nullable
    public final IMEMonitor<IAEFluidStack> getFluidInventory() {
        IGrid iGrid = this.getGrid();
        return iGrid != null && (iGrid = (IStorageGrid)iGrid.getCache(IStorageGrid.class)) != null ? iGrid.getInventory((IStorageChannel)StorageChannels.FLUID) : null;
    }

    @Nullable
    public final IMEMonitor<IAEItemStack> getItemInventory() {
        IGrid iGrid = this.getGrid();
        return iGrid != null && (iGrid = (IStorageGrid)iGrid.getCache(IStorageGrid.class)) != null ? iGrid.getInventory((IStorageChannel)StorageChannels.ITEM) : null;
    }

    @Callback(doc="function([number:amount]):number -- Transfer selected items to your ae system.")
    @NotNull
    public final List<Object> sendItems(@NotNull Context context, @NotNull Arguments args) {
        ItemStack itemStack2;
        IInventory invRobot;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Agent agent = this.getAgent();
        if (agent == null) {
            Intrinsics.throwNpe();
        }
        int selected = agent.selectedSlot();
        Agent agent2 = this.getAgent();
        if (agent2 == null) {
            Intrinsics.throwNpe();
        }
        IInventory iInventory = invRobot = agent2.mainInventory();
        Intrinsics.checkExpressionValueIsNotNull((Object)iInventory, (String)"invRobot");
        if (iInventory.func_70302_i_() <= 0) {
            return CollectionsKt.listOf((Object)0);
        }
        ItemStack itemStack = invRobot.func_70301_a(selected);
        IMEMonitor<IAEItemStack> inventory2 = this.getItemInventory();
        if (itemStack == null || itemStack.func_190926_b() || inventory2 == null) {
            return CollectionsKt.listOf((Object)0);
        }
        int n = args.optInteger(0, 64);
        int n2 = itemStack.func_190916_E();
        boolean bl = false;
        int amount = Math.min(n, n2);
        ItemStack itemStack3 = itemStack2 = itemStack.func_77946_l();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"itemStack2");
        itemStack3.func_190920_e(amount);
        IAEItemStack notInjected = (IAEItemStack)inventory2.injectItems(StorageChannels.ITEM.createStack((Object)itemStack2), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this.tile()));
        if (notInjected == null) {
            itemStack.func_190920_e(itemStack.func_190916_E() - amount);
            if (itemStack.func_190916_E() <= 0) {
                invRobot.func_70299_a(selected, ItemStack.field_190927_a);
            } else {
                invRobot.func_70299_a(selected, itemStack);
            }
            return CollectionsKt.listOf((Object)amount);
        }
        itemStack.func_190920_e(itemStack.func_190916_E() - amount + (int)notInjected.getStackSize());
        if (itemStack.func_190916_E() <= 0) {
            invRobot.func_70299_a(selected, ItemStack.field_190927_a);
        } else {
            invRobot.func_70299_a(selected, itemStack);
        }
        return CollectionsKt.listOf((Object)((long)itemStack2.func_190916_E() - notInjected.getStackSize()));
    }

    @Callback(doc="function(database:address, entry:number[, number:amount]):number -- Get items from your ae system.")
    @NotNull
    public final List<Object> requestItems(@NotNull Context context, @NotNull Arguments args) {
        ItemStack selected2;
        ItemStack itemStack;
        ItemStack itemStack2;
        ItemStack robotSelected;
        IInventory invRobot;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        String address = args.checkString(0);
        int entry = args.checkInteger(1);
        int amount = args.optInteger(2, 64);
        Agent agent = this.getAgent();
        if (agent == null) {
            Intrinsics.throwNpe();
        }
        int selected = agent.selectedSlot();
        Agent agent2 = this.getAgent();
        if (agent2 == null) {
            Intrinsics.throwNpe();
        }
        IInventory iInventory = invRobot = agent2.mainInventory();
        Intrinsics.checkExpressionValueIsNotNull((Object)iInventory, (String)"invRobot");
        if (iInventory.func_70302_i_() <= 0) {
            return CollectionsKt.listOf((Object)0);
        }
        IMEMonitor<IAEItemStack> iMEMonitor = this.getItemInventory();
        if (iMEMonitor == null) {
            return CollectionsKt.listOf((Object)0);
        }
        IMEMonitor<IAEItemStack> inventory2 = iMEMonitor;
        Node node = this.node().network().node(address);
        if (node == null) {
            throw (Throwable)new IllegalArgumentException("no such component");
        }
        Node node2 = node;
        if (!(node2 instanceof Component)) {
            throw (Throwable)new IllegalArgumentException("no such component");
        }
        Environment environment = node2.host();
        if (!(environment instanceof Database)) {
            throw (Throwable)new IllegalArgumentException("not a database");
        }
        ItemStack itemStack3 = robotSelected = invRobot.func_70301_a(selected);
        int inSlot = itemStack3 != null ? itemStack3.func_190916_E() : 0;
        ItemStack itemStack4 = robotSelected;
        int maxSize = itemStack4 != null ? itemStack4.func_77976_d() : 64;
        ItemStack itemStack5 = ((Database)environment).getStackInSlot(entry - 1);
        if (itemStack5 == null) {
            return CollectionsKt.listOf((Object)0);
        }
        ItemStack itemStack6 = itemStack5;
        int n = maxSize - inSlot;
        ItemStack itemStack7 = itemStack6;
        boolean bl = false;
        int n2 = Math.min(amount, n);
        itemStack7.func_190920_e(n2);
        ItemStack itemStack8 = itemStack2 = itemStack6.func_77946_l();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack8, (String)"itemStack2");
        itemStack8.func_190920_e(1);
        if (robotSelected != null) {
            ItemStack selected3;
            ItemStack itemStack9 = selected3 = robotSelected.func_77946_l();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack9, (String)"selected3");
            itemStack9.func_190920_e(1);
            itemStack = selected3;
        } else {
            itemStack = selected2 = null;
        }
        if (robotSelected != null && !ItemStack.func_77989_b(selected2, (ItemStack)itemStack2)) {
            ItemStack itemStack10 = selected2;
            if (itemStack10 == null) {
                Intrinsics.throwNpe();
            }
            if (!itemStack10.func_190926_b()) {
                return CollectionsKt.listOf((Object)0);
            }
        }
        IAEItemStack iAEItemStack = (IAEItemStack)inventory2.extractItems(StorageChannels.ITEM.createStack((Object)itemStack6), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this.tile()));
        if (iAEItemStack == null) {
            return CollectionsKt.listOf((Object)0);
        }
        IAEItemStack extracted = iAEItemStack;
        int stackSize = (int)extracted.getStackSize();
        itemStack6.func_190920_e(inSlot + stackSize);
        invRobot.func_70299_a(selected, itemStack6);
        return CollectionsKt.listOf((Object)stackSize);
    }

    @Callback(doc="function([number:amount]):number -- Transfer selected fluid to your ae system.")
    @NotNull
    public final List<Object> sendFluids(@NotNull Context context, @NotNull Arguments args) {
        MultiTank tanks;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Agent agent = this.getAgent();
        if (agent == null) {
            Intrinsics.throwNpe();
        }
        int selected = agent.selectedTank();
        Agent agent2 = this.getAgent();
        if (agent2 == null) {
            Intrinsics.throwNpe();
        }
        if ((tanks = agent2.tank()).tankCount() <= 0) {
            return CollectionsKt.listOf((Object)0);
        }
        IFluidTank tank2 = tanks.getFluidTank(selected);
        IMEMonitor<IAEFluidStack> inventory2 = this.getFluidInventory();
        IFluidTank iFluidTank = tank2;
        Intrinsics.checkExpressionValueIsNotNull((Object)iFluidTank, (String)"tank");
        FluidStack fluid = iFluidTank.getFluid();
        if (inventory2 == null || fluid == null) {
            return CollectionsKt.listOf((Object)0);
        }
        int n = args.optInteger(0, tank2.getCapacity());
        int n2 = tank2.getFluidAmount();
        boolean bl = false;
        int amount = Math.min(n, n2);
        FluidStack fluid2 = fluid.copy();
        fluid2.amount = amount;
        IAEFluidStack notInjected = (IAEFluidStack)inventory2.injectItems(StorageChannels.FLUID.createStack((Object)fluid2), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this.tile()));
        if (notInjected == null) {
            tank2.drain(amount, true);
            return CollectionsKt.listOf((Object)amount);
        }
        tank2.drain(amount - (int)notInjected.getStackSize(), true);
        return CollectionsKt.listOf((Object)((long)amount - notInjected.getStackSize()));
    }

    @Callback(doc="function(database:address, entry:number[, number:amount]):number -- Get fluid from your ae system.")
    @NotNull
    public final List<Object> requestFluids(@NotNull Context context, @NotNull Arguments args) {
        IAEFluidStack extracted;
        MultiTank tanks;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        String address = args.checkString(0);
        int entry = args.checkInteger(1);
        int amount = args.optInteger(2, 64);
        Agent agent = this.getAgent();
        if (agent == null) {
            Intrinsics.throwNpe();
        }
        int selected = agent.selectedSlot();
        Agent agent2 = this.getAgent();
        if (agent2 == null) {
            Intrinsics.throwNpe();
        }
        if ((tanks = agent2.tank()).tankCount() <= 0) {
            return CollectionsKt.listOf((Object)0);
        }
        IFluidTank tank2 = tanks.getFluidTank(selected);
        IMEMonitor<IAEFluidStack> inventory2 = this.getFluidInventory();
        if (tank2 == null || inventory2 == null) {
            return CollectionsKt.listOf((Object)0);
        }
        Node node = this.node().network().node(address);
        if (node == null) {
            throw (Throwable)new IllegalArgumentException("no such component");
        }
        Node node2 = node;
        if (!(node2 instanceof Component)) {
            throw (Throwable)new IllegalArgumentException("no such component");
        }
        Environment environment = node2.host();
        if (!(environment instanceof Database)) {
            throw (Throwable)new IllegalArgumentException("not a database");
        }
        FluidStack fluid = FluidHelper.getFluidFromContainer(((Database)environment).getStackInSlot(entry - 1));
        fluid.amount = amount;
        FluidStack fluid2 = fluid.copy();
        fluid2.amount = tank2.fill(fluid, false);
        if (fluid2.amount == 0) {
            return CollectionsKt.listOf((Object)0);
        }
        IAEFluidStack iAEFluidStack = extracted = (IAEFluidStack)inventory2.extractItems(StorageChannels.FLUID.createStack((Object)fluid2), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this.tile()));
        Intrinsics.checkExpressionValueIsNotNull((Object)iAEFluidStack, (String)"extracted");
        if (iAEFluidStack.getFluidStack().amount == 0) {
            return CollectionsKt.listOf((Object)0);
        }
        return CollectionsKt.listOf((Object)tank2.fill(extracted.getFluidStack(), true));
    }

    @Callback(doc="function():boolean -- Return true if the card is linked to your ae network.")
    @NotNull
    public final List<Object> isLinked(@NotNull Context context, @NotNull Arguments args) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        return CollectionsKt.listOf((Object)(this.getGrid() != null ? 1 : 0));
    }

    public void update() {
        super.update();
        World world = this.host().world();
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"host().world()");
        if ((int)(world.func_82737_E() % (long)10) == 0 && this.isActive) {
            Node node = this.node();
            if (node == null) {
                throw new TypeCastException("null cannot be cast to non-null type li.cil.oc.api.network.Connector");
            }
            Connector node2 = (Connector)node;
            if (node2.tryChangeBuffer(-this.getEnergy())) {
                this.isActive = false;
            }
        }
    }

    public final double getEnergy() {
        double d;
        ItemStack itemStack = this.getComponent();
        if (itemStack == null) {
            return 0.0;
        }
        ItemStack c = itemStack;
        switch (c.func_77952_i()) {
            case 0: {
                d = 0.6;
                break;
            }
            case 1: {
                d = 0.3;
                break;
            }
            default: {
                d = 0.05;
            }
        }
        return d;
    }

    public void onMessage(@Nullable Message message) {
        super.onMessage(message);
        Message message2 = message;
        if (message2 == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)message2.name(), (Object)"computer.stopped")) {
            this.isActive = false;
        } else if (Intrinsics.areEqual((Object)message.name(), (Object)"computer.started")) {
            this.isActive = true;
        }
    }
}

