/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.integration.opencomputers;

import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import com.the9grounds.aeadditions.api.IFluidInterface;
import com.the9grounds.aeadditions.integration.opencomputers.OCUtils;
import com.the9grounds.aeadditions.part.fluid.PartFluidInterface;
import com.the9grounds.aeadditions.registries.ItemEnum;
import com.the9grounds.aeadditions.registries.PartEnum;
import com.the9grounds.aeadditions.tileentity.TileEntityFluidInterface;
import com.the9grounds.aeadditions.util.FluidHelper;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DriverBlock;
import li.cil.oc.api.driver.EnvironmentProvider;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.internal.Database;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class DriverFluidInterface
implements DriverBlock,
EnvironmentProvider {
    public boolean worksWith(World world, BlockPos pos, EnumFacing facing) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return false;
        }
        PartFluidInterface partFluidInterface = (PartFluidInterface)OCUtils.getPart(world, pos, AEPartLocation.INTERNAL, PartFluidInterface.class);
        return partFluidInterface != null || tile instanceof IFluidInterface;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !(tile instanceof IPartHost) && !(tile instanceof IFluidInterface)) {
            return null;
        }
        return new Enviroment(tile);
    }

    public Class<?> getEnvironment(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() == ItemEnum.PARTITEM.getItem() && stack.func_77952_i() == PartEnum.INTERFACE.ordinal()) {
            return Enviroment.class;
        }
        return null;
    }

    public class Enviroment
    extends AbstractManagedEnvironment
    implements NamedBlock {
        protected final TileEntity tile;
        protected final IPartHost host;

        public Enviroment(TileEntity tile) {
            this.tile = tile;
            this.host = tile instanceof IPartHost ? (IPartHost)tile : null;
            this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent("me_interface").create());
        }

        @Callback(doc="function(side:number):table -- Get the configuration of the fluid interface on the specified direction.")
        public Object[] getFluidInterfaceConfiguration(Context context, Arguments args) {
            AEPartLocation dir = AEPartLocation.fromOrdinal((int)args.checkInteger(0));
            if (dir == null || dir == AEPartLocation.INTERNAL) {
                return new Object[]{null, "unknown side"};
            }
            if (this.tile instanceof TileEntityFluidInterface) {
                TileEntityFluidInterface fluidInterface = (TileEntityFluidInterface)this.tile;
                Fluid fluid = fluidInterface.getFilter(dir);
                if (fluid == null) {
                    return new Object[]{null};
                }
                return new Object[]{new FluidStack(fluid, 1000)};
            }
            PartFluidInterface part = (PartFluidInterface)OCUtils.getPart(this.tile.func_145831_w(), this.tile.func_174877_v(), dir, PartFluidInterface.class);
            if (part == null) {
                return new Object[]{null, "no interface"};
            }
            Fluid fluid = part.getFilter(dir);
            if (fluid == null) {
                return new Object[]{null};
            }
            return new Object[]{new FluidStack(fluid, 1000)};
        }

        @Callback(doc="function(side:number[, database:address, entry:number]):boolean -- Configure the filter in fluid interface on the specified direction.")
        public Object[] setFluidInterfaceConfiguration(Context context, Arguments args) {
            IFluidInterface part;
            AEPartLocation dir = AEPartLocation.fromOrdinal((int)args.checkInteger(0));
            if (dir == null || dir == AEPartLocation.INTERNAL) {
                return new Object[]{null, "unknown side"};
            }
            IFluidInterface iFluidInterface = part = this.tile instanceof IFluidInterface ? (IFluidInterface)this.tile : (IFluidInterface)OCUtils.getPart(this.tile.func_145831_w(), this.tile.func_174877_v(), dir, PartFluidInterface.class);
            if (part == null) {
                return new Object[]{null, "no export bus"};
            }
            if (args.count() != 3) {
                part.setFilter(dir, null);
                context.pause(0.5);
                return new Object[]{true};
            }
            String address = args.checkString(1);
            int entry = args.checkInteger(2);
            Node node = this.node().network().node(address);
            if (node == null) {
                throw new IllegalArgumentException("no such component");
            }
            if (!(node instanceof Component)) {
                throw new IllegalArgumentException("no such component");
            }
            Component component = (Component)node;
            Environment env = node.host();
            if (!(env instanceof Database)) {
                throw new IllegalArgumentException("not a database");
            }
            Database database = (Database)env;
            try {
                ItemStack data = database.getStackInSlot(entry - 1);
                if (data == null) {
                    part.setFilter(dir, null);
                } else {
                    FluidStack fluid = FluidHelper.getFluidFromContainer(data);
                    if (fluid == null || fluid.getFluid() == null) {
                        return new Object[]{false, "not a fluid container"};
                    }
                    part.setFilter(dir, fluid.getFluid());
                }
                context.pause(0.5);
                return new Object[]{true};
            }
            catch (Throwable e) {
                return new Object[]{false, "invalid slot"};
            }
        }

        public String preferredName() {
            return "me_interface";
        }

        public int priority() {
            return 0;
        }
    }
}

