/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.gui.gas;

import appeng.api.AEApi;
import appeng.api.config.RedstoneMode;
import com.the9grounds.aeadditions.container.gas.ContainerBusGasIO;
import com.the9grounds.aeadditions.gui.GuiBase;
import com.the9grounds.aeadditions.gui.IFluidSlotGuiTransfer;
import com.the9grounds.aeadditions.gui.ISlotRenderer;
import com.the9grounds.aeadditions.gui.SlotUpgradeRenderer;
import com.the9grounds.aeadditions.gui.buttons.ButtonRedstoneModes;
import com.the9grounds.aeadditions.gui.widget.fluid.WidgetFluidSlot;
import com.the9grounds.aeadditions.network.packet.other.IFluidSlotGui;
import com.the9grounds.aeadditions.network.packet.part.PacketPartConfig;
import com.the9grounds.aeadditions.part.gas.PartGasIO;
import com.the9grounds.aeadditions.util.FluidHelper;
import com.the9grounds.aeadditions.util.NetworkUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GuiBusGasIO
extends GuiBase<ContainerBusGasIO>
implements WidgetFluidSlot.IConfigurable,
IFluidSlotGui,
IFluidSlotGuiTransfer {
    private PartGasIO part;
    private byte filterSize;
    private List<WidgetFluidSlot> fluidSlotList = new ArrayList<WidgetFluidSlot>();
    private boolean redstoneControlled;
    private boolean hasNetworkTool;

    public GuiBusGasIO(PartGasIO terminal, EntityPlayer player) {
        super(new ResourceLocation("aeadditions", "textures/gui/busiofluid.png"), new ContainerBusGasIO(terminal, player));
        ((ContainerBusGasIO)this.field_147002_h).setGui(this);
        this.part = terminal;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int id = y + x * 3;
                byte configOption = (byte)((id + 1) % 2 + 1);
                if (id == 4) {
                    configOption = 0;
                }
                WidgetFluidSlot fluidSlot = new WidgetFluidSlot(this.widgetManager, this.part, id, 61 + x * 18, 21 + y * 18, this, configOption);
                this.widgetManager.add(fluidSlot);
                this.fluidSlotList.add(fluidSlot);
            }
        }
        NetworkUtil.sendToServer(new PacketPartConfig(this.part, "FluidIO.Info"));
        this.hasNetworkTool = this.field_147002_h.func_75138_a().size() > 40;
        this.field_146999_f = this.hasNetworkTool ? 246 : 211;
        this.field_147000_g = 184;
    }

    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        NetworkUtil.sendToServer(new PacketPartConfig(this.part, "FluidIO.Redstone.Loop"));
    }

    public void changeConfig(byte _filterSize) {
        this.filterSize = _filterSize;
    }

    @Override
    protected void drawBackground() {
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, 184);
        this.func_73729_b(this.field_147003_i + 179, this.field_147009_r, 179, 0, 32, 86);
        if (this.hasNetworkTool) {
            this.func_73729_b(this.field_147003_i + 179, this.field_147009_r + 93, 178, 93, 68, 68);
        }
    }

    @Override
    public byte getConfigState() {
        return this.filterSize;
    }

    protected Slot func_146975_c(int p_146975_1_, int p_146975_2_) {
        for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
            if (!this.isMouseOverSlot(slot, p_146975_1_, p_146975_2_)) continue;
            return slot;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot p_146981_1_, int p_146981_2_, int p_146981_3_) {
        return this.func_146978_c(p_146981_1_.field_75223_e, p_146981_1_.field_75221_f, 16, 16, p_146981_2_, p_146981_3_);
    }

    protected boolean func_146978_c(int top, int left, int height, int width, int pointX, int pointY) {
        int k1 = this.field_147003_i;
        int l1 = this.field_147009_r;
        return (pointX -= k1) >= top - 1 && pointX < top + height + 1 && (pointY -= l1) >= left - 1 && pointY < left + width + 1;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseBtn) throws IOException {
        ItemStack itemStack;
        Slot slot = this.func_146975_c(mouseX, mouseY);
        if (slot != null && (itemStack = slot.func_75211_c()) != null && itemStack.func_77969_a((ItemStack)AEApi.instance().definitions().items().networkTool().maybeStack(1).get())) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseBtn);
    }

    @Override
    protected boolean hasSlotRenders() {
        return true;
    }

    @Override
    @Nullable
    protected ISlotRenderer getSlotRenderer(Slot slot) {
        if ((slot.func_75211_c() == null || slot.func_75211_c().func_190926_b()) && slot.field_75222_d > 35) {
            return SlotUpgradeRenderer.INSTANCE;
        }
        return null;
    }

    public void setRedstoneControlled(boolean _redstoneControlled) {
        this.redstoneControlled = _redstoneControlled;
        this.field_146292_n.clear();
        if (this.redstoneControlled) {
            this.field_146292_n.add(new ButtonRedstoneModes(0, this.field_147003_i - 18, this.field_147009_r, 16, 16, this.part.getRedstoneMode()));
        }
    }

    @Override
    public boolean shiftClick(ItemStack itemStack) {
        FluidStack containerFluid = FluidHelper.getFluidFromContainer(itemStack);
        Fluid fluid = containerFluid == null ? null : containerFluid.getFluid();
        for (WidgetFluidSlot fluidSlot : this.fluidSlotList) {
            if (fluid == null || fluidSlot.getFluid() != null && fluidSlot.getFluid() != fluid || !fluidSlot.isVisable()) continue;
            fluidSlot.handleContainer(itemStack);
            return true;
        }
        return false;
    }

    @Override
    public void updateFluids(List<Fluid> fluidList) {
        for (int i = 0; i < this.fluidSlotList.size() && i < fluidList.size(); ++i) {
            this.fluidSlotList.get(i).setFluid(fluidList.get(i));
        }
    }

    public void updateRedstoneMode(RedstoneMode mode) {
        if (this.redstoneControlled && this.field_146292_n.size() > 0) {
            ((ButtonRedstoneModes)this.field_146292_n.get(0)).setRedstoneMode(mode);
        }
    }
}

