/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.gridblock;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import com.the9grounds.aeadditions.api.IECTileEntity;
import com.the9grounds.aeadditions.tileentity.IListenerTile;
import com.the9grounds.aeadditions.tileentity.TileEntityFluidFiller;
import com.the9grounds.aeadditions.util.StorageChannels;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class ECFluidGridBlock
implements IGridBlock {
    protected final IECTileEntity host;
    protected IGrid grid;
    protected int usedChannels;

    public ECFluidGridBlock(IECTileEntity host) {
        this.host = host;
    }

    public final EnumSet<EnumFacing> getConnectableSides() {
        return EnumSet.allOf(EnumFacing.class);
    }

    public EnumSet<GridFlags> getFlags() {
        return EnumSet.of(GridFlags.REQUIRE_CHANNEL);
    }

    public final AEColor getGridColor() {
        return AEColor.TRANSPARENT;
    }

    public double getIdlePowerUsage() {
        return this.host.getPowerUsage();
    }

    public final DimensionalCoord getLocation() {
        return this.host.getLocation();
    }

    public IGridHost getMachine() {
        return this.host;
    }

    public ItemStack getMachineRepresentation() {
        DimensionalCoord loc = this.getLocation();
        if (loc == null) {
            return null;
        }
        IBlockState blockState = loc.getWorld().func_180495_p(loc.getPos());
        Block block = blockState.func_177230_c();
        return new ItemStack(block, 1, block.func_176201_c(blockState));
    }

    public void gridChanged() {
    }

    public final boolean isWorldAccessible() {
        return true;
    }

    public void onGridNotification(GridNotification notification) {
    }

    public final void setNetworkStatus(IGrid grid, int usedChannels) {
        if (this.grid != null && this.host instanceof IListenerTile && this.grid != grid) {
            ((IListenerTile)((Object)this.host)).updateGrid(this.grid, grid);
            this.grid = grid;
            this.usedChannels = usedChannels;
            if (this.host instanceof TileEntityFluidFiller && this.grid.getCache(IStorageGrid.class) != null) {
                TileEntityFluidFiller fluidFiller = (TileEntityFluidFiller)this.host;
                IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
                fluidFiller.postChange((IBaseMonitor<IAEFluidStack>)storageGrid.getInventory((IStorageChannel)StorageChannels.FLUID), null, null);
            }
        } else {
            this.grid = grid;
            this.usedChannels = usedChannels;
        }
    }
}

