/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.container.fluid;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.the9grounds.aeadditions.api.IPortableFluidStorageCell;
import com.the9grounds.aeadditions.api.IWirelessFluidTermHandler;
import com.the9grounds.aeadditions.container.ContainerStorage;
import com.the9grounds.aeadditions.container.StorageType;
import com.the9grounds.aeadditions.util.AEUtils;
import com.the9grounds.aeadditions.util.FluidHelper;
import com.the9grounds.aeadditions.util.PlayerSource;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B3\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\fB3\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fB)\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/the9grounds/aeadditions/container/fluid/ContainerFluidStorage;", "Lcom/the9grounds/aeadditions/container/ContainerStorage;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/EnumHand;)V", "monitor", "Lappeng/api/storage/IMEMonitor;", "Lappeng/api/storage/data/IAEFluidStack;", "storageCell", "Lcom/the9grounds/aeadditions/api/IPortableFluidStorageCell;", "(Lappeng/api/storage/IMEMonitor;Lnet/minecraft/entity/player/EntityPlayer;Lcom/the9grounds/aeadditions/api/IPortableFluidStorageCell;Lnet/minecraft/util/EnumHand;)V", "handler", "Lcom/the9grounds/aeadditions/api/IWirelessFluidTermHandler;", "(Lappeng/api/storage/IMEMonitor;Lnet/minecraft/entity/player/EntityPlayer;Lcom/the9grounds/aeadditions/api/IWirelessFluidTermHandler;Lnet/minecraft/util/EnumHand;)V", "(Lappeng/api/storage/IMEMonitor;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/EnumHand;)V", "doWork", "", "AEAdditions-1.12.2"})
public final class ContainerFluidStorage
extends ContainerStorage {
    @Override
    public void doWork() {
        ItemStack itemStack = this.inventory.func_70301_a(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inventory.getStackInSlot(1)");
        ItemStack secondSlot = itemStack;
        if (secondSlot != null && !secondSlot.func_190926_b() && secondSlot.func_190916_E() >= secondSlot.func_77976_d()) {
            return;
        }
        ItemStack itemStack2 = this.inventory.func_70301_a(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"inventory.getStackInSlot(0)");
        ItemStack container = itemStack2;
        if (!FluidHelper.isFluidContainer(container)) {
            return;
        }
        if (this.monitor == null) {
            return;
        }
        ItemStack itemStack3 = container.func_77946_l();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"container.copy()");
        container = itemStack3;
        container.func_190920_e(1);
        if (FluidHelper.isDrainableFilledContainer(container)) {
            Pair<Integer, ItemStack> drainedContainer;
            FluidStack containerFluid = FluidHelper.getFluidFromContainer(container);
            IAEStack iAEStack = (IAEStack)AEUtils.createFluidStack(containerFluid);
            EntityPlayer entityPlayer = this.player;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"player");
            IAEFluidStack notInjected = (IAEFluidStack)this.monitor.injectItems(iAEStack, Actionable.SIMULATE, (IActionSource)new PlayerSource(entityPlayer, null));
            if (notInjected != null) {
                return;
            }
            ItemStack handItem = this.player.func_184586_b(this.hand);
            if (this.handler != null) {
                if (!this.handler.hasPower(this.player, 20.0, handItem)) {
                    return;
                }
                this.handler.usePower(this.player, 20.0, handItem);
            } else if (this.storageCell != null) {
                if (!this.storageCell.hasPower(this.player, 20.0, handItem)) {
                    return;
                }
                this.storageCell.usePower(this.player, 20.0, handItem);
            }
            Pair<Integer, ItemStack> pair = drainedContainer = FluidHelper.drainStack(container, containerFluid);
            Intrinsics.checkExpressionValueIsNotNull(pair, (String)"drainedContainer");
            if (this.fillSecondSlot((ItemStack)pair.getRight())) {
                IAEStack iAEStack2 = (IAEStack)AEUtils.createFluidStack(containerFluid);
                EntityPlayer entityPlayer2 = this.player;
                Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer2, (String)"player");
                this.monitor.injectItems(iAEStack2, Actionable.MODULATE, (IActionSource)new PlayerSource(entityPlayer2, null));
                this.decreaseFirstSlot();
            }
        } else if (FluidHelper.isFillableContainerWithRoom(container)) {
            Pair<Integer, ItemStack> filledContainer;
            int proposedAmount;
            if (this.selectedFluid == null) {
                return;
            }
            int capacity = FluidHelper.getCapacity(container, this.selectedFluid);
            IAEStack iAEStack = (IAEStack)AEUtils.createFluidStack(this.selectedFluid, (long)capacity);
            EntityPlayer entityPlayer = this.player;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"player");
            IAEFluidStack result2 = (IAEFluidStack)this.monitor.extractItems(iAEStack, Actionable.SIMULATE, (IActionSource)new PlayerSource(entityPlayer, null));
            int n = proposedAmount = result2 == null ? 0 : (int)Math.min((long)capacity, result2.getStackSize());
            if (proposedAmount == 0) {
                return;
            }
            Pair<Integer, ItemStack> pair = filledContainer = FluidHelper.fillStack(container, new FluidStack(this.selectedFluid, proposedAmount));
            Intrinsics.checkExpressionValueIsNotNull(pair, (String)"filledContainer");
            if (this.fillSecondSlot((ItemStack)pair.getRight())) {
                IAEStack iAEStack3 = (IAEStack)AEUtils.createFluidStack(this.selectedFluid, (long)((Number)filledContainer.getLeft()).intValue());
                EntityPlayer entityPlayer3 = this.player;
                Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer3, (String)"player");
                this.monitor.extractItems(iAEStack3, Actionable.MODULATE, (IActionSource)new PlayerSource(entityPlayer3, null));
                this.decreaseFirstSlot();
                IMEMonitor iMEMonitor = this.monitor;
                Intrinsics.checkExpressionValueIsNotNull((Object)iMEMonitor, (String)"monitor");
                IItemList iItemList = iMEMonitor.getStorageList();
                Intrinsics.checkExpressionValueIsNotNull((Object)iItemList, (String)"monitor.storageList");
                if (!CollectionsKt.contains((Iterable)((Iterable)iItemList), (Object)AEUtils.createFluidStack(this.selectedFluid, (long)capacity))) {
                    this.selectedFluid = null;
                }
            }
        }
    }

    public ContainerFluidStorage(@Nullable EntityPlayer player, @Nullable EnumHand hand) {
        super(StorageType.FLUID, player, hand);
    }

    public ContainerFluidStorage(@NotNull IMEMonitor<IAEFluidStack> monitor, @Nullable EntityPlayer player, @Nullable IPortableFluidStorageCell storageCell, @Nullable EnumHand hand) {
        Intrinsics.checkParameterIsNotNull(monitor, (String)"monitor");
        super(StorageType.FLUID, monitor, player, storageCell, hand);
    }

    public ContainerFluidStorage(@NotNull IMEMonitor<IAEFluidStack> monitor, @Nullable EntityPlayer player, @Nullable IWirelessFluidTermHandler handler, @Nullable EnumHand hand) {
        Intrinsics.checkParameterIsNotNull(monitor, (String)"monitor");
        super(StorageType.FLUID, monitor, player, handler, hand);
    }

    public ContainerFluidStorage(@NotNull IMEMonitor<IAEFluidStack> monitor, @Nullable EntityPlayer player, @Nullable EnumHand hand) {
        Intrinsics.checkParameterIsNotNull(monitor, (String)"monitor");
        super(StorageType.FLUID, monitor, player, hand);
    }
}

