/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.container;

import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import com.the9grounds.aeadditions.api.IPortableStorageCell;
import com.the9grounds.aeadditions.api.IWirelessGasFluidTermHandler;
import com.the9grounds.aeadditions.container.IFluidSelectorContainer;
import com.the9grounds.aeadditions.container.IStorageContainer;
import com.the9grounds.aeadditions.container.ITickContainer;
import com.the9grounds.aeadditions.container.StorageType;
import com.the9grounds.aeadditions.container.slot.SlotOutput;
import com.the9grounds.aeadditions.container.slot.SlotPlayerInventory;
import com.the9grounds.aeadditions.container.slot.SlotRespective;
import com.the9grounds.aeadditions.gui.GuiStorage;
import com.the9grounds.aeadditions.inventory.IInventoryListener;
import com.the9grounds.aeadditions.inventory.InventoryPlain;
import com.the9grounds.aeadditions.network.packet.part.PacketStorageSelectFluid;
import com.the9grounds.aeadditions.network.packet.part.PacketStorageUpdateFluid;
import com.the9grounds.aeadditions.network.packet.part.PacketStorageUpdateState;
import com.the9grounds.aeadditions.util.GuiUtil;
import com.the9grounds.aeadditions.util.NetworkUtil;
import com.the9grounds.aeadditions.util.StorageChannels;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ContainerStorage
extends Container
implements IMEMonitorHandlerReceiver<IAEFluidStack>,
IFluidSelectorContainer,
IInventoryListener,
IStorageContainer,
ITickContainer {
    protected EnumHand hand = EnumHand.MAIN_HAND;
    protected StorageType storageType;
    protected IItemList<IAEFluidStack> fluidStackList;
    protected Fluid selectedFluid;
    protected IAEFluidStack selectedFluidStack;
    protected EntityPlayer player;
    protected IMEMonitor<IAEFluidStack> monitor;
    protected ICellInventoryHandler<IAEFluidStack> storageFluid;
    protected IWirelessGasFluidTermHandler handler = null;
    protected IPortableStorageCell storageCell = null;
    public boolean hasWirelessTermHandler = false;
    protected InventoryPlain inventory;

    public ContainerStorage(StorageType storageType, EntityPlayer player, EnumHand hand) {
        this(storageType, null, player, hand);
    }

    public ContainerStorage(StorageType storageType, IMEMonitor<IAEFluidStack> monitor, EntityPlayer player, IPortableStorageCell storageCell, EnumHand hand) {
        this(storageType, monitor, player, hand);
        this.hasWirelessTermHandler = storageCell != null;
        this.storageCell = storageCell;
    }

    public ContainerStorage(StorageType storageType, IMEMonitor<IAEFluidStack> monitor, EntityPlayer player, IWirelessGasFluidTermHandler handler, EnumHand hand) {
        this(storageType, monitor, player, hand);
        this.hasWirelessTermHandler = handler != null;
        this.handler = handler;
    }

    public ContainerStorage(final StorageType storageType, IMEMonitor<IAEFluidStack> monitor, EntityPlayer player, EnumHand hand) {
        this.storageType = storageType;
        this.monitor = monitor;
        this.player = player;
        this.hand = hand;
        if (!this.player.field_70170_p.field_72995_K && this.monitor != null) {
            this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
            this.fluidStackList = this.monitor.getStorageList();
        } else {
            this.fluidStackList = StorageChannels.FLUID.createList();
        }
        this.inventory = new InventoryPlain("com.the9grounds.aeadditions.item." + storageType.getName() + ".storage", 2, 64, this){

            @Override
            public boolean func_94041_b(int i, ItemStack itemStack) {
                return storageType.isContainer(itemStack);
            }
        };
        this.func_75146_a(new SlotRespective(this.inventory, 0, 8, 92));
        this.func_75146_a(new SlotOutput(this.inventory, 1, 26, 92));
        this.bindPlayerInventory(this.player.field_71071_by);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotPlayerInventory((IInventory)inventoryPlayer, this, j + i * 9 + 9, 8 + j * 18, i * 18 + 122));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new SlotPlayerInventory((IInventory)inventoryPlayer, this, i, 8 + i * 18, 180));
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public void decreaseFirstSlot() {
        ItemStack slot = this.inventory.func_70301_a(0);
        if (slot == null || slot.func_190926_b()) {
            return;
        }
        slot.func_190920_e(slot.func_190916_E() - 1);
        if (slot.func_190916_E() <= 0) {
            this.inventory.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    @Override
    public void onTick() {
        this.forceFluidUpdate();
        this.doWork();
    }

    public abstract void doWork();

    public boolean fillSecondSlot(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        ItemStack handItem = this.player.func_184586_b(this.hand);
        ItemStack secondSlot = this.inventory.func_70301_a(1);
        if (secondSlot == null || secondSlot.func_190926_b()) {
            if (this.handler != null) {
                if (!this.handler.hasPower(this.player, 20.0, handItem)) {
                    return false;
                }
                this.handler.usePower(this.player, 20.0, handItem);
            } else if (this.storageCell != null) {
                if (!this.storageCell.hasPower(this.player, 20.0, handItem)) {
                    return false;
                }
                this.storageCell.usePower(this.player, 20.0, handItem);
            }
            this.inventory.func_70299_a(1, itemStack);
            return true;
        }
        if (!secondSlot.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)secondSlot)) {
            return false;
        }
        if (this.handler != null) {
            if (!this.handler.hasPower(this.player, 20.0, handItem)) {
                return false;
            }
            this.handler.usePower(this.player, 20.0, handItem);
        } else if (this.storageCell != null) {
            if (!this.storageCell.hasPower(this.player, 20.0, handItem)) {
                return false;
            }
            this.storageCell.usePower(this.player, 20.0, handItem);
        }
        this.inventory.incrStackSize(1, itemStack.func_190916_E());
        return true;
    }

    public void forceFluidUpdate() {
        if (this.monitor != null) {
            NetworkUtil.sendToPlayer(new PacketStorageUpdateFluid((IItemList<IAEFluidStack>)this.monitor.getStorageList()), this.player);
        }
        NetworkUtil.sendToPlayer(new PacketStorageUpdateState(this.hasWirelessTermHandler), this.player);
    }

    public IItemList<IAEFluidStack> getFluidStackList() {
        return this.fluidStackList;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public Fluid getSelectedFluid() {
        return this.selectedFluid;
    }

    public IAEFluidStack getSelectedFluidStack() {
        return this.selectedFluidStack;
    }

    @Override
    public boolean hasWirelessTermHandler() {
        return this.hasWirelessTermHandler;
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void func_75134_a(EntityPlayer entityPlayer) {
        super.func_75134_a(entityPlayer);
        if (!entityPlayer.field_70170_p.field_72995_K) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
            for (int i = 0; i < 2; ++i) {
                this.player.func_71019_a(((Slot)this.field_75151_b.get(i)).func_75211_c(), false);
            }
        }
    }

    @Override
    public void onInventoryChanged() {
    }

    public void onListUpdate() {
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, IActionSource actionSource) {
        this.fluidStackList = ((IMEMonitor)monitor).getStorageList();
        NetworkUtil.sendToPlayer(new PacketStorageUpdateFluid(this.fluidStackList), this.player);
        NetworkUtil.sendToPlayer(new PacketStorageUpdateState(this.hasWirelessTermHandler), this.player);
    }

    public void receiveSelectedFluid(Fluid _selectedFluid) {
        this.selectedFluid = _selectedFluid;
        if (this.selectedFluid != null) {
            for (IAEFluidStack stack : this.fluidStackList) {
                if (stack == null || stack.getFluid() != this.selectedFluid) continue;
                this.selectedFluidStack = stack;
                break;
            }
        } else {
            this.selectedFluidStack = null;
        }
        if (this.player.field_70170_p.field_72995_K) {
            this.updateGui();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateGui() {
        GuiStorage guiStorage = GuiUtil.getGui(GuiStorage.class);
        if (guiStorage == null) {
            return;
        }
        guiStorage.updateSelectedFluid();
    }

    public void removeEnergyTick() {
        ItemStack handItem = this.player.func_184586_b(this.hand);
        if (this.handler != null) {
            if (this.handler.hasPower(this.player, 1.0, handItem)) {
                this.handler.usePower(this.player, 1.0, handItem);
            }
        } else if (this.storageCell != null && this.storageCell.hasPower(this.player, 0.5, handItem)) {
            this.storageCell.usePower(this.player, 0.5, handItem);
        }
    }

    @Override
    public void setSelectedFluid(Fluid fluid) {
        NetworkUtil.sendToServer(new PacketStorageSelectFluid(fluid));
        this.receiveSelectedFluid(fluid);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotnumber) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotnumber);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (this.inventory.func_94041_b(0, itemstack1)) {
                if (slotnumber == 0 || slotnumber == 1 ? !this.func_75135_a(itemstack1, 2, 36, false) : !this.func_75135_a(itemstack1, 0, 1, false)) {
                    return ItemStack.field_190927_a;
                }
                if (itemstack1.func_190916_E() == 0) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
            } else {
                return ItemStack.field_190927_a;
            }
        }
        return itemstack;
    }

    public void updateFluidList(IItemList<IAEFluidStack> fluidStacks) {
        this.fluidStackList = fluidStacks;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }
}

