/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AEPartLocation;
import com.the9grounds.aeadditions.api.IAEAdditionsAPI;
import com.the9grounds.aeadditions.api.IExternalGasStorageHandler;
import com.the9grounds.aeadditions.api.IPortableFluidStorageCell;
import com.the9grounds.aeadditions.api.IPortableGasStorageCell;
import com.the9grounds.aeadditions.api.IWirelessFluidTermHandler;
import com.the9grounds.aeadditions.api.IWirelessGasFluidTermHandler;
import com.the9grounds.aeadditions.api.IWrenchHandler;
import com.the9grounds.aeadditions.api.definitions.IBlockDefinition;
import com.the9grounds.aeadditions.api.definitions.IItemDefinition;
import com.the9grounds.aeadditions.api.definitions.IPartDefinition;
import com.the9grounds.aeadditions.api.gas.IAEGasStack;
import com.the9grounds.aeadditions.definitions.BlockDefinition;
import com.the9grounds.aeadditions.definitions.ItemDefinition;
import com.the9grounds.aeadditions.definitions.PartDefinition;
import com.the9grounds.aeadditions.integration.Integration;
import com.the9grounds.aeadditions.integration.mekanism.gas.MekanismGas;
import com.the9grounds.aeadditions.network.GuiHandler;
import com.the9grounds.aeadditions.util.FuelBurnTime;
import com.the9grounds.aeadditions.util.GasStorageRegistry;
import com.the9grounds.aeadditions.util.GasUtil;
import com.the9grounds.aeadditions.util.MEMonitorHandler;
import com.the9grounds.aeadditions.util.StorageChannels;
import com.the9grounds.aeadditions.util.WrenchUtil;
import com.the9grounds.aeadditions.wireless.WirelessTermRegistry;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;

public class AEAdditionsApi
implements IAEAdditionsAPI {
    public static final IAEAdditionsAPI instance = new AEAdditionsApi();
    private final List<Class<? extends Fluid>> blacklistShowClass = new ArrayList<Class<? extends Fluid>>();
    private final List<Fluid> blacklistShowFluid = new ArrayList<Fluid>();
    private final List<Class<? extends Fluid>> blacklistStorageClass = new ArrayList<Class<? extends Fluid>>();
    private final List<Fluid> blacklistStorageFluid = new ArrayList<Fluid>();
    private final boolean isMekanismGasEnabled = Integration.Mods.MEKANISMGAS.isEnabled();

    @Override
    public void addFluidToShowBlacklist(Class<? extends Fluid> clazz) {
        if (clazz == null || clazz == Fluid.class) {
            return;
        }
        this.blacklistShowClass.add(clazz);
    }

    @Override
    public void addFluidToShowBlacklist(Fluid fluid) {
        if (fluid == null) {
            return;
        }
        this.blacklistShowFluid.add(fluid);
    }

    @Override
    public void addFluidToStorageBlacklist(Class<? extends Fluid> clazz) {
        if (clazz == null || clazz == Fluid.class) {
            return;
        }
        this.blacklistStorageClass.add(clazz);
    }

    @Override
    public void addFluidToStorageBlacklist(Fluid fluid) {
        if (fluid == null) {
            return;
        }
        this.blacklistStorageFluid.add(fluid);
    }

    @Override
    public IBlockDefinition blocks() {
        return BlockDefinition.instance;
    }

    @Override
    public boolean canFluidSeeInTerminal(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        if (this.blacklistShowFluid.contains(fluid)) {
            return false;
        }
        for (Class<? extends Fluid> clazz : this.blacklistShowClass) {
            if (!clazz.isInstance(fluid)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canStoreFluid(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        if (this.blacklistStorageFluid.contains(fluid)) {
            return false;
        }
        for (Class<? extends Fluid> clazz : this.blacklistStorageClass) {
            if (!clazz.isInstance(fluid)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getVersion() {
        return "1.3.8";
    }

    @Override
    public IWirelessGasFluidTermHandler getWirelessTermHandler(ItemStack is) {
        return WirelessTermRegistry.getWirelessTermHandler(is);
    }

    @Override
    public boolean isWirelessFluidTerminal(ItemStack is) {
        return WirelessTermRegistry.isWirelessItem(is);
    }

    @Override
    public IItemDefinition items() {
        return ItemDefinition.instance;
    }

    @Override
    public ItemStack openPortableFluidCellGui(EntityPlayer player, EnumHand hand, World world) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K || stack == null || stack.func_77973_b() == null) {
            return stack;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof IPortableFluidStorageCell)) {
            return stack;
        }
        ICellInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(stack, null, (IStorageChannel)StorageChannels.FLUID);
        if (handler == null) {
            return stack;
        }
        MEMonitorHandler fluidInventory = new MEMonitorHandler(handler, StorageChannels.FLUID);
        GuiHandler.launchGui(GuiHandler.getGuiId(3), player, hand, new Object[]{fluidInventory, item});
        return stack;
    }

    @Override
    public ItemStack openPortableGasCellGui(EntityPlayer player, EnumHand hand, World world) {
        if (!this.isMekanismGasEnabled) {
            return player.func_184586_b(hand);
        }
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K || stack == null || stack.func_77973_b() == null) {
            return stack;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof IPortableGasStorageCell)) {
            return stack;
        }
        ICellInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(stack, null, (IStorageChannel)StorageChannels.GAS);
        if (handler == null) {
            return stack;
        }
        MEMonitorHandler<IAEGasStack> fluidInventory = new MEMonitorHandler<IAEGasStack>((IMEInventoryHandler<IAEGasStack>)handler, StorageChannels.GAS);
        GuiHandler.launchGui(GuiHandler.getGuiId(6), player, hand, new Object[]{fluidInventory, item});
        return stack;
    }

    @Override
    public ItemStack openWirelessFluidTerminal(EntityPlayer player, EnumHand hand, World world) {
        Long key;
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return stack;
        }
        if (!this.isWirelessFluidTerminal(stack)) {
            return stack;
        }
        IWirelessGasFluidTermHandler handler = this.getWirelessTermHandler(stack);
        if (!handler.hasPower(player, 1.0, stack)) {
            return stack;
        }
        try {
            key = Long.parseLong(handler.getEncryptionKey(stack));
        }
        catch (Throwable ignored) {
            return stack;
        }
        return this.openWirelessTerminal(player, stack, world, player.func_180425_c(), key, 1, hand, (IStorageChannel)StorageChannels.FLUID);
    }

    @Override
    public ItemStack openWirelessGasTerminal(EntityPlayer player, EnumHand hand, World world) {
        Long key;
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return stack;
        }
        if (!this.isWirelessFluidTerminal(stack)) {
            return stack;
        }
        IWirelessGasFluidTermHandler handler = this.getWirelessTermHandler(stack);
        if (!handler.hasPower(player, 1.0, stack)) {
            return stack;
        }
        try {
            key = Long.parseLong(handler.getEncryptionKey(stack));
        }
        catch (Throwable ignored) {
            return stack;
        }
        return this.openWirelessTerminal(player, stack, world, player.func_180425_c(), key, 5, hand, StorageChannels.GAS);
    }

    private ItemStack openWirelessTerminal(EntityPlayer player, ItemStack itemStack, World world, BlockPos pos, Long key, int guiId, EnumHand hand, IStorageChannel channel) {
        if (world.field_72995_K) {
            return itemStack;
        }
        IGridHost securityTerminal = (IGridHost)AEApi.instance().registries().locatable().getLocatableBy(key.longValue());
        if (securityTerminal == null) {
            return itemStack;
        }
        IGridNode gridNode = securityTerminal.getGridNode(AEPartLocation.INTERNAL);
        if (gridNode == null) {
            return itemStack;
        }
        IGrid grid = gridNode.getGrid();
        if (grid == null) {
            return itemStack;
        }
        for (IGridNode node : grid.getMachines((Class)AEApi.instance().definitions().blocks().wirelessAccessPoint().maybeEntity().get())) {
            IMEMonitor fluidInventory;
            IStorageGrid gridCache;
            IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)node.getMachine();
            BlockPos distance = accessPoint.getLocation().getPos().func_177973_b((Vec3i)pos);
            int squaredDistance = distance.func_177958_n() * distance.func_177958_n() + distance.func_177956_o() * distance.func_177956_o() + distance.func_177952_p() * distance.func_177952_p();
            if (!((double)squaredDistance <= accessPoint.getRange() * accessPoint.getRange()) || (gridCache = (IStorageGrid)grid.getCache(IStorageGrid.class)) == null || (fluidInventory = gridCache.getInventory(channel)) == null) continue;
            GuiHandler.launchGui(GuiHandler.getGuiId(guiId), player, hand, new Object[]{fluidInventory, this.getWirelessTermHandler(itemStack)});
        }
        return itemStack;
    }

    @Override
    public IPartDefinition parts() {
        return PartDefinition.instance;
    }

    @Override
    public void registerWirelessTermHandler(IWirelessGasFluidTermHandler handler) {
        WirelessTermRegistry.registerWirelessTermHandler(handler);
    }

    @Override
    public void registerWirelessFluidTermHandler(IWirelessFluidTermHandler handler) {
        this.registerWirelessTermHandler(handler);
    }

    @Override
    @Deprecated
    public void registryWirelessFluidTermHandler(IWirelessFluidTermHandler handler) {
        this.registerWirelessFluidTermHandler(handler);
    }

    @Override
    public void registerFuelBurnTime(Fluid fuel, int burnTime) {
        FuelBurnTime.registerFuel(fuel, burnTime);
    }

    @Override
    public boolean isGasStack(IAEFluidStack stack) {
        return stack != null && this.isGasStack(stack.getFluidStack());
    }

    @Override
    public boolean isGasStack(FluidStack stack) {
        return stack != null && this.isGas(stack.getFluid());
    }

    @Override
    public boolean isGas(Fluid fluid) {
        return fluid != null && this.isMekanismGasEnabled && this.checkGas(fluid);
    }

    @Override
    public Object createGasStack(IAEFluidStack stack) {
        return Integration.Mods.MEKANISMGAS.isEnabled() ? this.createGasFromFluidStack(stack) : null;
    }

    @Override
    public IAEFluidStack createFluidStackFromGas(Object gasStack) {
        return this.isMekanismGasEnabled ? this.createFluidStackFromGasStack(gasStack) : null;
    }

    @Override
    public Fluid getGasFluid(Object gas) {
        return this.isMekanismGasEnabled ? this.createFluidFromGas(gas) : null;
    }

    @Override
    public void addExternalStorageInterface(IExternalGasStorageHandler esh) {
        if (this.isMekanismGasEnabled) {
            GasStorageRegistry.addExternalStorageInterface(esh);
        }
    }

    @Override
    public IExternalGasStorageHandler getHandler(TileEntity te, EnumFacing opposite, IActionSource mySrc) {
        return this.isMekanismGasEnabled ? GasStorageRegistry.getHandler(te, opposite, mySrc) : null;
    }

    @Override
    public boolean isGasSystemEnabled() {
        return this.isMekanismGasEnabled;
    }

    @Override
    public void registerWrenchHandler(IWrenchHandler wrenchHandler) {
        WrenchUtil.addWrenchHandler(wrenchHandler);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    private IAEFluidStack createFluidStackFromGasStack(Object gasStack) {
        return gasStack instanceof GasStack ? GasUtil.createAEFluidStack((GasStack)gasStack) : null;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    private Fluid createFluidFromGas(Object gas) {
        return gas instanceof Gas ? (MekanismGas.fluidGas.containsKey(gas) ? MekanismGas.fluidGas.get(gas) : null) : null;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    private Object createGasFromFluidStack(IAEFluidStack stack) {
        return stack == null ? null : GasUtil.getGasStack(stack.getFluidStack());
    }

    @Optional.Method(modid="MekanismAPI|gas")
    private boolean checkGas(Fluid fluid) {
        return fluid instanceof MekanismGas.GasFluid;
    }
}

